# 画面設計書 10-チェックポイント

## 概要

本ドキュメントは、Apache Flink Web Dashboardのチェックポイント画面の設計仕様を記述したものである。本画面はジョブのチェックポイント情報を表示する。

### 本画面の処理概要

チェックポイント画面は、ジョブのチェックポイント統計情報、設定情報、履歴を表示する。チェックポイントの成功/失敗状況、サイズ、所要時間などの詳細情報を確認できる。

**業務上の目的・背景**：ストリーム処理におけるフォールトトレランス機能の要であるチェックポイントの監視は、運用上極めて重要である。本画面により、チェックポイントの健全性を確認し、設定が適切かどうか評価し、問題発生時には原因究明を行うことができる。

**画面へのアクセス方法**：ジョブ詳細画面の「Checkpoints」タブをクリック、または`/job/:status/:jid/checkpoints`パスに直接アクセスする。

**主要な操作・処理内容**：
1. チェックポイント統計情報の表示（カウント、サマリー、最新情報）
2. チェックポイント設定情報の表示
3. チェックポイント履歴の一覧表示
4. 個別チェックポイントの詳細表示
5. 手動リフレッシュ機能

**画面遷移**：
- 遷移元：ジョブ詳細画面
- 遷移先：なし（本画面内で完結）

**権限による表示制御**：本画面に関しては、特別な権限制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | チェックポイント統計・設定情報の取得（/jobs/{jobid}/checkpoints API） |
| 26 | チェックポイント | 補助機能 | チェックポイント履歴、詳細、サブタスク情報の表示 |

## 画面種別

詳細 / 一覧

## URL/ルーティング

- パス: `/job/:status/:jid/checkpoints`

## 入出力項目

| 項目名 | 種別 | データ型 | 説明 |
|--------|------|----------|------|
| jid | URLパラメータ | string | ジョブID（親から継承） |

## 表示項目

### チェックポイントカウント

| 項目名 | データ型 | 説明 | 取得元 |
|--------|----------|------|--------|
| Triggered | number | トリガーされたチェックポイント総数 | `/jobs/{jobid}/checkpoints` API |
| In Progress | number | 進行中のチェックポイント数 | 同上 |
| Completed | number | 完了したチェックポイント数 | 同上 |
| Failed | number | 失敗したチェックポイント数 | 同上 |
| Restored | number | 復元されたチェックポイント数 | 同上 |

### チェックポイントサマリー

| 項目名 | データ型 | 説明 | 取得元 |
|--------|----------|------|--------|
| Checkpointed Data Size | MinMaxAvg | チェックポイントされたデータサイズ | `/jobs/{jobid}/checkpoints` API |
| State Size | MinMaxAvg | 状態サイズ | 同上 |
| End to End Duration | MinMaxAvg | 開始から終了までの所要時間 | 同上 |
| Processed Data | MinMaxAvg | 処理されたデータ量 | 同上 |
| Persisted Data | MinMaxAvg | 永続化されたデータ量 | 同上 |

### チェックポイント設定

| 項目名 | データ型 | 説明 | 取得元 |
|--------|----------|------|--------|
| Checkpointing Mode | string | チェックポイントモード（exactly_once等） | `/jobs/{jobid}/checkpoints/config` API |
| Interval | number | チェックポイント間隔 | 同上 |
| Timeout | number | タイムアウト時間 | 同上 |
| Minimum Pause | number | 最小休止時間 | 同上 |
| Maximum Concurrent | number | 最大同時実行数 | 同上 |
| Externalization | object | 外部化設定 | 同上 |
| State Backend | string | 状態バックエンド | 同上 |
| Unaligned Checkpoints | boolean | 非整列チェックポイント有効化 | 同上 |

### チェックポイント履歴

| 項目名 | データ型 | 説明 | 取得元 |
|--------|----------|------|--------|
| ID | number | チェックポイントID | `/jobs/{jobid}/checkpoints` API |
| Status | string | ステータス（COMPLETED/FAILED等） | 同上 |
| Trigger Time | timestamp | トリガー時刻 | 同上 |
| End to End Duration | duration | 所要時間 | 同上 |
| Checkpointed Data Size | bytes | チェックポイントデータサイズ | 同上 |
| State Size | bytes | 状態サイズ | 同上 |
| Is Savepoint | boolean | セーブポイントかどうか | 同上 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化時（ngOnInit）

**処理フロー**:
1. refresh$サブジェクトを設定
2. forkJoinでcheckpointStatsとcheckpointConfigを並列取得
3. JobLocalService.jobDetailChanges()をサブスクライブ
4. ジョブ詳細を受信したらrefresh$をトリガー

**API呼び出し**:
- GET `/jobs/{jobid}/checkpoints`
- GET `/jobs/{jobid}/checkpoints/config`

### 2-チェックポイント情報取得

**トリガー**: refresh$イベント発火

**処理フロー**:
1. forkJoinで統計情報と設定情報を並列取得
2. 各APIのエラーはcatchErrorでundefinedに変換
3. checkPointStatsとcheckPointConfigに結果を設定
4. 画面を更新

### 3-手動リフレッシュ

**トリガー**: リフレッシュボタンクリック

**処理フロー**:
1. refresh()が呼び出される
2. refresh$.next()でデータ再取得をトリガー

### 4-詳細パネル展開

**トリガー**: 「More details」パネルをクリック

**処理フロー**:
1. moreDetailsPanel.activeをトグル
2. 展開時に詳細情報（Latest Completed/Savepoint/Failed/Restored）を表示

## データベース更新仕様

本画面はデータ参照のみを行い、データベースへの更新処理は発生しない。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 該当なし | - | SELECT | 全ての操作は参照のみ |

## メッセージ仕様

本画面では明示的なメッセージ表示は行われない（NzEmptyModuleで空状態を表示）。

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| 統計取得エラー | `/jobs/{jobid}/checkpoints` APIエラー | catchErrorでundefinedを返却 |
| 設定取得エラー | `/jobs/{jobid}/checkpoints/config` APIエラー | catchErrorでundefinedを返却 |

## 備考

- disabledIntervalは0x7ffffffffffffff（Long最大値）で、チェックポイントが無効な場合の間隔値
- forkJoinで2つのAPIを並列呼び出し
- catchErrorで個別のAPI失敗を許容（片方のみ取得成功でも表示可能）
- JobCheckpointsDetailComponentで個別チェックポイントの詳細を表示
- CheckpointBadgeComponentでステータスを視覚的に表示
- HumanizeBytesPipe、HumanizeDurationPipeでデータサイズと時間をフォーマット

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-checkpoint.ts | `src/app/interfaces/job-checkpoint.ts` | Checkpoint型、CheckpointConfig型、CheckpointHistory型の定義 |

**読解のコツ**: Checkpoint型はcounts, summary, latestの3つの主要セクションを持つ。latestにはcompleted, savepoint, failed, restoredの情報が含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-checkpoints.component.ts | `src/app/pages/job/checkpoints/job-checkpoints.component.ts` | メインコンポーネント |

**主要処理フロー**:
1. **85-108行目**: ngOnInit()でrefresh$とデータ取得を設定
2. **86-108行目**: forkJoinで統計と設定を並列取得
3. **129-131行目**: refresh()メソッドで手動リフレッシュ

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job.service.ts | `src/app/services/job.service.ts` | loadCheckpointStats(), loadCheckpointConfig()メソッド |

**主要処理フロー**:
- **157-159行目**: loadCheckpointStats() - `/jobs/{jobid}/checkpoints`呼び出し
- **161-163行目**: loadCheckpointConfig() - `/jobs/{jobid}/checkpoints/config`呼び出し

### プログラム呼び出し階層図

```
JobCheckpointsComponent
    │
    ├─ ngOnInit()
    │      ├─ refresh$.subscribe()
    │      └─ jobDetailChanges().subscribe()
    │
    ├─ JobLocalService.jobDetailChanges()
    │      └─ ジョブ詳細の取得
    │
    ├─ forkJoin()
    │      ├─ JobService.loadCheckpointStats()
    │      │      └─ GET /jobs/{jobid}/checkpoints
    │      │
    │      └─ JobService.loadCheckpointConfig()
    │             └─ GET /jobs/{jobid}/checkpoints/config
    │
    ├─ JobCheckpointsDetailComponent（子）
    │      └─ 詳細情報表示
    │
    └─ refresh()
           └─ refresh$.next()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

JobLocalService ─────────▶ jobDetail受信
                              │
                              ▼
                        refresh$.next()
                              │
                              ▼
                        forkJoin()
                              │
                        ┌─────┴─────┐
                        │           │
                        ▼           ▼
                   loadStats    loadConfig
                        │           │
                        ▼           ▼
                   /checkpoints  /checkpoints/config
                        │           │
                        └─────┬─────┘
                              │
                              ▼
                        checkPointStats + checkPointConfig
                              │
                              ├──▶ カウント表示
                              ├──▶ サマリー表示
                              ├──▶ 設定表示
                              └──▶ 履歴表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-checkpoints.component.ts | `src/app/pages/job/checkpoints/job-checkpoints.component.ts` | ソース | メインコンポーネント |
| job-checkpoints.component.html | `src/app/pages/job/checkpoints/job-checkpoints.component.html` | テンプレート | レイアウト |
| job-checkpoints.component.less | `src/app/pages/job/checkpoints/job-checkpoints.component.less` | スタイル | スタイル定義 |
| job-checkpoints-detail.component.ts | `src/app/pages/job/checkpoints/detail/job-checkpoints-detail.component.ts` | ソース | 詳細コンポーネント |
| job.service.ts | `src/app/services/job.service.ts` | ソース | チェックポイント取得 |
| job-checkpoint.ts | `src/app/interfaces/job-checkpoint.ts` | 型定義 | チェックポイント型 |
| checkpoint-badge.component.ts | `src/app/components/checkpoint-badge/checkpoint-badge.component.ts` | ソース | ステータスバッジ |
| humanize-bytes.pipe.ts | `src/app/components/humanize-bytes.pipe.ts` | パイプ | バイト数フォーマット |
| humanize-duration.pipe.ts | `src/app/components/humanize-duration.pipe.ts` | パイプ | 時間フォーマット |
