# 画面設計書 11-ジョブ設定

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「ジョブ設定」画面の設計仕様を記載したものである。選択されたジョブの実行設定パラメータを表示する参照画面。

### 本画面の処理概要

ジョブ設定画面は、Flinkジョブの実行構成（Execution Configuration）とユーザー定義設定（User Configuration）を一覧形式で表示する画面である。運用担当者やデベロッパーがジョブのパラメータを確認し、トラブルシューティングやパフォーマンス最適化の参考とするために使用される。

**業務上の目的・背景**：ストリーム処理基盤であるApache Flinkでは、ジョブの並列度、再起動戦略、オブジェクト再利用モードなどの設定がパフォーマンスや耐障害性に大きく影響する。本画面により、運用担当者は実行中または完了済みのジョブがどのような設定で実行されたかを確認でき、問題発生時の原因調査や設定変更時の比較検討に活用できる。

**画面へのアクセス方法**：ジョブ一覧画面（実行中または完了済み）からジョブを選択し、ジョブ詳細画面に遷移後、タブナビゲーションの「Job Configuration」タブをクリックすることでアクセスする。

**主要な操作・処理内容**：
1. 画面表示時にジョブ設定情報をREST API経由で取得
2. 実行設定（Execution Configuration）カードに再起動戦略、ジョブ並列度、オブジェクト再利用モードを表示
3. ユーザー設定（User Configuration）カードにユーザー定義のキー・バリューペアをソート済みで表示

**画面遷移**：
- 遷移元：ジョブ詳細画面（タブナビゲーション経由）
- 遷移先：なし（参照専用画面）

**権限による表示制御**：特になし。認証されたユーザーであれば閲覧可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | ジョブ設定情報の取得（/jobs/{jobid}/config API） |
| 4 | 設定管理 | 補助機能 | 実行パラメータ、並列度などの設定表示 |

## 画面種別

詳細（参照専用）

## URL/ルーティング

- パス: `/job/running/:jid/configuration` または `/job/completed/:jid/configuration`
- ルートパラメータ: `jid` - ジョブID

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ジョブID | jid | string | 必須 | URLパラメータから取得されるジョブ識別子 |

### 出力項目（API取得）

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ジョブID | jid | string | ジョブの一意識別子 |
| ジョブ名 | name | string | ジョブの名称 |
| 再起動戦略 | execution-config.restart-strategy | string | 障害時の再起動戦略 |
| ジョブ並列度 | execution-config.job-parallelism | number | ジョブの並列度（-1の場合は「auto」と表示） |
| オブジェクト再利用モード | execution-config.object-reuse-mode | boolean | オブジェクト再利用の有効/無効 |
| ユーザー設定 | execution-config.user-config | object | キー・バリュー形式のユーザー定義設定 |

## 表示項目

### Execution Configurationカード

| 表示項目 | 対応データ | 説明 |
|----------|-----------|------|
| Max. number of execution retries | restart-strategy | 再起動戦略の文字列表現 |
| Job parallelism | job-parallelism | 並列度（-1の場合は「auto」） |
| Object reuse mode | object-reuse-mode | true/false |

### User Configurationカード

| 表示項目 | 対応データ | 説明 |
|----------|-----------|------|
| キー | user-config各エントリのキー | 設定キー名 |
| バリュー | user-config各エントリの値 | 設定値 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化（ngOnInit）

**処理フロー**:
1. JobLocalServiceからジョブ詳細の変更を購読
2. ジョブIDを取得し、JobService.loadJobConfig()を呼び出し
3. APIレスポンスを受信し、configプロパティに格納
4. ユーザー設定をキー名でソートしてlistOfUserConfigに格納
5. ChangeDetectorRef.markForCheck()で画面を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | REST API経由でジョブ設定を取得（DBへの直接アクセスなし） |

本画面は参照専用であり、データベースへの更新処理は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | - | - | 本画面にはメッセージ表示機能なし |

## 例外処理

| 例外状況 | 対応 | 表示 |
|---------|------|------|
| API通信エラー | RxJSのcatchError未実装のため、エラーはコンソールに出力 | 設定情報が表示されない |
| ジョブが存在しない | 親コンポーネント（ジョブ詳細）でハンドリング | ジョブ詳細画面でエラー表示 |

## 備考

- ユーザー設定はキー名のアルファベット順でソートされて表示される
- ジョブ並列度が-1の場合は「auto」と表示され、Flinkが自動的に並列度を決定することを示す
- ng-zorro-antdのNzCardModuleとNzTableModuleを使用したカード形式のUI

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、APIから取得するデータの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-config.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-config.ts` | JobConfigインターフェースの構造。jid, name, execution-configのネスト構造を確認 |

**読解のコツ**: TypeScriptのインターフェース定義。`execution-config`はハイフン区切りのキーを使用しているため、プロパティアクセスには`config['execution-config']`形式が必要。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-configuration.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/configuration/job-configuration.component.ts` | コンポーネントのライフサイクルとデータバインディング |

**主要処理フロー**:
1. **50-69行目**: ngOnInit()でJobLocalServiceの購読を開始し、ジョブ詳細変更を監視
2. **54行目**: mergeMapでjobService.loadJobConfig()を呼び出し
3. **59-67行目**: ユーザー設定をキー順にソートしてlistOfUserConfigに格納

#### Step 3: サービス層を理解する

API呼び出しを行うサービスクラスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | loadJobConfig()メソッドの実装 |

**主要処理フロー**:
- **84-86行目**: loadJobConfig()がGETリクエストで`/jobs/${jobId}/config`を呼び出し

#### Step 4: ローカルサービスを理解する

ジョブ詳細情報を管理するローカルサービスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | ReplaySubjectによるジョブ詳細の状態管理 |

**主要処理フロー**:
- **53-55行目**: jobDetailChanges()がジョブ詳細のObservableを返却

### プログラム呼び出し階層図

```
JobConfigurationComponent.ngOnInit()
    │
    ├─ JobLocalService.jobDetailChanges()
    │      └─ ReplaySubject<JobDetailCorrect>を購読
    │
    └─ JobService.loadJobConfig(jid)
           └─ HttpClient.get(`/jobs/${jid}/config`)
                  └─ REST API: GET /jobs/{jobid}/config
```

### データフロー図

```
[入力]               [処理]                    [出力]

ジョブID ───▶ JobService.loadJobConfig() ───▶ JobConfig
   (URL)            │
                    ▼
              HTTPリクエスト
                    │
                    ▼
            REST API サーバー
                    │
                    ▼
              レスポンスJSON ───▶ 画面表示
                                   ├─ Execution Configuration
                                   └─ User Configuration（ソート済み）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-configuration.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/configuration/job-configuration.component.ts` | ソース | メインコンポーネント |
| job-configuration.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/configuration/job-configuration.component.html` | テンプレート | 画面レイアウト定義 |
| job-configuration.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job/configuration/job-configuration.component.less` | スタイル | スタイル定義 |
| job-config.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-config.ts` | インターフェース | JobConfigデータ型定義 |
| job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | サービス | API呼び出しサービス |
| job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | サービス | ジョブ状態管理サービス |
| routes.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/routes.ts` | 設定 | ルーティング定義 |
