# 画面設計書 12-クラスター設定

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「クラスター設定」画面の設計仕様を記載したものである。完了済みジョブ（History Server経由）のクラスター設定情報と環境情報を表示する参照画面。

### 本画面の処理概要

クラスター設定画面は、History Server経由でアーカイブされた完了済みジョブに関連するJobManagerの設定情報と環境情報を表示する画面である。運用担当者がジョブ実行時のクラスター構成を事後確認するために使用される。

**業務上の目的・背景**：Apache Flinkでは、ジョブ完了後もHistory Serverを通じてジョブの実行履歴を参照できる。本画面では、完了済みジョブが実行された際のJobManagerの設定パラメータや環境情報（JVM情報、クラスパスなど）を確認でき、過去のジョブ実行環境の監査やトラブルシューティングに活用できる。実行中のジョブには表示されない、History Server専用の機能である。

**画面へのアクセス方法**：完了済みジョブ一覧画面からジョブを選択し、ジョブ詳細画面に遷移後、タブナビゲーションの「Cluster Configuration」タブをクリックすることでアクセスする。History Server環境でのみ表示される。

**主要な操作・処理内容**：
1. 画面表示時にルートパラメータからジョブIDを取得
2. History Server用APIでクラスター設定と環境情報を並行取得
3. 設定情報をキー名でソートして表示
4. ConfigurationCardsコンポーネントで統一されたカード形式で表示

**画面遷移**：
- 遷移元：ジョブ詳細画面（タブナビゲーション経由）
- 遷移先：なし（参照専用画面）

**権限による表示制御**：ClusterConfigGuardによりHistory Server環境でのみアクセス可能。通常のFlink Web UI環境では表示されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | 完了済みジョブのクラスター設定取得（History Server経由） |
| 4 | 設定管理 | 補助機能 | JobManager設定・環境情報の表示 |

## 画面種別

詳細（参照専用）

## URL/ルーティング

- パス: `/job/completed/:jid/cluster_configuration`
- ルートパラメータ: `jid` - ジョブID
- ガード: ClusterConfigGuard（History Server環境でのみアクセス許可）

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ジョブID | jid | string | 必須 | URLパラメータから取得されるジョブ識別子 |

### 出力項目（API取得）

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| クラスター設定 | configurations | ClusterConfiguration[] | キー・バリュー形式の設定一覧 |
| 環境情報 | environmentInfo | EnvironmentInfo | JVM情報、クラスパスなどの環境情報 |

## 表示項目

### Job Manager Configurationカード

| 表示項目 | 対応データ | 説明 |
|----------|-----------|------|
| 設定キー | configurations[].key | 設定パラメータ名 |
| 設定値 | configurations[].value | 設定パラメータ値 |

### Environment Information

| 表示項目 | 対応データ | 説明 |
|----------|-----------|------|
| JVM情報 | environmentInfo.jvm | Java VMの情報 |
| クラスパス | environmentInfo.classpath | クラスパス設定 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化（ngOnInit）

**処理フロー**:
1. ActivatedRouteからジョブID（parent.snapshot.params.jid）を取得
2. forkJoinで以下の2つのAPIを並行呼び出し：
   - JobManagerService.loadHistoryServerConfig(jobId)
   - JobManagerService.loadHistoryServerEnvironment(jobId)
3. catchErrorで各APIのエラーをハンドリング（空配列/undefinedを返却）
4. 設定情報をキー名でソートしてconfigurationsに格納
5. 環境情報をenvironmentInfoに格納
6. loadingフラグをfalseに設定し、ChangeDetectorRef.markForCheck()で画面を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | REST API経由でクラスター設定を取得（DBへの直接アクセスなし） |

本画面は参照専用であり、データベースへの更新処理は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | - | - | 本画面にはメッセージ表示機能なし |

## 例外処理

| 例外状況 | 対応 | 表示 |
|---------|------|------|
| クラスター設定取得エラー | catchErrorで空配列を返却 | 設定一覧が空で表示 |
| 環境情報取得エラー | catchErrorでundefinedを返却 | 環境情報が非表示 |
| History Server以外からのアクセス | ClusterConfigGuardでブロック | 画面にアクセス不可 |

## 備考

- 本画面はHistory Server環境専用であり、通常のFlink Web Dashboard環境では表示されない
- ConfigurationCardsコンポーネント（共通コンポーネント）を使用して統一されたUI表示を実現
- 設定情報はキー名のアルファベット順でソートされる
- forkJoinにより2つのAPI呼び出しが並行実行されるため、パフォーマンスが最適化されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、APIから取得するデータの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configuration.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/configuration.ts` | ClusterConfigurationとEnvironmentInfoインターフェースの構造 |

**読解のコツ**: TypeScriptのインターフェース定義。ClusterConfigurationはkey-value形式、EnvironmentInfoはJVM情報やクラスパスを含むオブジェクト構造。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cluster-config.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/cluster-config/cluster-config.component.ts` | コンポーネントのライフサイクルとforkJoinによる並行API呼び出し |

**主要処理フロー**:
1. **49行目**: ActivatedRouteからジョブIDを取得（parent!.snapshot.params.jid）
2. **50-55行目**: forkJoinで2つのAPIを並行呼び出し
3. **52-54行目**: catchErrorで各APIのエラーハンドリング
4. **57-61行目**: レスポンスを処理し、設定をソートして格納

#### Step 3: サービス層を理解する

API呼び出しを行うサービスクラスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | loadHistoryServerConfig()とloadHistoryServerEnvironment()メソッドの実装 |

**主要処理フロー**:
- **114-117行目**: loadHistoryServerConfig()がGETリクエストで`/jobs/${jobId}/jobmanager/config`を呼び出し
- **120-121行目**: loadHistoryServerEnvironment()がGETリクエストで`/jobs/${jobId}/jobmanager/environment`を呼び出し

#### Step 4: ルートガードを理解する

History Server環境でのみアクセスを許可するガードを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cluster-config.guard.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/cluster-config.guard.ts` | CanActivateGuardの実装 |

### プログラム呼び出し階層図

```
ClusterConfigComponent.ngOnInit()
    │
    ├─ ActivatedRoute.parent.snapshot.params.jid
    │      └─ ジョブIDを取得
    │
    └─ forkJoin([
           │
           ├─ JobManagerService.loadHistoryServerConfig(jobId)
           │      └─ HttpClient.get(`/jobs/${jobId}/jobmanager/config`)
           │
           └─ JobManagerService.loadHistoryServerEnvironment(jobId)
                  └─ HttpClient.get(`/jobs/${jobId}/jobmanager/environment`)
       ])
```

### データフロー図

```
[入力]               [処理]                         [出力]

ジョブID ───▶ forkJoin([                    ───▶ ConfigurationCards
   (URL)         loadHistoryServerConfig(),          ├─ configurations
                 loadHistoryServerEnvironment()      └─ environmentInfo
             ])
                    │
                    ▼
              HTTPリクエスト (並行)
                    │
                    ▼
            History Server API
              ├─ /jobs/{jid}/jobmanager/config
              └─ /jobs/{jid}/jobmanager/environment
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cluster-config.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/cluster-config/cluster-config.component.ts` | ソース | メインコンポーネント |
| cluster-config.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/cluster-config/cluster-config.component.html` | テンプレート | 画面レイアウト定義 |
| cluster-config.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/cluster-config/cluster-config.component.less` | スタイル | スタイル定義 |
| cluster-config.guard.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/cluster-config.guard.ts` | ガード | アクセス制御 |
| configuration-cards.component.ts | `flink-runtime-web/web-dashboard/src/app/components/configuration-cards/configuration-cards.component.ts` | 共通コンポーネント | 設定カード表示 |
| job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | サービス | API呼び出しサービス |
| routes.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/routes.ts` | 設定 | ルーティング定義 |
