# 画面設計書 14-頂点詳細

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「頂点詳細」画面の設計仕様を記載したものである。選択した頂点（オペレーター）の基本情報を表示する参照画面。

### 本画面の処理概要

頂点詳細画面は、DAGグラフで選択された頂点（オペレーター）の基本的な実行情報を表示する画面である。頂点の状態、並列度、実行時間、入出力レコード数、バイト数などの情報を一覧形式で表示し、運用担当者がオペレーターの実行状況を把握するために使用される。

**業務上の目的・背景**：Apache Flinkのストリーム処理において、各オペレーター（頂点）は独立して並列実行される。オペレーターの状態、並列度、処理したレコード数・バイト数を把握することで、運用担当者はジョブのパフォーマンス特性を理解し、ボトルネックの特定やリソース最適化に活用できる。特に開始時間・終了時間・実行時間の情報は、処理遅延の分析に重要な指標となる。

**画面へのアクセス方法**：ジョブ詳細画面のOverviewタブでDAGグラフ上の頂点をクリックし、頂点詳細ドロワーが開いた後、「Detail」タブを選択（デフォルトで選択済み）することでアクセスする。

**主要な操作・処理内容**：
1. 画面表示時にJobLocalServiceから選択された頂点情報を取得
2. 頂点の説明（description）をフォーマット処理（`<br/>`を改行に変換）
3. 左右2カラムのグリッドレイアウトで情報を表示
4. 動的コンポーネント（stateBadgeComponent, taskCountComponent）でバッジを表示

**画面遷移**：
- 遷移元：頂点詳細ドロワー（タブナビゲーション経由）
- 遷移先：なし（参照専用画面）

**権限による表示制御**：特になし。認証されたユーザーであれば閲覧可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | 頂点の詳細情報取得・表示（/jobs/{jobid}/vertices/{vertexid} API） |

## 画面種別

詳細（参照専用）

## URL/ルーティング

- パス: `/job/running/:jid/overview/:vertexId/detail` または `/job/completed/:jid/overview/:vertexId/detail`
- ルートパラメータ:
  - `jid` - ジョブID
  - `vertexId` - 頂点（オペレーター）ID

## 入出力項目

### 入力項目

本画面は親コンポーネント（頂点詳細ドロワー）からJobLocalService経由で頂点情報を受け取る。

### 出力項目（表示データ）

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 頂点名・説明 | node.description | string | 頂点の説明（オペレーター名） |
| 状態 | node.detail.status | string | 実行状態（CREATED/SCHEDULED/DEPLOYING/RUNNING/FINISHED等） |
| 並列度 | node.detail.parallelism | number | 現在の並列度 |
| 最大並列度 | node.detail.maxParallelism | number | スケール可能な最大並列度 |
| 開始時間 | node.detail.start-time | number | 開始時刻（タイムスタンプ） |
| 終了時間 | node.detail.end-time | number | 終了時刻（タイムスタンプ） |
| 実行時間 | node.detail.duration | number | 実行時間（ミリ秒） |
| タスク状態 | node.detail.tasks | object | 各状態のタスク数 |
| 送信レコード数 | node.detail.metrics.write-records | number | 送信したレコード数 |
| 受信レコード数 | node.detail.metrics.read-records | number | 受信したレコード数 |
| 送信バイト数 | node.detail.metrics.write-bytes | number | 送信したバイト数 |
| 受信バイト数 | node.detail.metrics.read-bytes | number | 受信したバイト数 |

## 表示項目

### 左カラム

| 表示項目 | 対応データ | フォーマット | 説明 |
|----------|-----------|-------------|------|
| State | status | バッジ表示 | 状態バッジコンポーネント |
| Parallelism | parallelism | 数値 | 現在の並列度 |
| Max Parallelism | maxParallelism | 数値 + ツールチップ | 最大並列度（説明ツールチップ付き） |
| Start Time | start-time | yyyy-MM-dd HH:mm:ss.SSS | 開始日時 |
| End Time | end-time | yyyy-MM-dd HH:mm:ss.SSS | 終了日時 |
| Duration | duration | humanizeDuration | 人間可読な実行時間 |

### 右カラム

| 表示項目 | 対応データ | フォーマット | 説明 |
|----------|-----------|-------------|------|
| Task | tasks | バッジ表示 | タスク状態バッジコンポーネント |
| Records Sent | write-records | 数値（3桁区切り） | 送信レコード数 |
| Records Received | read-records | 数値（3桁区切り） | 受信レコード数 |
| Bytes Sent | write-bytes | humanizeBytes | 人間可読なバイト数 |
| Bytes Received | read-bytes | humanizeBytes | 人間可読なバイト数 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化（ngOnInit）

**処理フロー**:
1. JobLocalService.selectedVertexChanges()を購読
2. 選択された頂点情報をnodeプロパティに格納
3. descriptionに`<br/>`が含まれる場合、改行文字に変換
4. ChangeDetectorRef.markForCheck()で画面を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベースへの更新処理なし |

本画面は参照専用であり、データベースへの直接アクセスは行わない。表示データは親コンポーネントから受け取る。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | - | - | 本画面にはメッセージ表示機能なし |

## 例外処理

| 例外状況 | 対応 | 表示 |
|---------|------|------|
| 頂点が選択されていない | nodeがnullの場合は何も表示しない | 空の画面 |
| メトリクスがロード中 | *-complete フラグがfalseの場合ローディングアイコン表示 | ローディングアイコン |

## 備考

- JOB_OVERVIEW_MODULE_CONFIGによりstateBadgeComponentとtaskCountComponentがカスタマイズ可能
- メトリクス（read-bytes, write-bytes等）は非同期で取得されるため、`*-complete`フラグで完了状態を判定
- Max Parallelismにはinfo-circleアイコンとツールチップで説明を表示
- ng-zorro-antdのNzGridModule（nz-row, nz-col）を使用したグリッドレイアウト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、頂点情報のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | plan.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/plan.ts` | NodesItemCorrectインターフェース。detail内のstatus, parallelism, metricsなどの構造 |

**読解のコツ**: NodesItemCorrectのdetailプロパティには、status, parallelism, maxParallelism, start-time, end-time, duration, tasks, metricsなどのオペレーター実行情報が含まれる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-overview-drawer-detail.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/detail/job-overview-drawer-detail.component.ts` | コンポーネントのライフサイクルとデータバインディング |

**主要処理フロー**:
1. **71-76行目**: コンストラクタでモジュール設定から動的コンポーネントを取得
2. **79-91行目**: ngOnInit()でselectedVertexChanges()を購読
3. **85-88行目**: descriptionの`<br/>`を改行に変換
4. **90行目**: markForCheck()で画面を更新

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-overview-drawer-detail.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/detail/job-overview-drawer-detail.component.html` | グリッドレイアウト、動的コンポーネント、パイプの使用 |

**主要処理フロー**:
- **24行目**: nz-rowとnz-colでグリッドレイアウト
- **29-33行目**: flink-dynamic-hostでstateBadgeComponentを動的表示
- **70-72行目**: *ngIfでメトリクスのロード状態を判定

#### Step 4: ローカルサービスを理解する

頂点選択状態を取得するサービスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | selectedVertexChanges()の実装 |

### プログラム呼び出し階層図

```
JobOverviewDrawerDetailComponent.ngOnInit()
    │
    └─ JobLocalService.selectedVertexChanges()
           │
           └─ ReplaySubject<NodesItemCorrect | null>
                  │
                  ▼
           コンポーネントのnodeプロパティに格納
                  │
                  ├─ description内の<br/>を\nに変換
                  │
                  └─ cdr.markForCheck()で画面更新
```

### データフロー図

```
[入力]               [処理]                         [出力]

JobLocalService ───▶ selectedVertexChanges() ───▶ node
                            │
                            ▼
                     descriptionの変換
                            │
                            ▼
                     テンプレートへバインド
                            │
                            ▼
                     ┌─────────────────────────────────┐
                     │ [左カラム]      │ [右カラム]     │
                     │ State          │ Task          │
                     │ Parallelism    │ Records Sent  │
                     │ Max Parallelism│ Records Recv  │
                     │ Start Time     │ Bytes Sent    │
                     │ End Time       │ Bytes Recv    │
                     │ Duration       │               │
                     └─────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-overview-drawer-detail.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/detail/job-overview-drawer-detail.component.ts` | ソース | メインコンポーネント |
| job-overview-drawer-detail.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/detail/job-overview-drawer-detail.component.html` | テンプレート | 画面レイアウト定義 |
| job-overview-drawer-detail.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/detail/job-overview-drawer-detail.component.less` | スタイル | スタイル定義 |
| job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | サービス | ジョブ・頂点状態管理 |
| job-overview.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/job-overview.config.ts` | 設定 | カスタムコンポーネント設定 |
| dynamic-host.component.ts | `flink-runtime-web/web-dashboard/src/app/components/dynamic/dynamic-host.component.ts` | 共通コンポーネント | 動的コンポーネントホスト |
| humanize-date.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-date.pipe.ts` | パイプ | 日時フォーマット |
| humanize-duration.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-duration.pipe.ts` | パイプ | 時間フォーマット |
| humanize-bytes.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-bytes.pipe.ts` | パイプ | バイト数フォーマット |
