# 画面設計書 15-サブタスク一覧

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「サブタスク一覧」画面の設計仕様を記載したものである。選択した頂点（オペレーター）に属するサブタスクの詳細情報を一覧表示する画面。

### 本画面の処理概要

サブタスク一覧画面は、DAGグラフで選択された頂点（オペレーター）を構成する個々のサブタスクの実行状況を詳細に表示する画面である。各サブタスクのID、入出力バイト数・レコード数、試行回数、実行時間、ステータス、バックプレッシャー/アイドル/ビジー時間などの情報を一覧表で表示し、運用担当者がオペレーターの並列実行状況を把握するために使用される。

**業務上の目的・背景**：Apache Flinkでは、オペレーターは並列度に応じて複数のサブタスクに分割され、それぞれが異なるTaskManagerで実行される。サブタスク単位での実行状況を把握することで、データスキュー（特定サブタスクへのデータ偏り）やパフォーマンスのばらつきを特定でき、ジョブの最適化やトラブルシューティングに活用できる。また、リトライが発生した場合の履歴も確認可能である。

**画面へのアクセス方法**：ジョブ詳細画面のOverviewタブでDAGグラフ上の頂点をクリックし、頂点詳細ドロワーが開いた後、「SubTasks」タブを選択することでアクセスする。

**主要な操作・処理内容**：
1. 画面表示時にREST API経由でサブタスク一覧を取得
2. Subtask Metricsタブでサブタスク単位の詳細メトリクスを表示
3. Aggregated Metricsタブで集計されたメトリクスを表示
4. 各カラムでソート機能を提供
5. 複数試行があるサブタスクは展開して履歴を表示

**画面遷移**：
- 遷移元：頂点詳細ドロワー（タブナビゲーション経由）
- 遷移先：なし（参照専用画面）

**権限による表示制御**：特になし。認証されたユーザーであれば閲覧可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | サブタスク一覧の取得・表示 |
| 24 | タスク実行 | 補助機能 | サブタスクの実行状態、メトリクス表示 |

## 画面種別

一覧（参照専用）

## URL/ルーティング

- パス: `/job/running/:jid/overview/:vertexId/subtasks` または `/job/completed/:jid/overview/:vertexId/subtasks`
- ルートパラメータ:
  - `jid` - ジョブID
  - `vertexId` - 頂点（オペレーター）ID

## 入出力項目

### 入力項目

本画面はJobLocalService経由でジョブIDと頂点IDを取得し、REST APIを呼び出す。

### 出力項目（API取得）

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| サブタスク一覧 | subtasks | JobVertexSubTask[] | サブタスク情報の配列 |
| 集計メトリクス | aggregated | JobVertexAggregated | 全サブタスクの集計値 |

## 表示項目

### Subtask Metricsタブ

| 表示項目 | 対応データ | ソート | 説明 |
|----------|-----------|-------|------|
| ID | subtask | - | サブタスクID |
| Bytes Received | metrics.read-bytes | 可 | 受信バイト数 |
| Records Received | metrics.read-records | 可 | 受信レコード数 |
| Bytes Sent | metrics.write-bytes | 可 | 送信バイト数 |
| Records Sent | metrics.write-records | 可 | 送信レコード数 |
| Attempt | attempt | 可 | 試行回数（1ベース表示） |
| Endpoint | endpoint | 可 | 実行エンドポイント |
| Start Time | start_time | 可 | 開始時刻 |
| Duration | duration | 可 | 実行時間 |
| End Time | end-time | 可 | 終了時刻 |
| Accumulated Time | accumulated-*-time | - | バックプレッシャー/アイドル/ビジー時間 |
| Status Durations | status-duration | - | 各状態の滞在時間バッジ |
| Status | status | 可 | 実行状態バッジ |
| More | - | - | アクションコンポーネント |

### Aggregated Metricsタブ

集計されたメトリクス情報を表示（TableAggregatedMetricsComponent使用）。

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化（ngOnInit）

**処理フロー**:
1. JobLocalService.jobWithVertexChanges()を購読
2. JobService.loadSubTasks(jobId, vertexId)でAPI呼び出し
3. レスポンスのsubtasksをlistOfTaskに、aggregatedをaggregatedに格納
4. isLoadingをfalseに設定し、markForCheck()で画面を更新

### 2-展開/折りたたみ

**トリガー**: 複数試行があるサブタスクの展開アイコンクリック

**処理フロー**:
1. onExpandChange()でexpandSetにサブタスクIDを追加/削除
2. 展開時にother-concurrent-attemptsを表示

### 3-ソート

**トリガー**: カラムヘッダーのソートアイコンクリック

**処理フロー**:
1. nzSortFnに設定されたソート関数でデータをソート
2. nzSortOrderChangeでcollapseAll()を呼び出し、全展開を閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | REST API経由でサブタスク一覧を取得 |

本画面は参照専用であり、データベースへの更新処理は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | loading... | メトリクス読み込み中 | メトリクスの*-completeフラグがfalse |

## 例外処理

| 例外状況 | 対応 | 表示 |
|---------|------|------|
| API通信エラー | catchErrorでof(undefined)を返却 | 空のテーブル表示 |

## 備考

- 仮想スクロール（nz-virtual-scroll）により大量のサブタスクを効率的に表示
- サブタスクの展開機能により、複数試行（other-concurrent-attempts）の履歴を確認可能
- Status Durationsは各状態（CREATED, SCHEDULED, DEPLOYING, INITIALIZING, RUNNING）の滞在時間をバッジで表示
- Accumulated Timeは「バックプレッシャー / アイドル / ビジー」の3つの時間をスラッシュ区切りで表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、サブタスク情報のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-vertex.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-vertex.ts` | JobVertexSubTask, JobVertexAggregated, JobVertexStatusDurationインターフェースの構造 |

**読解のコツ**: JobVertexSubTaskにはsubtask, attempt, endpoint, start_time, duration, status, metricsなどのプロパティがある。other-concurrent-attemptsで複数試行の履歴を保持。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-overview-drawer-subtasks.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/subtasks/job-overview-drawer-subtasks.component.ts` | ソート関数、展開処理、データ取得フロー |

**主要処理フロー**:
1. **48-50行目**: createSortFn()でソート関数を生成
2. **74-83行目**: sortReadBytesFn等のソート関数定義
3. **112-127行目**: ngOnInit()でAPI呼び出しとデータ取得
4. **139-146行目**: onExpandChange()で展開/折りたたみ処理
5. **148-158行目**: convertStatusDuration()で状態別時間を配列に変換

#### Step 3: サービス層を理解する

API呼び出しを行うサービスクラスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | loadSubTasks()メソッドの実装 |

**主要処理フロー**:
- **139-143行目**: loadSubTasks()がGETリクエストで`/jobs/${jobId}/vertices/${vertexId}`を呼び出し

### プログラム呼び出し階層図

```
JobOverviewDrawerSubtasksComponent.ngOnInit()
    │
    ├─ JobLocalService.jobWithVertexChanges()
    │      └─ Observable<JobWithVertex>を返却
    │
    └─ mergeMap → JobService.loadSubTasks(jobId, vertexId)
           │
           └─ HttpClient.get(`/jobs/${jobId}/vertices/${vertexId}`)
                  │
                  └─ REST API: GET /jobs/{jid}/vertices/{vid}
                         │
                         ▼
                  レスポンス: { subtasks, aggregated }
```

### データフロー図

```
[入力]               [処理]                         [出力]

JobWithVertex ───▶ loadSubTasks(jid, vid) ───▶ JobVertexSubTaskDetail
                          │
                          ▼
                   HTTPリクエスト
                          │
                          ▼
                   REST API サーバー
                          │
                          ▼
                   レスポンスJSON
                          │
                   ┌──────┴──────┐
                   ▼              ▼
             listOfTask      aggregated
                   │              │
                   ▼              ▼
            Subtask Metrics  Aggregated Metrics
                 タブ             タブ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-overview-drawer-subtasks.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/subtasks/job-overview-drawer-subtasks.component.ts` | ソース | メインコンポーネント |
| job-overview-drawer-subtasks.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/subtasks/job-overview-drawer-subtasks.component.html` | テンプレート | 画面レイアウト定義 |
| job-overview-drawer-subtasks.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/subtasks/job-overview-drawer-subtasks.component.less` | スタイル | スタイル定義 |
| job-vertex.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-vertex.ts` | インターフェース | サブタスクデータ型定義 |
| job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | サービス | API呼び出しサービス |
| job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | サービス | ジョブ・頂点状態管理 |
| table-aggregated-metrics.component.ts | `flink-runtime-web/web-dashboard/src/app/components/table-aggregated-metrics/table-aggregated-metrics.component.ts` | 共通コンポーネント | 集計メトリクス表示 |
| subtasks-table-action.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/subtasks/table-action/subtasks-table-action.component.ts` | コンポーネント | テーブルアクション |
