# 画面設計書 16-TaskManager一覧

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「TaskManager一覧」画面（頂点詳細ドロワー内）の設計仕様を記載したものである。選択した頂点（オペレーター）を実行しているTaskManagerの一覧を表示する画面。

### 本画面の処理概要

TaskManager一覧画面（頂点詳細ドロワー内）は、DAGグラフで選択された頂点（オペレーター）のサブタスクがどのTaskManagerで実行されているかを表示する画面である。各TaskManagerのエンドポイント、入出力バイト数・レコード数、実行時間、タスク状態、ステータスなどの情報を一覧で表示し、運用担当者がオペレーターのリソース分散状況を把握するために使用される。

**業務上の目的・背景**：Apache Flinkでは、オペレーターのサブタスクは複数のTaskManagerに分散して実行される。TaskManager単位での実行状況を把握することで、特定のTaskManagerへの負荷集中やTaskManagerの障害影響範囲を特定でき、リソース配置の最適化やトラブルシューティングに活用できる。

**画面へのアクセス方法**：ジョブ詳細画面のOverviewタブでDAGグラフ上の頂点をクリックし、頂点詳細ドロワーが開いた後、「TaskManagers」タブを選択することでアクセスする。

**主要な操作・処理内容**：
1. 画面表示時にREST API経由でTaskManager一覧を取得
2. 各カラムでソート機能を提供
3. TaskManagerごとのタスク状態をバッジで表示
4. 仮想スクロールにより大量のTaskManagerを効率的に表示

**画面遷移**：
- 遷移元：頂点詳細ドロワー（タブナビゲーション経由）
- 遷移先：アクションコンポーネント経由でTaskManager詳細画面への遷移が可能

**権限による表示制御**：特になし。認証されたユーザーであれば閲覧可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | 頂点を実行しているTaskManager一覧の取得 |
| 24 | タスク実行 | 補助機能 | TaskManagerごとのタスク実行状態表示 |

## 画面種別

一覧（参照専用）

## URL/ルーティング

- パス: `/job/running/:jid/overview/:vertexId/taskmanagers` または `/job/completed/:jid/overview/:vertexId/taskmanagers`
- ルートパラメータ:
  - `jid` - ジョブID
  - `vertexId` - 頂点（オペレーター）ID

## 入出力項目

### 入力項目

本画面はJobLocalService経由でジョブIDと頂点IDを取得し、REST APIを呼び出す。

### 出力項目（API取得）

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| TaskManager一覧 | taskmanagers | VertexTaskManagerDetail[] | TaskManager情報の配列 |

## 表示項目

| 表示項目 | 対応データ | ソート | 幅 | 説明 |
|----------|-----------|-------|-----|------|
| Endpoint | endpoint | 可 | 160px | TaskManagerのホスト:ポート |
| Bytes received | metrics.read-bytes | 可 | 150px | 受信バイト数 |
| Records received | metrics.read-records | 可 | 150px | 受信レコード数 |
| Bytes sent | metrics.write-bytes | 可 | 120px | 送信バイト数 |
| Records sent | metrics.write-records | 可 | 150px | 送信レコード数 |
| Start Time | start-time | 可 | 200px | 開始時刻 |
| End Time | end-time | 可 | 200px | 終了時刻 |
| Duration | duration | 可 | 150px | 実行時間 |
| Tasks | status-counts | - | 120px | タスク状態バッジ |
| Status | status | 可 | 100px | 実行状態バッジ |
| More | - | - | 50px | アクションコンポーネント |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化（ngOnInit）

**処理フロー**:
1. JobLocalService.jobWithVertexChanges()を購読
2. JobService.loadTaskManagers(jobId, vertexId)でAPI呼び出し
3. レスポンスのtaskmanagersをlistOfTaskManagerに格納
4. isLoadingをfalseに設定し、markForCheck()で画面を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | REST API経由でTaskManager一覧を取得 |

本画面は参照専用であり、データベースへの更新処理は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | - | - | 本画面にはメッセージ表示機能なし |

## 例外処理

| 例外状況 | 対応 | 表示 |
|---------|------|------|
| API通信エラー | catchErrorでof([])を返却 | 空のテーブル表示 |

## 備考

- 仮想スクロール（nz-virtual-scroll）により大量のTaskManagerを効率的に表示
- virtualItemSize = 36pxでスクロールバッファを設定
- Endpointカラムはellipsis-cellクラスで長いテキストを省略表示
- アクションコンポーネント（taskManagerActionComponent）はモジュール設定でカスタマイズ可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、TaskManager情報のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-vertex.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-vertex.ts` | VertexTaskManagerDetailインターフェースの構造 |

**読解のコツ**: VertexTaskManagerDetailにはendpoint, start-time, end-time, duration, status, status-counts, metricsなどのプロパティがある。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-overview-drawer-taskmanagers.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/taskmanagers/job-overview-drawer-taskmanagers.component.ts` | ソート関数、データ取得フロー |

**主要処理フロー**:
1. **40-44行目**: createSortFn()でソート関数を生成
2. **64-72行目**: 各カラムのソート関数定義
3. **101-118行目**: ngOnInit()でAPI呼び出しとデータ取得

#### Step 3: サービス層を理解する

API呼び出しを行うサービスクラスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | loadTaskManagers()メソッドの実装 |

**主要処理フロー**:
- **151-155行目**: loadTaskManagers()がGETリクエストで`/jobs/${jobId}/vertices/${vertexId}/taskmanagers`を呼び出し

### プログラム呼び出し階層図

```
JobOverviewDrawerTaskmanagersComponent.ngOnInit()
    │
    ├─ JobLocalService.jobWithVertexChanges()
    │      └─ Observable<JobWithVertex>を返却
    │
    └─ mergeMap → JobService.loadTaskManagers(jobId, vertexId)
           │
           └─ HttpClient.get(`/jobs/${jobId}/vertices/${vertexId}/taskmanagers`)
                  │
                  └─ REST API: GET /jobs/{jid}/vertices/{vid}/taskmanagers
                         │
                         ▼
                  レスポンス: { taskmanagers: [...] }
```

### データフロー図

```
[入力]               [処理]                         [出力]

JobWithVertex ───▶ loadTaskManagers(jid, vid) ───▶ VertexTaskManagerDetail[]
                          │
                          ▼
                   HTTPリクエスト
                          │
                          ▼
                   REST API サーバー
                          │
                          ▼
                   レスポンス.taskmanagers
                          │
                          ▼
                   listOfTaskManager
                          │
                          ▼
                   テーブル表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-overview-drawer-taskmanagers.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/taskmanagers/job-overview-drawer-taskmanagers.component.ts` | ソース | メインコンポーネント |
| job-overview-drawer-taskmanagers.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/taskmanagers/job-overview-drawer-taskmanagers.component.html` | テンプレート | 画面レイアウト定義 |
| job-overview-drawer-taskmanagers.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/taskmanagers/job-overview-drawer-taskmanagers.component.less` | スタイル | スタイル定義 |
| job-vertex.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-vertex.ts` | インターフェース | TaskManagerデータ型定義 |
| job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | サービス | API呼び出しサービス |
| job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | サービス | ジョブ・頂点状態管理 |
| taskmanagers-table-action.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/taskmanagers/table-action/taskmanagers-table-action.component.ts` | コンポーネント | テーブルアクション |
