# 画面設計書 17-ウォーターマーク

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「ウォーターマーク」画面の設計仕様を記載したものである。選択した頂点（オペレーター）のサブタスクごとのウォーターマーク情報を表示する画面。

### 本画面の処理概要

ウォーターマーク画面は、DAGグラフで選択された頂点（オペレーター）の各サブタスクが保持するウォーターマーク値を表示する画面である。ウォーターマークは、ストリーム処理においてイベント時間の進捗を示す重要な指標であり、各サブタスクの現在のウォーターマーク値と、それを日時に変換した表示を提供する。

**業務上の目的・背景**：Apache Flinkのイベント時間処理では、ウォーターマークがイベント時間の進捗を制御する。ウォーターマークが進まない場合、ウィンドウがトリガーされず処理が滞留する可能性がある。本画面により、運用担当者は各サブタスクのウォーターマークを監視し、特定のサブタスクでウォーターマークが停滞していないか、イベント時間処理が正常に進行しているかを確認できる。

**画面へのアクセス方法**：ジョブ詳細画面のOverviewタブでDAGグラフ上の頂点をクリックし、頂点詳細ドロワーが開いた後、「Watermarks」タブを選択することでアクセスする。

**主要な操作・処理内容**：
1. 画面表示時にMetricsService経由でウォーターマーク情報を取得
2. サブタスクインデックスごとのウォーターマーク値を一覧表示
3. ウォーターマークを人間可読な形式と日時形式で表示
4. ウォーターマーク値でソート機能を提供

**画面遷移**：
- 遷移元：頂点詳細ドロワー（タブナビゲーション経由）
- 遷移先：なし（参照専用画面）

**権限による表示制御**：特になし。認証されたユーザーであれば閲覧可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | ウォーターマーク情報の取得（/jobs/{jobid}/vertices/{vertexid}/watermarks API） |
| 10 | Watermark | 補助機能 | イベント時間処理のウォーターマーク状態表示 |

## 画面種別

一覧（参照専用）

## URL/ルーティング

- パス: `/job/running/:jid/overview/:vertexId/watermarks` または `/job/completed/:jid/overview/:vertexId/watermarks`
- ルートパラメータ:
  - `jid` - ジョブID
  - `vertexId` - 頂点（オペレーター）ID

## 入出力項目

### 入力項目

本画面はJobLocalService経由でジョブIDと頂点IDを取得し、MetricsServiceを経由してREST APIを呼び出す。

### 出力項目（API取得）

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ウォーターマーク一覧 | watermarks | object | サブタスクインデックスをキーとするウォーターマーク値のマップ |

## 表示項目

| 表示項目 | 対応データ | ソート | 幅 | 説明 |
|----------|-----------|-------|-----|------|
| SubTask | subTaskIndex | - | 20% | サブタスクインデックス |
| Watermark | watermark | 可 | 40% | ウォーターマーク値（humanizeWatermarkパイプで変換） |
| Datetime of Watermark Timestamp | watermark | 可 | 40% | ウォーターマークを日時に変換した値 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化（ngOnInit）

**処理フロー**:
1. JobLocalService.jobWithVertexChanges()を購読
2. MetricsService.loadWatermarks(jobId, vertexId)でAPI呼び出し
3. レスポンスのwatermarksを配列形式（{subTaskIndex, watermark}[]）に変換
4. listOfWaterMarkに格納
5. isLoadingをfalseに設定し、markForCheck()で画面を更新

### 2-ソート

**トリガー**: Watermarkカラムヘッダーのソートアイコンクリック

**処理フロー**:
1. sortWatermark()関数でウォーターマーク値の数値比較によるソート

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | REST API経由でウォーターマーク情報を取得 |

本画面は参照専用であり、データベースへの更新処理は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | - | - | 本画面にはメッセージ表示機能なし |

## 例外処理

| 例外状況 | 対応 | 表示 |
|---------|------|------|
| API通信エラー | catchErrorでof([])を返却 | 空のテーブル表示 |

## 備考

- 仮想スクロール（nz-virtual-scroll）により大量のサブタスクを効率的に表示
- ウォーターマークは2つの形式で表示：
  - humanizeWatermarkパイプ：数値または特殊値（No Watermark等）
  - humanizeWatermarkToDatetimeパイプ：ローカルタイムゾーンでの日時表示
- Datetime列にはinfo-circleアイコンとツールチップで「タイムゾーンはブラウザから取得」の説明を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ウォーターマーク情報のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-metrics.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-metrics.ts` | Watermarksインターフェースの構造 |

**読解のコツ**: Watermarksは{watermarks: MetricMap, lowWatermark: number}の構造。MetricMapはサブタスクインデックスをキーとするオブジェクト。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-overview-drawer-watermarks.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/watermarks/job-overview-drawer-watermarks.component.ts` | WatermarkDataインターフェース、データ取得フロー |

**主要処理フロー**:
1. **36-39行目**: WatermarkDataインターフェース定義（subTaskIndex, watermark）
2. **65-92行目**: ngOnInit()でloadWatermarks()を呼び出し、結果を配列に変換
3. **100-102行目**: sortWatermark()でソート処理

#### Step 3: サービス層を理解する

API呼び出しを行うサービスクラスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | metrics.service.ts | `flink-runtime-web/web-dashboard/src/app/services/metrics.service.ts` | loadWatermarks()メソッドの実装 |

**主要処理フロー**:
- **147-174行目**: loadWatermarks()がGETリクエストで`/jobs/${jobId}/vertices/${vertexId}/watermarks`を呼び出し
- レスポンスを{lowWatermark, watermarks}形式に変換

### プログラム呼び出し階層図

```
JobOverviewDrawerWatermarksComponent.ngOnInit()
    │
    ├─ JobLocalService.jobWithVertexChanges()
    │      └─ Observable<JobWithVertex>を返却
    │
    └─ mergeMap → MetricsService.loadWatermarks(jobId, vertexId)
           │
           └─ HttpClient.get(`/jobs/${jobId}/vertices/${vertexId}/watermarks`)
                  │
                  └─ REST API: GET /jobs/{jid}/vertices/{vid}/watermarks
                         │
                         ▼
                  レスポンス: Watermarks
                         │
                         ▼
                  map → WatermarkData[]に変換
```

### データフロー図

```
[入力]               [処理]                         [出力]

JobWithVertex ───▶ loadWatermarks(jid, vid) ───▶ Watermarks
                          │
                          ▼
                   HTTPリクエスト
                          │
                          ▼
                   REST API サーバー
                          │
                          ▼
                   レスポンス.watermarks
                          │
                          ▼
                   for...in でオブジェクト→配列変換
                          │
                          ▼
                   listOfWaterMark: WatermarkData[]
                          │
                          ▼
                   テーブル表示
                    ├─ humanizeWatermarkパイプ
                    └─ humanizeWatermarkToDatetimeパイプ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-overview-drawer-watermarks.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/watermarks/job-overview-drawer-watermarks.component.ts` | ソース | メインコンポーネント |
| job-overview-drawer-watermarks.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/watermarks/job-overview-drawer-watermarks.component.html` | テンプレート | 画面レイアウト定義 |
| job-overview-drawer-watermarks.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/watermarks/job-overview-drawer-watermarks.component.less` | スタイル | スタイル定義 |
| metrics.service.ts | `flink-runtime-web/web-dashboard/src/app/services/metrics.service.ts` | サービス | メトリクスAPI呼び出し |
| job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | サービス | ジョブ・頂点状態管理 |
| humanize-watermark.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-watermark.pipe.ts` | パイプ | ウォーターマーク値変換 |
