# 画面設計書 18-アキュムレーター

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「アキュムレーター」画面の設計仕様を記載したものである。選択した頂点（オペレーター）のアキュムレーター（集計値）情報を表示する画面。

### 本画面の処理概要

アキュムレーター画面は、DAGグラフで選択された頂点（オペレーター）のユーザー定義アキュムレーターおよびサブタスク単位のアキュムレーター値を表示する画面である。アキュムレーターは、ジョブ実行中に収集される累積値（カウンター、合計値など）であり、処理の進捗状況やカスタムメトリクスを確認するために使用される。

**業務上の目的・背景**：Apache Flinkでは、ユーザーがアキュムレーター（IntCounter、LongCounter、DoubleCounterなど）を定義して、ジョブ実行中に値を累積できる。これにより、処理したイベント数、フィルターで除外されたレコード数、カスタム統計値などを収集・可視化できる。本画面により、運用担当者や開発者はジョブの処理状況をリアルタイムで監視し、処理の正常性を確認できる。

**画面へのアクセス方法**：ジョブ詳細画面のOverviewタブでDAGグラフ上の頂点をクリックし、頂点詳細ドロワーが開いた後、「Accumulators」タブを選択することでアクセスする。

**主要な操作・処理内容**：
1. 画面表示時にREST API経由でアキュムレーター情報を取得
2. Vertex Accumulatorsタブで頂点全体の集計値を表示
3. SubTask Accumulatorsタブでサブタスク単位の値を表示
4. 仮想スクロールにより大量のデータを効率的に表示

**画面遷移**：
- 遷移元：頂点詳細ドロワー（タブナビゲーション経由）
- 遷移先：なし（参照専用画面）

**権限による表示制御**：特になし。認証されたユーザーであれば閲覧可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | アキュムレーター情報の取得（/jobs/{jobid}/vertices/{vertexid}/accumulators API） |
| 23 | ジョブ管理 | 補助機能 | ユーザー定義アキュムレーター値の表示 |

## 画面種別

一覧（参照専用）

## URL/ルーティング

- パス: `/job/running/:jid/overview/:vertexId/accumulators` または `/job/completed/:jid/overview/:vertexId/accumulators`
- ルートパラメータ:
  - `jid` - ジョブID
  - `vertexId` - 頂点（オペレーター）ID

## 入出力項目

### 入力項目

本画面はJobLocalService経由でジョブIDと頂点IDを取得し、REST APIを呼び出す。

### 出力項目（API取得）

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 頂点アキュムレーター | main | UserAccumulators[] | 頂点全体の集計アキュムレーター |
| サブタスクアキュムレーター | subtasks | SubTaskAccumulators[] | サブタスク単位のアキュムレーター |

## 表示項目

### Vertex Accumulatorsタブ

| 表示項目 | 対応データ | 幅 | 説明 |
|----------|-----------|-----|------|
| Name | name | 33.33% | アキュムレーター名 |
| Type | type | 33.33% | データ型 |
| Value | value | 33.33% | 集計値（数値は3桁区切り） |

### SubTask Accumulatorsタブ

| 表示項目 | 対応データ | 幅 | 説明 |
|----------|-----------|-----|------|
| SubTask | subtask, host, attempt | 25% | サブタスクID、ホスト、試行回数 |
| Name | name | 25% | アキュムレーター名 |
| Type | type | 25% | データ型 |
| Value | value | 25% | 値 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化（ngOnInit）

**処理フロー**:
1. JobLocalService.jobWithVertexChanges()を購読
2. JobService.loadAccumulators(jobId, vertexId)でAPI呼び出し
3. レスポンスのmainをlistOfAccumulatorに格納
4. レスポンスのsubtasksをtransformToSubTaskAccumulator()で変換してlistOfSubTaskAccumulatorに格納
5. isLoadingをfalseに設定し、markForCheck()で画面を更新

### 2-サブタスクアキュムレーター変換

**処理フロー**:
1. transformToSubTaskAccumulator()でサブタスクデータを変換
2. 各サブタスクの`user-accumulators`配列を展開し、フラットな配列に変換
3. 各エントリにname, type, valueを追加

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | REST API経由でアキュムレーター情報を取得 |

本画面は参照専用であり、データベースへの更新処理は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | - | - | 本画面にはメッセージ表示機能なし |

## 例外処理

| 例外状況 | 対応 | 表示 |
|---------|------|------|
| API通信エラー | catchErrorで{main:[], subtasks:[]}を返却 | 空のテーブル表示 |

## 備考

- 仮想スクロール（nz-virtual-scroll）により大量のアキュムレーターを効率的に表示
- Vertex AccumulatorsタブとSubTask Accumulatorsタブの2タブ構成
- Value列は数値の場合、number:'1.0-3'パイプで3桁区切り表示
- SubTaskカラムは「(subtask) host, attempt: N」形式で表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アキュムレーター情報のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-accumulators.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-accumulators.ts` | JobAccumulators, UserAccumulators, SubTaskAccumulatorsインターフェースの構造 |

**読解のコツ**: UserAccumulatorsにはname, type, valueのプロパティ。SubTaskAccumulatorsにはsubtask, host, attempt, user-accumulatorsなどのプロパティがある。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-overview-drawer-accumulators.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/accumulators/job-overview-drawer-accumulators.component.ts` | データ取得フロー、transformToSubTaskAccumulator()変換処理 |

**主要処理フロー**:
1. **57-79行目**: ngOnInit()でloadAccumulators()を呼び出し、データを取得
2. **76行目**: transformToSubTaskAccumulator()でサブタスクデータを変換
3. **86-100行目**: transformToSubTaskAccumulator()でuser-accumulators配列を展開

#### Step 3: サービス層を理解する

API呼び出しを行うサービスクラスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | loadAccumulators()メソッドの実装 |

**主要処理フロー**:
- **94-108行目**: loadAccumulators()がforkJoinで2つのAPIを並行呼び出し
  - `/jobs/${jobId}/vertices/${vertexId}/accumulators`（頂点アキュムレーター）
  - `/jobs/${jobId}/vertices/${vertexId}/subtasks/accumulators`（サブタスクアキュムレーター）

### プログラム呼び出し階層図

```
JobOverviewDrawerAccumulatorsComponent.ngOnInit()
    │
    ├─ JobLocalService.jobWithVertexChanges()
    │      └─ Observable<JobWithVertex>を返却
    │
    └─ mergeMap → JobService.loadAccumulators(jobId, vertexId)
           │
           └─ forkJoin([
                  ├─ HttpClient.get(`/jobs/${jobId}/vertices/${vertexId}/accumulators`)
                  └─ HttpClient.get(`/jobs/${jobId}/vertices/${vertexId}/subtasks/accumulators`)
              ])
                  │
                  ▼
              { main: UserAccumulators[], subtasks: SubTaskAccumulators[] }
                  │
                  ├─ listOfAccumulator = main
                  └─ listOfSubTaskAccumulator = transformToSubTaskAccumulator(subtasks)
```

### データフロー図

```
[入力]               [処理]                         [出力]

JobWithVertex ───▶ loadAccumulators(jid, vid) ───▶ JobAccumulators
                          │
                          ▼
                   forkJoin (2 API)
                          │
                   ┌──────┴──────┐
                   ▼              ▼
              /accumulators  /subtasks/accumulators
                   │              │
                   ▼              ▼
             UserAccumulators  SubTaskAccumulators
                   │              │
                   │              ▼
                   │     transformToSubTaskAccumulator()
                   │              │
                   ▼              ▼
            Vertex Accumulators  SubTask Accumulators
                  タブ              タブ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-overview-drawer-accumulators.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/accumulators/job-overview-drawer-accumulators.component.ts` | ソース | メインコンポーネント |
| job-overview-drawer-accumulators.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/accumulators/job-overview-drawer-accumulators.component.html` | テンプレート | 画面レイアウト定義 |
| job-overview-drawer-accumulators.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/accumulators/job-overview-drawer-accumulators.component.less` | スタイル | スタイル定義 |
| job-accumulators.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-accumulators.ts` | インターフェース | アキュムレーターデータ型定義 |
| job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | サービス | API呼び出しサービス |
| job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | サービス | ジョブ・頂点状態管理 |
