# 画面設計書 20-バックプレッシャー

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「バックプレッシャー」画面の設計仕様を記載したものである。選択した頂点（オペレーター）のバックプレッシャー状態をサブタスク単位で表示する画面。

### 本画面の処理概要

バックプレッシャー画面は、DAGグラフで選択された頂点（オペレーター）の各サブタスクにおけるバックプレッシャー状態を表示する画面である。バックプレッシャー率、アイドル率、ビジー率を数値とバッジで可視化し、ストリーム処理のボトルネック特定に活用される。また、各サブタスクのスレッドダンプへのリンクも提供する。

**業務上の目的・背景**：Apache Flinkのストリーム処理において、バックプレッシャーは下流オペレーターの処理能力が上流からのデータ量に追いつかない状態を示す。バックプレッシャーが発生すると、パイプライン全体のスループットが低下する。本画面により、運用担当者はどのサブタスクでバックプレッシャーが発生しているかを特定し、リソースの再配置や並列度の調整などの対策を検討できる。特にビジー率とバックプレッシャー率のバランスから、ボトルネックの原因（CPU不足、I/O待ち等）を推測できる。

**画面へのアクセス方法**：ジョブ詳細画面のOverviewタブでDAGグラフ上の頂点をクリックし、頂点詳細ドロワーが開いた後、「BackPressure」タブを選択することでアクセスする。

**主要な操作・処理内容**：
1. 画面表示時にREST API経由でバックプレッシャー情報を取得
2. 全体のバックプレッシャーステータスをバッジで表示
3. サブタスク単位のバックプレッシャー率、アイドル率、ビジー率を表示
4. 各カラムでソート機能を提供
5. 複数試行がある場合は展開して表示
6. スレッドダンプへのリンクを提供

**画面遷移**：
- 遷移元：頂点詳細ドロワー（タブナビゲーション経由）
- 遷移先：TaskManagerスレッドダンプ画面（Dumpリンク経由）

**権限による表示制御**：特になし。認証されたユーザーであれば閲覧可能。オペレーターがRUNNING/INITIALIZING以外の場合はサンプリング不可のメッセージを表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | バックプレッシャー情報の取得（/jobs/{jobid}/vertices/{vertexid}/backpressure API） |
| 57 | メトリクスコア | 補助機能 | バックプレッシャー状態の視覚化 |

## 画面種別

一覧（参照専用）

## URL/ルーティング

- パス: `/job/running/:jid/overview/:vertexId/backpressure` または `/job/completed/:jid/overview/:vertexId/backpressure`
- ルートパラメータ:
  - `jid` - ジョブID
  - `vertexId` - 頂点（オペレーター）ID

## 入出力項目

### 入力項目

本画面はJobLocalService経由でジョブIDと頂点IDを取得し、REST APIを呼び出す。

### 出力項目（API取得）

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| バックプレッシャー情報 | backpressure | JobBackpressure | 全体のバックプレッシャー状態 |
| サブタスクバックプレッシャー | subtasks | JobBackpressureSubtask[] | サブタスク単位のバックプレッシャー情報 |

## 表示項目

### ヘッダー情報（RUNNING時のみ）

| 表示項目 | 対応データ | 説明 |
|----------|-----------|------|
| Measurement | end-timestamp | 「X ago」形式で最終測定からの経過時間 |
| Sampling in progress... | status === 'deprecated' | サンプリング中の表示 |
| Back Pressure Status | backpressure-level | 全体のバックプレッシャーレベルバッジ |

### サブタスク一覧

| 表示項目 | 対応データ | ソート | 幅 | 説明 |
|----------|-----------|-------|-----|------|
| SubTask | subtask, attempt-number | - | 16% | サブタスクID（展開可能） |
| Backpressure | ratio | 可 | 16% | バックプレッシャー率（%表示） |
| Idle | idleRatio | 可 | 16% | アイドル率（%表示） |
| Busy | busyRatio | 可（descend） | 16% | ビジー率（%表示、デフォルトソート） |
| Backpressure Status | backpressure-level | - | 16% | バックプレッシャーレベルバッジ |
| Thread Dump | - | - | 20% | スレッドダンプへのリンク |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化（ngOnInit）

**処理フロー**:
1. JobLocalService.jobWithVertexChanges()を購読
2. selectedVertexに頂点情報を格納
3. JobService.loadOperatorBackPressure(jobId, vertexId)でバックプレッシャー情報を取得
4. backpressureプロパティとlistOfSubTaskBackpressureに格納
5. JobService.loadSubTasks(jobId, vertexId)でサブタスク情報を取得
6. mapOfSubtaskにサブタスク情報をマップ形式で格納（スレッドダンプリンク用）
7. isLoadingをfalseに設定し、markForCheck()で画面を更新

### 2-展開/折りたたみ

**トリガー**: 複数試行があるサブタスクの展開アイコンクリック

**処理フロー**:
1. onExpandChange()でexpandSetにサブタスクIDを追加/削除
2. 展開時にother-concurrent-attemptsを表示

### 3-ソート

**トリガー**: カラムヘッダーのソートアイコンクリック

**処理フロー**:
1. sortByBackpressureRatio, sortByIdleRatio, sortByBusyRatioでソート
2. Busyカラムはデフォルトで降順ソート

### 4-スレッドダンプ表示

**トリガー**: Dumpリンククリック

**処理フロー**:
1. routerLinkでTaskManagerスレッドダンプ画面に遷移
2. queryParamsでvertexNameを渡し、スレッドの絞り込みに使用

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | REST API経由でバックプレッシャー情報を取得 |

本画面は参照専用であり、データベースへの更新処理は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| - | info | Sampling in progress... | status === 'deprecated' |
| - | warning | Operator is not running or initializing. Cannot sample back pressure. | status !== RUNNING && status !== INITIALIZING |

## 例外処理

| 例外状況 | 対応 | 表示 |
|---------|------|------|
| API通信エラー | catchErrorで{}を返却 | 空のテーブル表示 |
| オペレーターが停止中 | - | サンプリング不可のメッセージ表示 |

## 備考

- 仮想スクロール（nz-virtual-scroll）により大量のサブタスクを効率的に表示
- バックプレッシャー率、アイドル率、ビジー率はprettyPrint()で「XX%」形式に変換
- NaN値は「N/A」と表示
- Busyカラムはデフォルトで降順ソート（ビジー率が高いサブタスクを上位に表示）
- スレッドダンプリンクは別タブで開く（target="_blank"）
- 複数試行（other-concurrent-attempts）がある場合は展開して履歴を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、バックプレッシャー情報のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-backpressure.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-backpressure.ts` | JobBackpressure, JobBackpressureSubtaskインターフェースの構造 |

**読解のコツ**: JobBackpressureにはstatus, backpressure-level, end-timestamp, subtasksなどのプロパティ。JobBackpressureSubtaskにはsubtask, ratio, idleRatio, busyRatio, backpressure-level, other-concurrent-attemptsなどがある。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントファイルを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-overview-drawer-backpressure.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/backpressure/job-overview-drawer-backpressure.component.ts` | 2つのAPI呼び出し、展開処理、prettyPrint()、ソート関数 |

**主要処理フロー**:
1. **83-106行目**: ngOnInit()でバックプレッシャー情報を取得
2. **108-125行目**: サブタスク情報を取得しmapOfSubtaskに格納
3. **133-145行目**: onExpandChange()で展開/折りたたみ処理
4. **147-153行目**: prettyPrint()でバックプレッシャー率を%表示に変換
5. **155-165行目**: ソート関数定義

#### Step 3: サービス層を理解する

API呼び出しを行うサービスクラスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | loadOperatorBackPressure()メソッドの実装 |

**主要処理フロー**:
- **116-119行目**: loadOperatorBackPressure()がGETリクエストで`/jobs/${jobId}/vertices/${vertexId}/backpressure`を呼び出し

### プログラム呼び出し階層図

```
JobOverviewDrawerBackpressureComponent.ngOnInit()
    │
    ├─ JobLocalService.jobWithVertexChanges()
    │      ├─ selectedVertex = data.vertex
    │      │
    │      └─ mergeMap → JobService.loadOperatorBackPressure(jobId, vertexId)
    │             └─ HttpClient.get(`/jobs/${jid}/vertices/${vid}/backpressure`)
    │                    │
    │                    └─ backpressure, listOfSubTaskBackpressure
    │
    └─ JobLocalService.jobWithVertexChanges()
           └─ mergeMap → JobService.loadSubTasks(jobId, vertexId)
                  └─ HttpClient.get(`/jobs/${jid}/vertices/${vid}`)
                         │
                         └─ mapOfSubtask（スレッドダンプリンク用）
```

### データフロー図

```
[入力]               [処理]                         [出力]

JobWithVertex ───▶ loadOperatorBackPressure() ───▶ JobBackpressure
                          │
                          ▼
                   HTTPリクエスト
                          │
                          ▼
                   REST API サーバー
                          │
                          ▼
              ┌───────────┴───────────┐
              ▼                       ▼
        backpressure            subtasks[]
              │                       │
              ▼                       ▼
        ヘッダー表示           サブタスク一覧
        (Measurement,              │
         Status)                   ▼
                            prettyPrint()
                                   │
                                   ▼
                            テーブル表示
                            (ratio, idle, busy)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-overview-drawer-backpressure.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/backpressure/job-overview-drawer-backpressure.component.ts` | ソース | メインコンポーネント |
| job-overview-drawer-backpressure.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/backpressure/job-overview-drawer-backpressure.component.html` | テンプレート | 画面レイアウト定義 |
| job-overview-drawer-backpressure.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job/overview/backpressure/job-overview-drawer-backpressure.component.less` | スタイル | スタイル定義 |
| job-backpressure.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-backpressure.ts` | インターフェース | バックプレッシャーデータ型定義 |
| job.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job.service.ts` | サービス | API呼び出しサービス |
| job-local.service.ts | `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts` | サービス | ジョブ・頂点状態管理 |
| backpressure-badge.component.ts | `flink-runtime-web/web-dashboard/src/app/components/backpressure-badge/backpressure-badge.component.ts` | 共通コンポーネント | バックプレッシャーレベルバッジ |
