# 画面設計書 22-JobManager

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「JobManager」画面の設計仕様を記載したものである。この画面は、JobManagerの管理機能を提供するコンテナ画面であり、各種サブ画面（メトリクス、設定、ログ等）へのナビゲーションを提供する。

### 本画面の処理概要

**業務上の目的・背景**：Apache FlinkにおいてJobManagerは、クラスター全体のジョブ実行を調整する中心的なコンポーネントである。本画面は、JobManagerの監視・管理機能の入口として、オペレーターがJobManagerの状態を包括的に把握できるよう、各種監視画面へのナビゲーションを提供する。これにより、システム管理者は効率的にJobManagerのリソース使用状況、設定、ログ、スレッド情報などにアクセスできる。

**画面へのアクセス方法**：グローバルナビゲーション（サイドバー）から「Job Manager」を選択することでアクセスする。URLは `/job-manager` となる。デフォルトでは `/job-manager/metrics` にリダイレクトされる。

**主要な操作・処理内容**：
1. タブナビゲーションによる各サブ画面への遷移
2. 現在選択中のタブのハイライト表示
3. 各サブ画面コンテンツの表示領域（router-outlet）の管理

**画面遷移**：
- 遷移元：オーバービュー画面のグローバルナビゲーション
- 子画面：
  - Metrics（メトリクス）
  - Configuration（設定）
  - Logs（ログ）
  - Stdout（標準出力）
  - Log List（ログ一覧）
  - Thread Dump（スレッドダンプ）
  - Profiler（プロファイラ）

**権限による表示制御**：特別な権限制御はない。全てのユーザーがJobManagerの監視情報にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | JobManager情報取得のためのコンテナ画面 |
| 23 | ジョブ管理 | 補助機能 | 各サブ画面（メトリクス、設定、ログ等）への遷移制御 |

## 画面種別

コンテナ（親画面）

## URL/ルーティング

- パス: `/job-manager`
- デフォルトリダイレクト: `/job-manager/metrics`
- 子ルート:
  - `/job-manager/metrics` - メトリクス
  - `/job-manager/config` - 設定
  - `/job-manager/logs` - ログ
  - `/job-manager/stdout` - 標準出力
  - `/job-manager/log` - ログ一覧
  - `/job-manager/log/:logName` - ログ詳細
  - `/job-manager/thread-dump` - スレッドダンプ
  - `/job-manager/profiler` - プロファイラ

## 入出力項目

本画面はコンテナ画面のため、直接の入出力項目は持たない。

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| - | - | - | - | - | 子画面に委譲 |

## 表示項目

| 項目名 | 表示位置 | データソース | 書式 | 説明 |
|--------|----------|-------------|------|------|
| ナビゲーションタブ | 上部 | コンポーネント定数 | タブ形式 | Metrics, Configuration, Logs, Stdout, Log List, Thread Dump, Profiler |
| コンテンツ領域 | 中央～下部 | router-outlet | 動的 | 選択されたタブに対応するコンポーネント |

## イベント仕様

### 1-タブ選択

ナビゲーションタブをクリックした際に発火する。

- **トリガー**: タブクリック
- **処理内容**:
  1. Angular Routerによるルート遷移
  2. 対応するサブコンポーネントのロード
  3. URLの更新
- **後続処理**: 子コンポーネントの初期化とデータ取得

## データベース更新仕様

### 操作別データベース影響一覧

本画面はコンテナ画面であり、データベースへの更新処理は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

本画面はコンテナ画面のため、直接のメッセージ表示はない。各サブ画面でメッセージが表示される。

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | - | - |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 不正なサブパス | `/job-manager/metrics` にリダイレクト |

## 備考

- NavigationComponent を使用してタブナビゲーションを実装
- 各タブの遅延ロード（loadComponent）によりパフォーマンスを最適化
- OnPush変更検出戦略を採用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ルーティング定義を理解する

JobManager画面群のルーティング構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | routes.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/routes.ts` | JOB_MANAGER_ROUTES の定義、子ルートの構造 |

**読解のコツ**: loadComponent による遅延ロードパターンを確認。path が空文字のルートが親コンポーネント、children 配列が子ルートを定義。

#### Step 2: エントリーポイントを理解する

コンテナコンポーネントの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-manager.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.component.ts` | listOfNavigation の定義、NavigationComponent の使用 |

**主要処理フロー**:
1. **32-40行目**: listOfNavigation 配列でナビゲーションタブを定義
2. **29行目**: NavigationComponent と RouterOutlet をインポート

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.component.html` | flink-navigation と router-outlet の配置 |

**主要処理フロー**:
- **19行目**: flink-navigation にナビゲーション定義を渡す
- **20行目**: router-outlet で子コンポーネントを表示

#### Step 4: 設定を理解する

モジュール設定の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-manager.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.config.ts` | JobManagerModuleConfig, InjectionToken の定義 |

**主要処理フロー**:
- **28-33行目**: デフォルト設定（editorOptions, routerFactories）
- **35-38行目**: InjectionToken による依存性注入設定

### プログラム呼び出し階層図

```
JobManagerComponent (コンテナ)
    │
    ├─ NavigationComponent
    │      └─ タブナビゲーション表示
    │
    └─ <router-outlet>
           │
           ├─ JobManagerMetricsComponent (/metrics)
           ├─ JobManagerConfigurationComponent (/config)
           ├─ JobManagerLogsComponent (/logs)
           ├─ JobManagerStdoutComponent (/stdout)
           ├─ JobManagerLogListComponent (/log)
           ├─ JobManagerLogDetailComponent (/log/:logName)
           ├─ JobManagerThreadDumpComponent (/thread-dump)
           └─ JobManagerProfilerComponent (/profiler)
```

### データフロー図

```
[入力]                   [処理]                          [出力]

ユーザータブ選択 ───▶ Angular Router ───▶ URL変更 ───▶ router-outlet更新
                           │
                           ▼
                    対応する子コンポーネント
                       のロード・表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-manager.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.component.ts` | ソース | コンテナコンポーネント |
| job-manager.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.component.html` | テンプレート | UI構造定義 |
| job-manager.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.component.less` | スタイル | コンポーネント固有スタイル |
| routes.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/routes.ts` | ソース | ルーティング定義 |
| job-manager.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.config.ts` | ソース | モジュール設定 |
| navigation.component.ts | `flink-runtime-web/web-dashboard/src/app/components/navigation/navigation.component.ts` | ソース | タブナビゲーションコンポーネント |
