# 画面設計書 23-JobManagerメトリクス

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「JobManagerメトリクス」画面の設計仕様を記載したものである。この画面は、JobManagerのJVMメモリ使用状況、GC情報などのメトリクスを視覚的に表示し、リソース監視を支援する。

### 本画面の処理概要

**業務上の目的・背景**：JobManagerはFlinkクラスターの中核コンポーネントであり、そのリソース使用状況を把握することはシステム安定稼働に不可欠である。本画面では、JVMのヒープメモリ、メタスペース、ダイレクトメモリ、ガベージコレクション等の詳細メトリクスを可視化し、メモリリークやリソース不足の早期発見を支援する。Flinkメモリモデルに基づいた設定値と実測値の対比表示により、設定の妥当性も確認できる。

**画面へのアクセス方法**：グローバルナビゲーションから「Job Manager」を選択後、「Metrics」タブをクリック、または直接 `/job-manager/metrics` にアクセスする。JobManager画面のデフォルトタブでもある。

**主要な操作・処理内容**：
1. Flinkメモリモデルに基づくメモリ使用状況の表示
2. JVM Heap/Non-Heapメモリの詳細表示
3. Directメモリ/Mappedメモリの詳細表示
4. ガベージコレクション統計の表示
5. 自動リフレッシュによるメトリクス更新

**画面遷移**：
- 遷移元：JobManagerコンテナ画面のタブナビゲーション
- 同階層：Configuration、Logs、Stdout、Log List、Thread Dump、Profilerタブと相互遷移可能

**権限による表示制御**：特別な権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | JobManagerメトリクスの取得（/jobmanager/metrics API） |
| 57 | メトリクスコア | 補助機能 | JVMメモリ、GC情報などのメトリクス表示 |
| 4 | 設定管理 | API連携 | JobManager設定情報の取得・表示 |

## 画面種別

詳細（メトリクス表示）

## URL/ルーティング

- パス: `/job-manager/metrics`
- パラメータ: なし

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| メトリクス | metrics | 出力 | { [id: string]: number } | - | メトリクス値のマップ |
| JM設定 | jmConfig | 出力 | { [id: string]: string } | - | JobManager設定値のマップ |
| GCメトリクス | listOfGCMetric | 出力 | Array<{name, count, time}> | - | GC統計情報の配列 |

## 表示項目

| 項目名 | 表示位置 | データソース | 書式 | 説明 |
|--------|----------|-------------|------|------|
| Flinkメモリモデル図 | 左上 | 静的画像 | SVG画像 | メモリモデルの視覚的説明 |
| JVM Heap | テーブル1行目 | API | プログレスバー + 数値 | 設定値と使用率/最大値 |
| Off-Heap Memory | テーブル2行目 | API | 数値 | 設定値（メトリクス監視不可） |
| JVM Metaspace | テーブル3行目 | API | プログレスバー + 数値 | 設定値と使用率/最大値 |
| JVM Overhead | テーブル4行目 | API | 数値 | 設定値（Min/Max） |
| Heap詳細 | Advanced/JVMテーブル | API | 数値 | Committed/Used/Maximum |
| Non-Heap詳細 | Advanced/JVMテーブル | API | 数値 | Committed/Used/Maximum |
| Direct Memory | Advanced/Outsideテーブル | API | 数値 | Count/Used/Capacity |
| Mapped Memory | Advanced/Outsideテーブル | API | 数値 | Count/Used/Capacity |
| GC情報 | Advanced/GCテーブル | API | 数値 | Collector名/Count/Time |

## イベント仕様

### 1-初期化処理

コンポーネント初期化時（ngOnInit）に実行される。

- **トリガー**: コンポーネントマウント
- **処理内容**:
  1. loadConfig() でJobManager設定を取得
  2. loadMetricsName() でGCメトリクス名を取得
  3. loadMetrics() で全メトリクス値を取得
- **後続処理**: 画面の初期表示

### 2-自動リフレッシュ

StatusServiceの refresh$ によるポーリング更新。

- **トリガー**: statusService.refresh$ のイベント発火
- **処理内容**:
  1. GCメトリクス名の再取得
  2. 全メトリクス値の再取得
  3. listOfGCMetric の再計算
- **後続処理**: 画面の再レンダリング

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、データベースへの更新処理は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | - | 通常はメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 設定取得失敗 | 空の配列として処理を継続（catchError） |
| メトリクス取得失敗 | 該当項目を空または"-"で表示 |

## 備考

- メトリクスキー一覧:
  - Status.JVM.Memory.Heap.Used/Max/Committed
  - Status.JVM.Memory.Metaspace.Used/Max
  - Status.JVM.Memory.NonHeap.Committed/Used/Max
  - Status.JVM.Memory.Direct.Count/MemoryUsed/TotalCapacity
  - Status.JVM.Memory.Mapped.Count/MemoryUsed/TotalCapacity
  - Status.JVM.GarbageCollector.{name}.Count/Time
- 設定キー一覧:
  - jobmanager.memory.heap.size
  - jobmanager.memory.off-heap.size
  - jobmanager.memory.jvm-metaspace.size
  - jobmanager.memory.jvm-overhead.min/max

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定とメトリクスのインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configuration.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/configuration.ts` | ClusterConfiguration インターフェース |

**読解のコツ**: ClusterConfiguration は key-value ペアの単純な構造。設定値は文字列として保持される。

#### Step 2: エントリーポイントを理解する

メインコンポーネントの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-manager-metrics.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/metrics/job-manager-metrics.component.ts` | メトリクス取得と表示ロジック |

**主要処理フロー**:
1. **55-58行目**: メンバー変数定義（metrics, jmConfig, listOfGCName, listOfGCMetric）
2. **68-80行目**: loadConfig() で設定を取得し jmConfig にマッピング
3. **81-130行目**: refresh$ をサブスクライブしてメトリクスを定期更新
4. **83-88行目**: loadMetricsName() でGC関連のメトリクス名を抽出
5. **89-129行目**: loadMetrics() で全メトリクス値を取得
6. **111-127行目**: GCメトリクスの名前から重複を除去してリスト化

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造とデータバインディングを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager-metrics.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/metrics/job-manager-metrics.component.html` | メモリモデル表示とメトリクステーブル |

**主要処理フロー**:
- **18-131行目**: Flinkメモリモデルテーブル
- **45-46行目**: プログレスバーによるヒープ使用率表示
- **133-231行目**: Advancedセクション（詳細メトリクス）
- **136-166行目**: JVM Heap/Non-Heapテーブル
- **168-200行目**: Direct/Mappedメモリテーブル
- **203-229行目**: GCテーブル

#### Step 4: サービス層を理解する

REST API呼び出しを行うサービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | loadConfig, loadMetricsName, loadMetrics メソッド |

**主要処理フロー**:
- **43-45行目**: loadConfig() - /jobmanager/config API
- **93-97行目**: loadMetricsName() - /jobmanager/metrics API (名前一覧)
- **99-112行目**: loadMetrics() - /jobmanager/metrics API (値取得)

### プログラム呼び出し階層図

```
JobManagerMetricsComponent
    │
    ├─ ngOnInit()
    │      │
    │      ├─ JobManagerService.loadConfig()
    │      │      └─ HTTP GET /jobmanager/config
    │      │
    │      └─ StatusService.refresh$ (サブスクライブ)
    │             │
    │             ├─ JobManagerService.loadMetricsName()
    │             │      └─ HTTP GET /jobmanager/metrics
    │             │
    │             └─ JobManagerService.loadMetrics()
    │                    └─ HTTP GET /jobmanager/metrics?get={metrics}
    │
    └─ ngOnDestroy()
           └─ destroy$.next() (サブスクリプション解除)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

                      JobManagerService
                            │
/jobmanager/config ────────▶├─ loadConfig() ────────▶ jmConfig マップ
                            │                              │
/jobmanager/metrics ───────▶├─ loadMetricsName() ──▶ listOfGCName
                            │                              │
/jobmanager/metrics?get= ──▶└─ loadMetrics() ──────▶ metrics マップ
                                                           │
                                                           ▼
                                              listOfGCMetric 生成
                                                           │
                                                           ▼
                                             テンプレート描画
                                             (テーブル・プログレスバー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-manager-metrics.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/metrics/job-manager-metrics.component.ts` | ソース | メインコンポーネント |
| job-manager-metrics.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/metrics/job-manager-metrics.component.html` | テンプレート | UI構造定義 |
| job-manager-metrics.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/metrics/job-manager-metrics.component.less` | スタイル | コンポーネント固有スタイル |
| job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | ソース | API呼び出しサービス |
| status.service.ts | `flink-runtime-web/web-dashboard/src/app/services/status.service.ts` | ソース | 自動リフレッシュサービス |
| configuration.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/configuration.ts` | ソース | 設定インターフェース |
| process_mem_model.svg | `flink-runtime-web/web-dashboard/src/assets/images/process_mem_model.svg` | 画像 | メモリモデル図 |
