# 画面設計書 24-JobManager設定

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「JobManager設定」画面の設計仕様を記載したものである。この画面は、JobManagerの設定パラメータと環境情報を一覧表示する。

### 本画面の処理概要

**業務上の目的・背景**：Flinkクラスターの運用において、JobManagerの設定状態を把握することは問題解析やチューニングに不可欠である。本画面では、現在有効なFlinkの設定パラメータ（flink-conf.yaml相当）と、JVM環境情報（バージョン、クラスパス等）を一覧表示する。これにより、システム管理者は設定の確認やトラブルシューティングを効率的に行える。

**画面へのアクセス方法**：グローバルナビゲーションから「Job Manager」を選択後、「Configuration」タブをクリック、または直接 `/job-manager/config` にアクセスする。

**主要な操作・処理内容**：
1. 設定パラメータ一覧の表示（キー・値形式）
2. 設定の検索・フィルタリング
3. JVM環境情報（バージョン、アーキテクチャ、オプション）の表示
4. クラスパス情報の表示

**画面遷移**：
- 遷移元：JobManagerコンテナ画面のタブナビゲーション
- 同階層：Metrics、Logs、Stdout、Log List、Thread Dump、Profilerタブと相互遷移可能

**権限による表示制御**：特別な権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | JobManager設定の取得（/jobmanager/config API） |
| 4 | 設定管理 | 補助機能 | 設定パラメータの一覧表示 |

## 画面種別

一覧（設定一覧）

## URL/ルーティング

- パス: `/job-manager/config`
- パラメータ: なし

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| 設定一覧 | listOfConfig | 出力 | ClusterConfiguration[] | - | 設定キー・値のペア配列 |
| 環境情報 | environmentInfo | 出力 | EnvironmentInfo | - | JVM環境情報 |
| ローディング状態 | loading | 出力 | boolean | - | データ取得中フラグ |

## 表示項目

| 項目名 | 表示位置 | データソース | 書式 | 説明 |
|--------|----------|-------------|------|------|
| 設定カード | メイン領域 | API | カード形式 | ConfigurationCardsコンポーネントで表示 |
| 設定キー | カード内 | API | テキスト | 設定パラメータ名 |
| 設定値 | カード内 | API | テキスト | 設定パラメータ値 |
| JVMバージョン | 環境情報セクション | API | テキスト | JVMバージョン情報 |
| JVMアーキテクチャ | 環境情報セクション | API | テキスト | 32bit/64bit等 |
| JVMオプション | 環境情報セクション | API | リスト | JVM起動オプション |
| クラスパス | 環境情報セクション | API | リスト | クラスパスエントリ |

## イベント仕様

### 1-初期化処理

コンポーネント初期化時（ngOnInit）に実行される。

- **トリガー**: コンポーネントマウント
- **処理内容**:
  1. forkJoin で loadConfig() と loadEnvironment() を並列実行
  2. 設定データをキーでソート
  3. loading フラグを false に設定
- **後続処理**: 画面の初期表示

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、データベースへの更新処理は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | - | 通常はメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 設定取得失敗 | 空の配列として処理を継続 |
| 環境情報取得失敗 | undefined として処理を継続 |

## 備考

- 設定はキー名でアルファベット順にソート表示
- ConfigurationCardsComponent という共通コンポーネントを使用
- trackByConfig 関数でリスト描画を最適化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定と環境情報のインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configuration.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/configuration.ts` | ClusterConfiguration, EnvironmentInfo インターフェース |

**読解のコツ**: ClusterConfiguration は key-value ペア。EnvironmentInfo は jvm オブジェクト（version, arch, options）と classpath 配列を持つ。

#### Step 2: エントリーポイントを理解する

メインコンポーネントの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-manager-configuration.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/configuration/job-manager-configuration.component.ts` | forkJoin による並列取得とソート処理 |

**主要処理フロー**:
1. **35-37行目**: メンバー変数定義（listOfConfig, environmentInfo, loading）
2. **40-42行目**: trackByConfig 関数の定義
3. **46-58行目**: ngOnInit で forkJoin による並列API呼び出し
4. **54行目**: 設定をキーでソート

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager-configuration.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/configuration/job-manager-configuration.component.html` | ConfigurationCardsComponent の使用 |

**主要処理フロー**:
- **19-23行目**: flink-configuration-cards に設定と環境情報を渡す

#### Step 4: サービス層を理解する

REST API呼び出しを行うサービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | loadConfig, loadEnvironment メソッド |

**主要処理フロー**:
- **43-45行目**: loadConfig() - /jobmanager/config API
- **47-49行目**: loadEnvironment() - /jobmanager/environment API

### プログラム呼び出し階層図

```
JobManagerConfigurationComponent
    │
    └─ ngOnInit()
           │
           └─ forkJoin([
                  │
                  ├─ JobManagerService.loadConfig()
                  │      └─ HTTP GET /jobmanager/config
                  │
                  └─ JobManagerService.loadEnvironment()
                         └─ HTTP GET /jobmanager/environment
              ])
                  │
                  ▼
           設定ソート → 画面表示
```

### データフロー図

```
[入力]                         [処理]                          [出力]

/jobmanager/config ──────▶ loadConfig() ──────▶ listOfConfig
                                │                      │
                                ├─────────────────────▶ キーでソート
                                │                      │
/jobmanager/environment ─▶ loadEnvironment() ─▶ environmentInfo
                                                       │
                                                       ▼
                                        ConfigurationCardsComponent
                                                       │
                                                       ▼
                                                 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-manager-configuration.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/configuration/job-manager-configuration.component.ts` | ソース | メインコンポーネント |
| job-manager-configuration.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/configuration/job-manager-configuration.component.html` | テンプレート | UI構造定義 |
| job-manager-configuration.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/configuration/job-manager-configuration.component.less` | スタイル | コンポーネント固有スタイル |
| job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | ソース | API呼び出しサービス |
| configuration.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/configuration.ts` | ソース | データ型定義 |
| configuration-cards.component.ts | `flink-runtime-web/web-dashboard/src/app/components/configuration-cards/configuration-cards.component.ts` | ソース | 設定カード表示コンポーネント |
