# 画面設計書 25-JobManagerログ

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「JobManagerログ」画面の設計仕様を記載したものである。この画面は、JobManagerのメインログファイルの内容をコードエディタ形式で表示し、ログの確認・ダウンロードを支援する。

### 本画面の処理概要

**業務上の目的・背景**：Flinkクラスターの運用において、JobManagerのログは障害分析やデバッグに不可欠である。本画面では、JobManagerのメインログファイル（通常は flink-*-jobmanager-*.log）の内容をリアルタイムで表示し、システム管理者が効率的にログを確認できる。また、ログのダウンロード機能により、オフラインでの詳細分析も可能。

**画面へのアクセス方法**：グローバルナビゲーションから「Job Manager」を選択後、「Logs」タブをクリック、または直接 `/job-manager/logs` にアクセスする。

**主要な操作・処理内容**：
1. ログ内容のコードエディタ形式表示
2. ログの再読み込み（reload）
3. ログファイルのダウンロード

**画面遷移**：
- 遷移元：JobManagerコンテナ画面のタブナビゲーション
- 同階層：Metrics、Configuration、Stdout、Log List、Thread Dump、Profilerタブと相互遷移可能

**権限による表示制御**：特別な権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | JobManagerログの取得（/jobmanager/log API） |
| 23 | ジョブ管理 | 補助機能 | ログ内容のテキスト表示 |

## 画面種別

詳細（ログ表示）

## URL/ルーティング

- パス: `/job-manager/logs`
- パラメータ: なし

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| ログ内容 | logs | 出力 | string | - | ログファイルのテキスト内容 |
| ダウンロードURL | downloadUrl | 出力 | string | - | ログファイルのダウンロードURL |
| ダウンロード名 | downloadName | 出力 | string | - | ダウンロード時のファイル名 |
| ローディング状態 | loading | 出力 | boolean | - | データ取得中フラグ |

## 表示項目

| 項目名 | 表示位置 | データソース | 書式 | 説明 |
|--------|----------|-------------|------|------|
| コードエディタ | メイン領域 | API | Monaco Editor | ログ内容を構文ハイライト付きで表示 |
| 再読み込みボタン | フッター | ローカル | ボタン | ログの再取得 |
| ダウンロードリンク | フッター | 定数/API | リンク | ログファイルのダウンロード |
| ローディング表示 | エディタ内 | ローカル | スピナー | データ取得中の表示 |

## イベント仕様

### 1-初期化処理

コンポーネント初期化時（ngOnInit）に実行される。

- **トリガー**: コンポーネントマウント
- **処理内容**:
  1. reload() メソッドを呼び出し
  2. loadLogs() でログ内容を取得
- **後続処理**: 画面の初期表示

### 2-再読み込み

再読み込みボタンをクリックした際に発火する。

- **トリガー**: AddonCompactComponent の reload イベント
- **処理内容**:
  1. loading を true に設定
  2. loadLogs() でログ内容を再取得
  3. loading を false に設定
- **後続処理**: 画面の再レンダリング

### 3-ダウンロード

ダウンロードリンクをクリックした際に発火する。

- **トリガー**: AddonCompactComponent の downloadHref クリック
- **処理内容**:
  1. ブラウザのダウンロード処理が実行される
  2. downloadUrl（/jobmanager/log）からファイルをダウンロード
- **後続処理**: ファイルダウンロード開始

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、データベースへの更新処理は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | - | 通常はメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ログ取得失敗 | 空文字列として処理を継続（catchError で空文字を返す） |

## 備考

- Monaco Editor（ng-zorro-antd/code-editor）を使用
- editorOptions は JOB_MANAGER_MODULE_CONFIG から注入可能
- Cache-Control: no-cache ヘッダーでキャッシュを無効化
- downloadName は "jobmanager_log" 固定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: モジュール設定を理解する

エディタオプションの設定元を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-manager.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.config.ts` | JOB_MANAGER_MODULE_CONFIG, editorOptions の定義 |

**読解のコツ**: InjectionToken によるDI設定。editorOptions は flinkEditorOptions をデフォルト値として使用。

#### Step 2: エントリーポイントを理解する

メインコンポーネントの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-manager-logs.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/logs/job-manager-logs.component.ts` | ログ取得と表示ロジック |

**主要処理フロー**:
1. **45-49行目**: メンバー変数定義（downloadName, downloadUrl, editorOptions, logs, loading）
2. **53-61行目**: コンストラクタでDI注入（JobManagerService, ConfigService, moduleConfig）
3. **59行目**: editorOptions の設定（moduleConfigから取得または デフォルト）
4. **60行目**: downloadUrl の設定（BASE_URL + /jobmanager/log）
5. **63-65行目**: ngOnInit で reload() を呼び出し
6. **72-86行目**: reload() でログ内容を取得

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager-logs.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/logs/job-manager-logs.component.html` | コードエディタとアドオンコンポーネント |

**主要処理フロー**:
- **19-24行目**: nz-code-editor でログ表示
- **25-29行目**: flink-addon-compact でダウンロード・再読み込みボタン

#### Step 4: サービス層を理解する

REST API呼び出しを行うサービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | loadLogs メソッド |

**主要処理フロー**:
- **51-56行目**: loadLogs() - /jobmanager/log API（responseType: 'text'）
- **54-55行目**: Cache-Control: no-cache ヘッダー

### プログラム呼び出し階層図

```
JobManagerLogsComponent
    │
    ├─ constructor()
    │      └─ DI: JobManagerService, ConfigService, JOB_MANAGER_MODULE_CONFIG
    │
    ├─ ngOnInit()
    │      └─ reload()
    │
    └─ reload()
           │
           └─ JobManagerService.loadLogs()
                  └─ HTTP GET /jobmanager/log
                         (responseType: 'text', Cache-Control: no-cache)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

reload ボタン ───▶ reload() ───▶ loadLogs() ───▶ logs (テキスト)
                                    │                    │
                                    ▼                    ▼
                           HTTP GET /jobmanager/log   nz-code-editor
                                                         │
                                                         ▼
download リンク ──────────────────────────────▶ ファイルダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-manager-logs.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/logs/job-manager-logs.component.ts` | ソース | メインコンポーネント |
| job-manager-logs.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/logs/job-manager-logs.component.html` | テンプレート | UI構造定義 |
| job-manager-logs.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/logs/job-manager-logs.component.less` | スタイル | コンポーネント固有スタイル |
| job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | ソース | API呼び出しサービス |
| job-manager.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.config.ts` | ソース | モジュール設定 |
| addon-compact.component.ts | `flink-runtime-web/web-dashboard/src/app/components/addon-compact/addon-compact.component.ts` | ソース | ダウンロード・再読み込みコンポーネント |
| editor-config.ts | `flink-runtime-web/web-dashboard/src/app/components/editor/editor-config.ts` | ソース | エディタ設定 |
