# 画面設計書 26-JobManager標準出力

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「JobManager標準出力」画面の設計仕様を記載したものである。この画面は、JobManagerの標準出力（stdout）の内容をコードエディタ形式で表示し、出力内容の確認・ダウンロードを支援する。

### 本画面の処理概要

**業務上の目的・背景**：Flinkアプリケーションの開発・デバッグにおいて、System.out.println等による標準出力は重要なデバッグ手段である。本画面では、JobManagerプロセスの標準出力をリアルタイムで表示し、アプリケーションのデバッグやトラブルシューティングを支援する。特にカスタムコードからの出力確認に有用。

**画面へのアクセス方法**：グローバルナビゲーションから「Job Manager」を選択後、「Stdout」タブをクリック、または直接 `/job-manager/stdout` にアクセスする。

**主要な操作・処理内容**：
1. 標準出力内容のコードエディタ形式表示
2. 内容の再読み込み（reload）
3. 標準出力ファイルのダウンロード

**画面遷移**：
- 遷移元：JobManagerコンテナ画面のタブナビゲーション
- 同階層：Metrics、Configuration、Logs、Log List、Thread Dump、Profilerタブと相互遷移可能

**権限による表示制御**：特別な権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | JobManager標準出力の取得（/jobmanager/stdout API） |
| 23 | ジョブ管理 | 補助機能 | 標準出力内容のテキスト表示 |

## 画面種別

詳細（標準出力表示）

## URL/ルーティング

- パス: `/job-manager/stdout`
- パラメータ: なし

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| 標準出力内容 | stdout | 出力 | string | - | 標準出力のテキスト内容 |
| ダウンロードURL | downloadUrl | 出力 | string | - | 標準出力ファイルのダウンロードURL |
| ダウンロード名 | downloadName | 出力 | string | - | ダウンロード時のファイル名 |
| ローディング状態 | loading | 出力 | boolean | - | データ取得中フラグ |

## 表示項目

| 項目名 | 表示位置 | データソース | 書式 | 説明 |
|--------|----------|-------------|------|------|
| コードエディタ | メイン領域 | API | Monaco Editor | 標準出力内容を表示 |
| 再読み込みボタン | フッター | ローカル | ボタン | 内容の再取得 |
| ダウンロードリンク | フッター | 定数/API | リンク | 標準出力ファイルのダウンロード |
| ローディング表示 | エディタ内 | ローカル | スピナー | データ取得中の表示 |

## イベント仕様

### 1-初期化処理

コンポーネント初期化時（ngOnInit）に実行される。

- **トリガー**: コンポーネントマウント
- **処理内容**:
  1. reload() メソッドを呼び出し
  2. loadStdout() で標準出力内容を取得
- **後続処理**: 画面の初期表示

### 2-再読み込み

再読み込みボタンをクリックした際に発火する。

- **トリガー**: AddonCompactComponent の reload イベント
- **処理内容**:
  1. loading を true に設定
  2. loadStdout() で標準出力内容を再取得
  3. loading を false に設定
- **後続処理**: 画面の再レンダリング

### 3-ダウンロード

ダウンロードリンクをクリックした際に発火する。

- **トリガー**: AddonCompactComponent の downloadHref クリック
- **処理内容**:
  1. ブラウザのダウンロード処理が実行される
  2. downloadUrl（/jobmanager/stdout）からファイルをダウンロード
- **後続処理**: ファイルダウンロード開始

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、データベースへの更新処理は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | - | 通常はメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 標準出力取得失敗 | 空文字列として処理を継続（catchError で空文字を返す） |

## 備考

- Monaco Editor（ng-zorro-antd/code-editor）を使用
- editorOptions は JOB_MANAGER_MODULE_CONFIG から注入可能
- Cache-Control: no-cache ヘッダーでキャッシュを無効化
- downloadName は "jobmanager_stdout" 固定
- 構造は JobManagerLogsComponent とほぼ同一

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: モジュール設定を理解する

エディタオプションの設定元を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-manager.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.config.ts` | JOB_MANAGER_MODULE_CONFIG, editorOptions の定義 |

#### Step 2: エントリーポイントを理解する

メインコンポーネントの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-manager-stdout.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/stdout/job-manager-stdout.component.ts` | 標準出力取得と表示ロジック |

**主要処理フロー**:
1. **42-46行目**: メンバー変数定義（downloadName, downloadUrl, editorOptions, stdout, loading）
2. **50-58行目**: コンストラクタでDI注入
3. **56行目**: editorOptions の設定
4. **57行目**: downloadUrl の設定（BASE_URL + /jobmanager/stdout）
5. **60-62行目**: ngOnInit で reload() を呼び出し
6. **69-83行目**: reload() で標準出力内容を取得

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager-stdout.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/stdout/job-manager-stdout.component.html` | コードエディタとアドオンコンポーネント |

**主要処理フロー**:
- **19-24行目**: nz-code-editor で標準出力表示
- **25-29行目**: flink-addon-compact でダウンロード・再読み込みボタン

#### Step 4: サービス層を理解する

REST API呼び出しを行うサービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | loadStdout メソッド |

**主要処理フロー**:
- **58-63行目**: loadStdout() - /jobmanager/stdout API（responseType: 'text'）
- **61-62行目**: Cache-Control: no-cache ヘッダー

### プログラム呼び出し階層図

```
JobManagerStdoutComponent
    │
    ├─ constructor()
    │      └─ DI: JobManagerService, ConfigService, JOB_MANAGER_MODULE_CONFIG
    │
    ├─ ngOnInit()
    │      └─ reload()
    │
    └─ reload()
           │
           └─ JobManagerService.loadStdout()
                  └─ HTTP GET /jobmanager/stdout
                         (responseType: 'text', Cache-Control: no-cache)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

reload ボタン ───▶ reload() ───▶ loadStdout() ───▶ stdout (テキスト)
                                     │                     │
                                     ▼                     ▼
                           HTTP GET /jobmanager/stdout  nz-code-editor
                                                           │
                                                           ▼
download リンク ───────────────────────────────▶ ファイルダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-manager-stdout.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/stdout/job-manager-stdout.component.ts` | ソース | メインコンポーネント |
| job-manager-stdout.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/stdout/job-manager-stdout.component.html` | テンプレート | UI構造定義 |
| job-manager-stdout.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/stdout/job-manager-stdout.component.less` | スタイル | コンポーネント固有スタイル |
| job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | ソース | API呼び出しサービス |
| job-manager.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.config.ts` | ソース | モジュール設定 |
| addon-compact.component.ts | `flink-runtime-web/web-dashboard/src/app/components/addon-compact/addon-compact.component.ts` | ソース | ダウンロード・再読み込みコンポーネント |
