# 画面設計書 27-JobManagerログ一覧

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「JobManagerログ一覧」画面の設計仕様を記載したものである。この画面は、JobManagerのログファイル一覧をテーブル形式で表示し、各ログファイルの詳細表示への遷移を提供する。

### 本画面の処理概要

**業務上の目的・背景**：Flinkクラスターでは複数のログファイル（メインログ、ローテーションされた過去ログ、デバッグログ等）が生成される。本画面では、JobManagerに存在する全ログファイルの一覧を表示し、ファイル名・更新日時・サイズでソート・選択できる。これにより、システム管理者は必要なログファイルを効率的に見つけ、詳細を確認できる。

**画面へのアクセス方法**：グローバルナビゲーションから「Job Manager」を選択後、「Log List」タブをクリック、または直接 `/job-manager/log` にアクセスする。

**主要な操作・処理内容**：
1. ログファイル一覧の表示（名前、更新日時、サイズ）
2. 更新日時・サイズでのソート
3. ログファイル選択によるログ詳細画面への遷移

**画面遷移**：
- 遷移元：JobManagerコンテナ画面のタブナビゲーション
- 遷移先：JobManagerログ詳細画面（/job-manager/log/:logName）
- 同階層：Metrics、Configuration、Logs、Stdout、Thread Dump、Profilerタブと相互遷移可能

**権限による表示制御**：特別な権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | JobManagerログファイル一覧の取得（/jobmanager/logs API） |
| 23 | ジョブ管理 | 補助機能 | ログファイルの選択・詳細画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/job-manager/log`
- パラメータ: なし

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| ログ一覧 | listOfLog | 出力 | JobManagerLogItem[] | - | ログファイル情報の配列 |
| ローディング状態 | isLoading | 出力 | boolean | - | データ取得中フラグ |

## 表示項目

| 項目名 | 表示位置 | データソース | 書式 | 説明 |
|--------|----------|-------------|------|------|
| Log Name | テーブル1列目 | API | リンク | ログファイル名（クリックで詳細へ） |
| Last Modified Time | テーブル2列目 | API | yyyy-MM-dd HH:mm:ss.SSS | 最終更新日時 |
| Size (KB) | テーブル3列目 | API | 数値（小数2桁） | ファイルサイズ（KB単位） |
| ローディング表示 | テーブル全体 | ローカル | スピナー | データ取得中の表示 |

## イベント仕様

### 1-初期化処理

コンポーネント初期化時（ngOnInit）に実行される。

- **トリガー**: コンポーネントマウント
- **処理内容**:
  1. loadLogList() でログファイル一覧を取得
  2. isLoading を false に設定
- **後続処理**: 画面の初期表示

### 2-ソート実行

テーブルヘッダーのソートアイコンをクリックした際に発火する。

- **トリガー**: テーブルヘッダークリック（nzSortFn）
- **処理内容**:
  1. sortLastModifiedTimeFn または sortSizeFn によるソート
  2. テーブルの再レンダリング
- **後続処理**: ソートされたテーブル表示

### 3-ログファイル選択

ログファイル名のリンクをクリックした際に発火する。

- **トリガー**: ファイル名リンククリック
- **処理内容**:
  1. logRouterFactory(logName) でルートを生成
  2. /job-manager/log/:logName に遷移
- **後続処理**: ログ詳細画面への遷移

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、データベースへの更新処理は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | - | 通常はメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ログ一覧取得失敗 | 空配列として処理を継続（catchError） |

## 備考

- 仮想スクロール（nzVirtualScroll）を使用して大量ファイルに対応
- trackByName 関数でリスト描画を最適化
- narrowLogData 関数で型安全なデータアクセス
- テーブル列幅は 50%, 25%, 25% で固定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログアイテムのインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts` | JobManagerLogItem インターフェース（name, size, mtime） |

**読解のコツ**: mtime はエポックミリ秒のタイムスタンプ。size はバイト単位。

#### Step 2: エントリーポイントを理解する

メインコンポーネントの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-manager-log-list.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-list/job-manager-log-list.component.ts` | ログ一覧取得とソートロジック |

**主要処理フロー**:
1. **45-46行目**: trackByName, narrowLogData の定義
2. **48-50行目**: ソート関数の定義（sortLastModifiedTimeFn, sortSizeFn）
3. **52-54行目**: メンバー変数定義（listOfLog, isLoading, logRouterFactory）
4. **58-65行目**: コンストラクタでDI注入とlogRouterFactory設定
5. **67-81行目**: ngOnInit で loadLogList() を呼び出し

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager-log-list.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-list/job-manager-log-list.component.html` | 仮想スクロールテーブルとソート機能 |

**主要処理フロー**:
- **19-32行目**: nz-table の設定（仮想スクロール、サイズ、ローディング）
- **35-38行目**: テーブルヘッダー（ソート関数の指定）
- **41-53行目**: 仮想スクロールテンプレート（nz-virtual-scroll）
- **44-45行目**: routerLink によるログ詳細への遷移

#### Step 4: サービス層を理解する

REST API呼び出しを行うサービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | loadLogList メソッド |

**主要処理フロー**:
- **65-69行目**: loadLogList() - /jobmanager/logs API
- **68行目**: レスポンスから logs 配列を抽出（map(data => data.logs)）

### プログラム呼び出し階層図

```
JobManagerLogListComponent
    │
    ├─ constructor()
    │      └─ DI: JobManagerService, JOB_MANAGER_MODULE_CONFIG
    │             └─ logRouterFactory 設定
    │
    └─ ngOnInit()
           │
           └─ JobManagerService.loadLogList()
                  │
                  └─ HTTP GET /jobmanager/logs
                         │
                         ▼
                  map(data => data.logs)
                         │
                         ▼
                  listOfLog に設定
```

### データフロー図

```
[入力]                      [処理]                           [出力]

                     JobManagerService
                           │
/jobmanager/logs ─────────▶ loadLogList() ──▶ JobManagerLogItem[]
                                                     │
                                                     ▼
                                              listOfLog
                                                     │
                                        ┌────────────┼────────────┐
                                        ▼            ▼            ▼
                                   テーブル表示    ソート       リンク
                                                              クリック
                                                                 │
                                                                 ▼
                                                        ログ詳細画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-manager-log-list.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-list/job-manager-log-list.component.ts` | ソース | メインコンポーネント |
| job-manager-log-list.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-list/job-manager-log-list.component.html` | テンプレート | UI構造定義 |
| job-manager-log-list.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-list/job-manager-log-list.component.less` | スタイル | コンポーネント固有スタイル |
| job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | ソース | API呼び出しサービス |
| job-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts` | ソース | データ型定義 |
| job-manager.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.config.ts` | ソース | ルーターファクトリ設定 |
