# 画面設計書 28-JobManagerログ詳細

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「JobManagerログ詳細」画面の設計仕様を記載したものである。この画面は、選択されたログファイルの内容をコードエディタ形式で表示し、ログの確認・ダウンロード・全画面表示を支援する。

### 本画面の処理概要

**業務上の目的・背景**：ログ一覧画面から選択した特定のログファイルの内容を詳細に確認する必要がある。本画面では、指定されたログファイルの全内容をMonaco Editorで表示し、構文ハイライトやスクロール、検索機能を活用した効率的なログ分析を可能にする。また、全画面モードやダウンロード機能により、詳細な分析をサポートする。

**画面へのアクセス方法**：JobManagerログ一覧画面（/job-manager/log）からログファイル名をクリック、または直接 `/job-manager/log/:logName` にアクセスする。

**主要な操作・処理内容**：
1. 指定ログファイルの内容表示
2. パンくずリストによるログ一覧への戻り
3. ログ内容の再読み込み（reload）
4. ログファイルのダウンロード
5. 全画面表示の切り替え

**画面遷移**：
- 遷移元：JobManagerログ一覧画面
- 遷移先：JobManagerログ一覧画面（パンくずリストから）

**権限による表示制御**：特別な権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | 選択したログファイル内容の取得 |
| 23 | ジョブ管理 | 補助機能 | ログ内容の詳細表示 |

## 画面種別

詳細（ログ詳細）

## URL/ルーティング

- パス: `/job-manager/log/:logName`
- パラメータ:
  - `logName`: ログファイル名（URLエンコード必要）

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| ログファイル名 | logName | 入力 | string | Yes | URLパラメータから取得 |
| ログ内容 | logs | 出力 | string | - | ログファイルのテキスト内容 |
| ダウンロードURL | downloadUrl | 出力 | string | - | ログファイルのダウンロードURL |
| ローディング状態 | isLoading | 出力 | boolean | - | データ取得中フラグ |
| 全画面状態 | isFullScreen | 出力 | boolean | - | 全画面モードフラグ |

## 表示項目

| 項目名 | 表示位置 | データソース | 書式 | 説明 |
|--------|----------|-------------|------|------|
| パンくずリスト | 上部 | ローカル | nz-breadcrumb | Log List > {logName} |
| 再読み込みボタン | 上部右 | ローカル | アイコンボタン | ログの再取得 |
| ダウンロードリンク | 上部右 | API | リンク | ログファイルのダウンロード |
| 全画面切り替え | 上部右 | ローカル | トグルボタン | 全画面モードの切り替え |
| コードエディタ | メイン領域 | API | Monaco Editor | ログ内容を構文ハイライト付きで表示 |
| ローディング表示 | エディタ内 | ローカル | スピナー | データ取得中の表示 |

## イベント仕様

### 1-初期化処理

コンポーネント初期化時（ngOnInit）に実行される。

- **トリガー**: コンポーネントマウント
- **処理内容**:
  1. activatedRoute.snapshot.params.logName からログファイル名を取得
  2. reload() メソッドを呼び出し
  3. loadLog(logName) でログ内容を取得
- **後続処理**: 画面の初期表示

### 2-再読み込み

再読み込みボタンをクリックした際に発火する。

- **トリガー**: AddonInlineComponent の reload イベント
- **処理内容**:
  1. isLoading を true に設定
  2. loadLog(logName) でログ内容を再取得
  3. isLoading を false に設定、downloadUrl を更新
- **後続処理**: 画面の再レンダリング

### 3-全画面切り替え

全画面ボタンをクリックした際に発火する。

- **トリガー**: AddonInlineComponent の fullScreen イベント
- **処理内容**:
  1. toggleFullScreen(fullScreen) で isFullScreen を更新
  2. ホスト要素に full-screen クラスを適用/解除
- **後続処理**: 画面表示の切り替え

### 4-ログ一覧へ戻る

パンくずリストの「Log List」をクリックした際に発火する。

- **トリガー**: パンくずリストリンククリック
- **処理内容**:
  1. routerLink="../" で親パスに遷移
- **後続処理**: ログ一覧画面への遷移

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、データベースへの更新処理は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | - | 通常はメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ログ取得失敗 | isLoading を false に設定（finalize で処理） |
| 存在しないログファイル | APIエラーとして処理、画面は空で表示 |

## 備考

- Monaco Editor（ng-zorro-antd/code-editor）を使用
- editorOptions は JOB_MANAGER_MODULE_CONFIG から注入可能
- Cache-Control: no-cache ヘッダーでキャッシュを無効化
- ホストバインディングで full-screen クラスを制御
- AddonInlineComponent でインラインツールバーを提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログ詳細のレスポンス型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts` | JobManagerLogDetail インターフェース（data, url） |

**読解のコツ**: loadLog() の戻り値は data（ログ内容）と url（ダウンロードURL）を持つオブジェクト。

#### Step 2: エントリーポイントを理解する

メインコンポーネントの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-manager-log-detail.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-detail/job-manager-log-detail.component.ts` | ログ詳細取得と全画面モード |

**主要処理フロー**:
1. **56-61行目**: メンバー変数定義（logs, logName, downloadUrl, isLoading, isFullScreen, editorOptions）
2. **41-43行目**: ホストバインディングで full-screen クラス制御
3. **74-77行目**: ngOnInit で logName 取得と reload() 呼び出し
4. **84-100行目**: reload() でログ内容取得
5. **102-104行目**: toggleFullScreen() で全画面切り替え

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager-log-detail.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-detail/job-manager-log-detail.component.html` | パンくずリストとコードエディタ |

**主要処理フロー**:
- **19-30行目**: パンくずリスト（nz-breadcrumb）
- **31-37行目**: flink-addon-inline でツールバー
- **39-46行目**: nz-code-editor でログ表示

#### Step 4: サービス層を理解する

REST API呼び出しを行うサービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | loadLog メソッド |

**主要処理フロー**:
- **71-83行目**: loadLog(logName) - /jobmanager/logs/{logName} API
- **72行目**: URL構築
- **73-82行目**: レスポンスを { data, url } に変換

### プログラム呼び出し階層図

```
JobManagerLogDetailComponent
    │
    ├─ constructor()
    │      └─ DI: JobManagerService, ActivatedRoute, JOB_MANAGER_MODULE_CONFIG
    │
    ├─ ngOnInit()
    │      ├─ activatedRoute.snapshot.params.logName
    │      └─ reload()
    │
    ├─ reload()
    │      │
    │      └─ JobManagerService.loadLog(logName)
    │             │
    │             └─ HTTP GET /jobmanager/logs/{logName}
    │                    (responseType: 'text', Cache-Control: no-cache)
    │
    └─ toggleFullScreen(fullScreen)
           └─ isFullScreen 更新 → ホストクラス反映
```

### データフロー図

```
[入力]                      [処理]                            [出力]

URL パラメータ ───▶ logName 取得
      │
      ▼
/jobmanager/logs/{logName} ───▶ loadLog() ───▶ { data, url }
                                                    │
                                                    ├─▶ logs (テキスト)
                                                    │        │
                                                    │        ▼
                                                    │   nz-code-editor
                                                    │
                                                    └─▶ downloadUrl
                                                             │
                                                             ▼
                                                    ダウンロードリンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-manager-log-detail.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-detail/job-manager-log-detail.component.ts` | ソース | メインコンポーネント |
| job-manager-log-detail.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-detail/job-manager-log-detail.component.html` | テンプレート | UI構造定義 |
| job-manager-log-detail.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-detail/job-manager-log-detail.component.less` | スタイル | コンポーネント固有スタイル |
| job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | ソース | API呼び出しサービス |
| job-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts` | ソース | データ型定義 |
| addon-inline.component.ts | `flink-runtime-web/web-dashboard/src/app/components/addon-inline/addon-inline.component.ts` | ソース | インラインツールバーコンポーネント |
