# 画面設計書 29-JobManagerスレッドダンプ

## 概要

本ドキュメントは、Apache Flink Web Dashboardの「JobManagerスレッドダンプ」画面の設計仕様を記載したものである。この画面は、JobManagerプロセスのJVMスレッドダンプを取得・表示し、スレッドの状態分析やデッドロック検出を支援する。

### 本画面の処理概要

**業務上の目的・背景**：分散システムにおいて、スレッドの状態把握はパフォーマンス問題やデッドロック、ハング状態の診断に不可欠である。本画面では、JobManager JVMの全スレッドのスタックトレースを取得・表示し、問題のあるスレッドの特定や、リソース競合の分析を支援する。これは本番環境での問題調査において特に重要な機能である。

**画面へのアクセス方法**：グローバルナビゲーションから「Job Manager」を選択後、「Thread Dump」タブをクリック、または直接 `/job-manager/thread-dump` にアクセスする。

**主要な操作・処理内容**：
1. スレッドダンプの取得・表示
2. スレッドダンプの再取得（reload）
3. スレッドダンプのダウンロード

**画面遷移**：
- 遷移元：JobManagerコンテナ画面のタブナビゲーション
- 同階層：Metrics、Configuration、Logs、Stdout、Log List、Profilerタブと相互遷移可能

**権限による表示制御**：特別な権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | スレッドダンプの取得（/jobmanager/thread-dump API） |
| 23 | ジョブ管理 | 補助機能 | スレッド情報のテキスト表示 |

## 画面種別

詳細（スレッドダンプ表示）

## URL/ルーティング

- パス: `/job-manager/thread-dump`
- パラメータ: なし

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| スレッドダンプ | dump | 出力 | string | - | スレッドダンプのテキスト内容 |
| ダウンロードURL | downloadUrl | 出力 | string | - | スレッドダンプのダウンロードURL |
| ダウンロード名 | downloadName | 出力 | string | - | ダウンロード時のファイル名 |
| ローディング状態 | loading | 出力 | boolean | - | データ取得中フラグ |

## 表示項目

| 項目名 | 表示位置 | データソース | 書式 | 説明 |
|--------|----------|-------------|------|------|
| コードエディタ | メイン領域 | API | Monaco Editor | スレッドダンプを構文ハイライト付きで表示 |
| 再読み込みボタン | フッター | ローカル | ボタン | スレッドダンプの再取得 |
| ダウンロードリンク | フッター | 定数/API | リンク | スレッドダンプのダウンロード |
| ローディング表示 | エディタ内 | ローカル | スピナー | データ取得中の表示 |

## イベント仕様

### 1-初期化処理

コンポーネント初期化時（ngOnInit）に実行される。

- **トリガー**: コンポーネントマウント
- **処理内容**:
  1. reload() メソッドを呼び出し
  2. loadThreadDump() でスレッドダンプを取得
- **後続処理**: 画面の初期表示

### 2-再読み込み

再読み込みボタンをクリックした際に発火する。

- **トリガー**: AddonCompactComponent の reload イベント
- **処理内容**:
  1. loading を true に設定
  2. loadThreadDump() でスレッドダンプを再取得
  3. loading を false に設定
- **後続処理**: 画面の再レンダリング

### 3-ダウンロード

ダウンロードリンクをクリックした際に発火する。

- **トリガー**: AddonCompactComponent の downloadHref クリック
- **処理内容**:
  1. ブラウザのダウンロード処理が実行される
  2. downloadUrl（/jobmanager/thread-dump）からファイルをダウンロード
- **後続処理**: ファイルダウンロード開始

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、データベースへの更新処理は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | - | 通常はメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| スレッドダンプ取得失敗 | 空文字列として処理を継続（catchError で空文字を返す） |

## 備考

- Monaco Editor（ng-zorro-antd/code-editor）を使用
- editorOptions は JOB_MANAGER_MODULE_CONFIG から注入可能
- downloadName は "jobmanager_thread_dump" 固定
- APIレスポンスの threadInfos 配列から stringifiedThreadInfo を結合して表示
- 各スレッドの情報には、スレッド名、状態、スタックトレースが含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スレッドダンプのレスポンス型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts` | JobManagerThreadDump, JobManagerThreadInfo インターフェース |

**読解のコツ**: threadInfos 配列の各要素は threadName と stringifiedThreadInfo を持つ。サービス層で stringifiedThreadInfo を結合して文字列化。

#### Step 2: エントリーポイントを理解する

メインコンポーネントの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-manager-thread-dump.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/thread-dump/job-manager-thread-dump.component.ts` | スレッドダンプ取得と表示ロジック |

**主要処理フロー**:
1. **42-46行目**: メンバー変数定義（downloadName, downloadUrl, editorOptions, dump, loading）
2. **50-58行目**: コンストラクタでDI注入
3. **56行目**: editorOptions の設定
4. **57行目**: downloadUrl の設定（BASE_URL + /jobmanager/thread-dump）
5. **60-62行目**: ngOnInit で reload() を呼び出し
6. **69-83行目**: reload() でスレッドダンプ取得

#### Step 3: テンプレートを理解する

HTMLテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | job-manager-thread-dump.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/thread-dump/job-manager-thread-dump.component.html` | コードエディタとアドオンコンポーネント |

**主要処理フロー**:
- **19-24行目**: nz-code-editor でスレッドダンプ表示
- **25-29行目**: flink-addon-compact でダウンロード・再読み込みボタン

#### Step 4: サービス層を理解する

REST API呼び出しを行うサービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | loadThreadDump メソッド |

**主要処理フロー**:
- **85-91行目**: loadThreadDump() - /jobmanager/thread-dump API
- **87-89行目**: threadInfos から stringifiedThreadInfo を結合

### プログラム呼び出し階層図

```
JobManagerThreadDumpComponent
    │
    ├─ constructor()
    │      └─ DI: JobManagerService, ConfigService, JOB_MANAGER_MODULE_CONFIG
    │
    ├─ ngOnInit()
    │      └─ reload()
    │
    └─ reload()
           │
           └─ JobManagerService.loadThreadDump()
                  │
                  └─ HTTP GET /jobmanager/thread-dump
                         │
                         ▼
                  map(threadDump => threadDump.threadInfos
                      .map(info => info.stringifiedThreadInfo)
                      .join(''))
```

### データフロー図

```
[入力]                         [処理]                           [出力]

                        JobManagerService
                              │
/jobmanager/thread-dump ─────▶ loadThreadDump()
                                   │
                                   ▼
                            JobManagerThreadDump
                            { threadInfos: [...] }
                                   │
                                   ▼
                            map + join 処理
                                   │
                                   ▼
                            dump (string)
                                   │
                                   ▼
                            nz-code-editor
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-manager-thread-dump.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/thread-dump/job-manager-thread-dump.component.ts` | ソース | メインコンポーネント |
| job-manager-thread-dump.component.html | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/thread-dump/job-manager-thread-dump.component.html` | テンプレート | UI構造定義 |
| job-manager-thread-dump.component.less | `flink-runtime-web/web-dashboard/src/app/pages/job-manager/thread-dump/job-manager-thread-dump.component.less` | スタイル | コンポーネント固有スタイル |
| job-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts` | ソース | API呼び出しサービス |
| job-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts` | ソース | データ型定義 |
| addon-compact.component.ts | `flink-runtime-web/web-dashboard/src/app/components/addon-compact/addon-compact.component.ts` | ソース | ダウンロード・再読み込みコンポーネント |
