# 画面設計書 31-TaskManager一覧

## 概要

本ドキュメントは、Apache Flink Web DashboardのTaskManager一覧画面の設計仕様を定義する。この画面はFlinkクラスター内で稼働しているすべてのTaskManagerのリソース状況を一覧形式で表示し、個別のTaskManager詳細画面への導線を提供する。

### 本画面の処理概要

**業務上の目的・背景**：Apache Flinkの分散処理基盤において、TaskManagerはジョブの実際のタスクを実行するワーカーノードである。クラスター運用者は、TaskManagerの稼働状況（ハートビート、スロット利用状況、リソース消費量）を監視し、クラスターのヘルス状態を把握する必要がある。本画面は、すべてのTaskManagerを一覧表示し、リソースの過不足やノードの異常を早期に発見するための監視ポイントを提供する。また、特定のTaskManagerに問題が発生した場合に、詳細画面への迅速なアクセスを可能にする。

**画面へのアクセス方法**：グローバルナビゲーションの「Task Managers」メニューをクリックすることでアクセスする。URLは `/task-manager` である。オーバービュー画面のサイドナビゲーションからも直接遷移可能。

**主要な操作・処理内容**：
1. TaskManager一覧の自動更新による最新情報の取得（StatusServiceのrefresh$によるポーリング）
2. 各列のソート機能によるTaskManagerの並び替え（Data Port、Last Heartbeat、All Slots、Free Slots、Assigned Tasks、CPU Cores、Physical MEM、JVM Heap Size、Flink Managed MEM）
3. 任意のTaskManager行をクリックして詳細画面への遷移

**画面遷移**：
- 遷移元：オーバービュー画面、グローバルナビゲーション
- 遷移先：TaskManager詳細画面（`/task-manager/:id/metrics`）

**権限による表示制御**：本画面には権限による表示制御は実装されていない。Flink Web Dashboardにアクセス可能なすべてのユーザーが閲覧可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | TaskManager一覧の取得（/taskmanagers API） |
| 24 | タスク実行 | 補助機能 | TaskManagerのリソース情報（CPU、メモリ、スロット）表示 |

## 画面種別

一覧画面

## URL/ルーティング

`/task-manager`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| - | - | - | - | 本画面に入力項目はなし |

## 表示項目

| 項目名 | データ型 | 説明 | ソート可否 |
|--------|----------|------|------------|
| Path, ID | string | TaskManagerのIDとパス（ホスト名:ポート形式） | 不可 |
| Data Port | number | データ通信用ポート番号 | 可 |
| Last Heartbeat | Date | 最後のハートビート受信時刻 | 可 |
| All Slots | number | TaskManagerが持つ全スロット数 | 可 |
| Free Slots | number | 未使用のスロット数 | 可 |
| Assigned Tasks | number | 割り当てられたタスク数 | 可 |
| CPU Cores | number | CPUコア数 | 可 |
| Physical MEM | bytes | 物理メモリ容量（humanizeBytes形式で表示） | 可 |
| JVM Heap Size | bytes | JVMヒープサイズ（humanizeBytes形式で表示） | 可 |
| Flink Managed MEM | bytes | Flink管理メモリ容量（humanizeBytes形式で表示） | 可 |
| Blocked Badge | boolean | ブロック状態を示すバッジ（blocked=trueの場合のみ表示） | 不可 |

## イベント仕様

### 1-TaskManager行クリック

- **イベント種別**：クリック
- **処理内容**：選択したTaskManagerの詳細画面へ遷移
- **遷移先**：`/task-manager/:taskManagerId/metrics`
- **パラメータ引き継ぎ**：クエリパラメータを保持（queryParamsHandling: 'preserve'）

### 2-列ヘッダークリック（ソート）

- **イベント種別**：クリック
- **処理内容**：クリックした列でテーブルをソート
- **ソート順**：昇順/降順のトグル
- **対象列**：Data Port、Last Heartbeat、All Slots、Free Slots、Assigned Tasks、CPU Cores、Physical MEM、JVM Heap Size、Flink Managed MEM

### 3-自動リフレッシュ

- **イベント種別**：StatusService.refresh$のサブスクリプション
- **処理内容**：TaskManager一覧を定期的に再取得
- **更新タイミング**：StatusServiceのリフレッシュ間隔に従う

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・自動更新 | - | SELECT | REST API経由でTaskManager情報を取得（データベース直接アクセスなし） |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Loading | ローディングインジケータ表示 | データ取得中 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| API通信エラー | 空の配列を返し、一覧を空で表示（catchError(() => of([]))） |

## 備考

- テーブルのスクロールは固定高さ（calc(100vh - 260px)）で縦スクロール対応
- テーブル幅は1250pxで横スクロール対応
- ChangeDetectionStrategy.OnPushによる最適化が適用されている
- BlockedBadgeコンポーネントはTaskManagerがブロックされている場合のみ表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、TaskManager一覧で扱うデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | TaskManagersItem、Hardware、TaskManagerListインターフェースの定義を確認 |

**読解のコツ**: TypeScriptのインターフェース定義を読み、各プロパティの型と意味を把握する。特にhardwareプロパティのネスト構造に注意。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンポーネントを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task-manager-list.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/list/task-manager-list.component.ts` | コンポーネントのライフサイクル、DI、ngOnInitでのデータ取得フローを確認 |
| 2-2 | task-manager-list.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/list/task-manager-list.component.html` | nz-tableディレクティブの使用方法、列定義、ソート関数のバインディングを確認 |

**主要処理フロー**:
1. **行77-87**: ngOnInit()でStatusService.refresh$をサブスクライブし、TaskManagerServiceを通じてデータ取得
2. **行33-56**: ソート関数の定義（createSortFn、各列のソート関数）
3. **行63-67**: navigateTo()メソッドで詳細画面への遷移を実装

#### Step 3: サービス層を理解する

データ取得のためのサービスクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | loadManagers()メソッドのAPI呼び出しとレスポンス処理を確認 |

**主要処理フロー**:
- **行44-49**: loadManagers()がGET /taskmanagersを呼び出し、TaskManagersItem[]を返却

### プログラム呼び出し階層図

```
TaskManagerListComponent
    │
    ├─ ngOnInit()
    │      ├─ StatusService.refresh$（定期更新トリガー）
    │      └─ TaskManagerService.loadManagers()
    │             └─ HttpClient.get<TaskManagerList>('/taskmanagers')
    │
    └─ navigateTo(taskManager)
           └─ Router.navigate([id, 'metrics'])
```

### データフロー図

```
[入力]               [処理]                    [出力]

定期リフレッシュ    TaskManagerService       nz-table
トリガー        →   .loadManagers()      →   表示更新
                          │
                          ▼
                    /taskmanagers API
                    (REST API呼び出し)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task-manager-list.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/list/task-manager-list.component.ts` | ソース | メインコンポーネント |
| task-manager-list.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/list/task-manager-list.component.html` | テンプレート | 一覧テーブルのHTML |
| task-manager-list.component.less | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/list/task-manager-list.component.less` | スタイル | スタイル定義 |
| task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | ソース | API通信サービス |
| task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | ソース | データ型定義 |
| humanize-bytes.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-bytes.pipe.ts` | ソース | バイト数の人間可読形式変換 |
| blocked-badge.component.ts | `flink-runtime-web/web-dashboard/src/app/components/blocked-badge/blocked-badge.component.ts` | ソース | ブロック状態バッジ |
