# 画面設計書 32-TaskManager詳細

## 概要

本ドキュメントは、Apache Flink Web DashboardのTaskManager詳細画面の設計仕様を定義する。この画面は選択されたTaskManagerの詳細情報を表示するコンテナ画面であり、ステータス表示とナビゲーションタブを提供し、各サブ画面（メトリクス、ログ、スレッドダンプ等）への遷移制御を行う。

### 本画面の処理概要

**業務上の目的・背景**：クラスター運用者がTaskManager一覧から特定のTaskManagerを選択した際に、そのTaskManagerの詳細情報を閲覧・分析するための中心となる画面である。この画面はコンテナとして機能し、TaskManagerの基本情報（ID、パス、スロット、ハートビート、リソース）を常に表示しながら、タブナビゲーションで各種詳細情報（メトリクス、ログ、スレッドダンプ、プロファイラ）へのアクセスを提供する。問題発生時のトラブルシューティングにおいて、TaskManagerの状態を多角的に分析するための起点となる。

**画面へのアクセス方法**：TaskManager一覧画面で任意のTaskManagerをクリックするとアクセスできる。URLは `/task-manager/:taskManagerId` である。デフォルトではメトリクスタブ（`/task-manager/:taskManagerId/metrics`）にリダイレクトされる。

**主要な操作・処理内容**：
1. 選択されたTaskManagerの基本情報の表示（ID、パス、スロット、ハートビート、リソース情報）
2. タブナビゲーションによる各サブ画面への切り替え（Metrics、Logs、Stdout、Log List、Thread Dump、Profiler）
3. StatusServiceのrefresh$による定期的な情報更新
4. ブロック状態のバッジ表示（TaskManagerがブロックされている場合）

**画面遷移**：
- 遷移元：TaskManager一覧画面
- 遷移先：Metrics（メトリクス）、Logs（ログ）、Stdout（標準出力）、Log List（ログ一覧）、Thread Dump（スレッドダンプ）、Profiler（プロファイラ）の各サブ画面

**権限による表示制御**：本画面には権限による表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | TaskManager詳細情報の取得（/taskmanagers/{taskmanagerid} API） |
| 24 | タスク実行 | 補助機能 | 各サブ画面（メトリクス、ログ等）への遷移制御 |

## 画面種別

詳細画面（コンテナ）

## URL/ルーティング

`/task-manager/:taskManagerId`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| taskManagerId | パスパラメータ（入力） | string | 必須 | TaskManagerの一意識別子 |

## 表示項目

### ステータスセクション（task-manager-status.component）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ID | string | TaskManagerのID（タイトルとして表示） |
| Blocked Badge | boolean | ブロック状態バッジ（blocked=trueの場合のみ） |
| Path | string | TaskManagerのパス（ホスト名:ポート） |
| Free/All Slots | string | 空きスロット数 / 全スロット数 |
| Assigned Tasks | number | 割り当てられたタスク数 |
| Last Heartbeat | Date | 最後のハートビート受信時刻（yyyy-MM-dd HH:mm:ss形式） |
| Data Port | number | データ通信用ポート番号 |
| CPU Cores | number | CPUコア数 |
| Physical Memory | bytes | 物理メモリ（humanizeBytes形式） |
| JVM Heap Size | bytes | JVMヒープサイズ（humanizeBytes形式） |
| Flink Managed Memory | bytes | Flink管理メモリ（humanizeBytes形式） |

### ナビゲーションタブ

| タブ名 | パス | 説明 |
|--------|------|------|
| Metrics | metrics | メトリクス情報 |
| Logs | logs | ログ表示 |
| Stdout | stdout | 標準出力 |
| Log List | log-list | ログファイル一覧 |
| Thread Dump | thread-dump | スレッドダンプ |
| Profiler | profiler | プロファイラ |

## イベント仕様

### 1-タブクリック

- **イベント種別**：クリック
- **処理内容**：選択したタブに対応するサブ画面を表示
- **遷移先**：`/task-manager/:taskManagerId/:tabPath`

### 2-自動リフレッシュ

- **イベント種別**：StatusService.refresh$のサブスクリプション
- **処理内容**：TaskManager詳細情報を定期的に再取得
- **更新タイミング**：StatusServiceのリフレッシュ間隔に従う

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・自動更新 | - | SELECT | REST API経由でTaskManager詳細情報を取得 |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Loading | スケルトンローディング表示 | データ取得中（loading=true） |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| API通信エラー | undefinedを返し、画面は読み込み中状態のまま（catchError(() => of(undefined))） |

## 備考

- TaskManagerComponent自体は薄いコンテナで、主要なロジックはTaskManagerStatusComponentが担当
- ChangeDetectionStrategy.OnPushによる最適化が適用
- RouterOutletで各サブ画面を動的に表示
- スケルトンローディングで読み込み中の表示を実現

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | TaskManagerDetail、Hardware、Metrics、MemoryConfigurationインターフェースを確認 |

**読解のコツ**: TaskManagerDetailは一覧用のTaskManagersItemよりも詳細な情報（metrics、memoryConfiguration、allocatedSlots等）を持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task-manager.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/task-manager.component.ts` | コンテナコンポーネントの構造、TaskManagerStatusComponentとRouterOutletの配置 |
| 2-2 | task-manager.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/task-manager.component.html` | ステータスコンポーネントとルーターアウトレットの構成 |

**主要処理フロー**:
1. **行19**: TaskManagerStatusComponentでステータス情報を表示
2. **行20-22**: RouterOutletで子ルートのサブ画面を表示

#### Step 3: ステータスコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | task-manager-status.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/status/task-manager-status.component.ts` | ナビゲーションリスト定義、データ取得フロー |
| 3-2 | task-manager-status.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/status/task-manager-status.component.html` | 表示項目のレイアウト、NavigationComponentの使用 |

**主要処理フロー**:
- **行49-56**: listOfNavigationでタブナビゲーションを定義
- **行69-83**: ngOnInit()でStatusService.refresh$をサブスクライブし、TaskManagerService.loadManager()を呼び出し

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | loadManager()メソッド（51-54行目） |

### プログラム呼び出し階層図

```
TaskManagerComponent
    │
    ├─ TaskManagerStatusComponent
    │      ├─ ngOnInit()
    │      │      ├─ StatusService.refresh$
    │      │      └─ TaskManagerService.loadManager(taskManagerId)
    │      │             └─ HttpClient.get('/taskmanagers/{id}')
    │      │
    │      └─ NavigationComponent
    │             └─ listOfNavigation（タブ定義）
    │
    └─ RouterOutlet（サブ画面表示領域）
           ├─ TaskManagerMetricsComponent
           ├─ TaskManagerLogsComponent
           ├─ TaskManagerStdoutComponent
           ├─ TaskManagerLogListComponent
           ├─ TaskManagerThreadDumpComponent
           └─ TaskManagerProfilerComponent
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ        TaskManagerService       ステータス表示
(taskManagerId)  →   .loadManager()       →   + タブナビ
                          │
                          ▼
                    /taskmanagers/{id} API
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task-manager.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/task-manager.component.ts` | ソース | コンテナコンポーネント |
| task-manager.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/task-manager.component.html` | テンプレート | レイアウト定義 |
| task-manager-status.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/status/task-manager-status.component.ts` | ソース | ステータス表示・ナビゲーション |
| task-manager-status.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/status/task-manager-status.component.html` | テンプレート | ステータス表示HTML |
| task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | ソース | API通信サービス |
| task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | ソース | データ型定義 |
| navigation.component.ts | `flink-runtime-web/web-dashboard/src/app/components/navigation/navigation.component.ts` | ソース | タブナビゲーション |
