# 画面設計書 33-TaskManagerメトリクス

## 概要

本ドキュメントは、Apache Flink Web DashboardのTaskManagerメトリクス画面の設計仕様を定義する。この画面はTaskManagerのメモリ使用状況、JVMメトリクス、リソース配分、ガベージコレクション情報などを詳細に表示し、TaskManagerのパフォーマンス監視と問題診断を支援する。

### 本画面の処理概要

**業務上の目的・背景**：Apache Flinkの分散処理において、TaskManagerのメモリ管理は性能とスタビリティに直結する重要な要素である。運用者はヒープメモリ、マネージドメモリ、ネットワークメモリなどの使用状況をリアルタイムで監視し、メモリ不足やリソース競合の兆候を早期に検知する必要がある。本画面はFlinkのメモリモデル（Framework Heap、Task Heap、Managed Memory、Network等）に沿った詳細なメトリクス表示と、JVM固有の情報（Heap/Non-Heap、Direct/Mapped、GC）を統合的に提供し、パフォーマンスチューニングやトラブルシューティングに不可欠な情報を可視化する。

**画面へのアクセス方法**：TaskManager詳細画面のナビゲーションタブから「Metrics」を選択してアクセスする。URLは `/task-manager/:taskManagerId/metrics` である。TaskManager一覧からクリックした場合のデフォルト遷移先でもある。

**主要な操作・処理内容**：
1. TaskManager詳細情報の取得と表示（メモリ設定、リソース情報）
2. メトリクスAPI経由でのリアルタイムメトリクス取得（JVM Heap、Managed Memory、Network Memory、Metaspace）
3. プログレスバーによるメモリ使用率の視覚化
4. StatusServiceのrefresh$による定期的な情報更新
5. 割り当てられたスロットの詳細表示

**画面遷移**：
- 遷移元：TaskManager詳細画面のナビゲーション、TaskManager一覧
- 遷移先：なし（同一画面での情報表示）

**権限による表示制御**：本画面には権限による表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | TaskManagerメトリクスの取得（/taskmanagers/{taskmanagerid}/metrics API） |
| 57 | メトリクスコア | 補助機能 | JVMメモリ、GC情報などのメトリクス表示 |

## 画面種別

詳細画面

## URL/ルーティング

`/task-manager/:taskManagerId/metrics`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| taskManagerId | パスパラメータ（入力） | string | 必須 | TaskManagerの一意識別子 |

## 表示項目

### Memory カード（Flink Memory Model）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Framework Heap | bytes | フレームワークヒープメモリ設定値 |
| Task Heap | bytes | タスクヒープメモリ設定値 |
| Managed Memory | bytes | マネージドメモリ設定値 + 使用状況プログレスバー |
| Framework Off-Heap | bytes | フレームワークオフヒープメモリ設定値 |
| Task Off-Heap | bytes | タスクオフヒープメモリ設定値 |
| Network | bytes | ネットワークメモリ設定値 + 使用状況プログレスバー |
| JVM Metaspace | bytes | JVM Metaspace設定値 + 使用状況プログレスバー |
| JVM Overhead | bytes | JVMオーバーヘッド設定値 |
| Heap Used/Max (メトリクス) | bytes | JVMヒープ使用量/最大値 + プログレスバー |

### Advanced カード - JVM Memory

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Heap Committed | bytes | ヒープコミット済みメモリ |
| Heap Used | bytes | ヒープ使用量 |
| Heap Max | bytes | ヒープ最大値 |
| Non-Heap Committed | bytes | 非ヒープコミット済みメモリ |
| Non-Heap Used | bytes | 非ヒープ使用量 |
| Non-Heap Max | bytes | 非ヒープ最大値 |

### Advanced カード - Outside JVM Memory

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Direct Count | number | ダイレクトバッファ数 |
| Direct Used | bytes | ダイレクトバッファ使用量 |
| Direct Max | bytes | ダイレクトバッファ最大容量 |
| Mapped Count | number | マップドバッファ数 |
| Mapped Used | bytes | マップドバッファ使用量 |
| Mapped Max | bytes | マップドバッファ最大容量 |

### Advanced カード - Netty Shuffle Buffers

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Available | number | 利用可能なメモリセグメント数 |
| Total | number | 総メモリセグメント数 |

### Advanced カード - Garbage Collection

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Collector | string | GCコレクター名 |
| Count | number | GC実行回数 |
| Time | number | GC実行時間（ミリ秒） |

### Resources カード - Unassigned resources

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| CPU | number | 未割当CPU（cores） |
| Task Heap memory | number | 未割当タスクヒープメモリ（MB） |
| Task Off-Heap memory | number | 未割当タスクオフヒープメモリ（MB） |
| Managed memory | number | 未割当マネージドメモリ（MB） |
| Network memory | number | 未割当ネットワークメモリ（MB） |

### Resources カード - Allocated slots

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| # | number | スロット番号 |
| Job ID | string | ジョブID |
| Assigned Tasks | number | 割り当てられたタスク数 |
| CPU (cores) | number | CPUコア数 |
| Task Heap memory (MB) | number | タスクヒープメモリ（MB） |
| Task Off-Heap memory (MB) | number | タスクオフヒープメモリ（MB） |
| Managed memory (MB) | number | マネージドメモリ（MB） |
| Network memory (MB) | number | ネットワークメモリ（MB） |

## イベント仕様

### 1-自動リフレッシュ

- **イベント種別**：StatusService.refresh$のサブスクリプション
- **処理内容**：TaskManager詳細情報とメトリクスを定期的に再取得
- **更新タイミング**：StatusServiceのリフレッシュ間隔に従う

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・自動更新 | - | SELECT | REST API経由でメトリクスを取得 |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Tooltip | "The maximum heap displayed might differ from the configured values depending on the used GC algorithm for this process." | Heapメトリクスのインフォアイコンホバー時 |
| - | Tooltip | "Metrics related to this configuration parameter cannot be monitored. Flink does not have full control over these memory pools." | Framework/Task Off-Heap, JVM Overheadのインフォアイコンホバー時 |
| - | Tooltip | "This column shows the values that are actually used by Flink. These may differ from the configured values..." | Effective Configurationヘッダーのインフォアイコンホバー時 |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| TaskManager詳細API通信エラー | undefinedを返し、画面は更新されない |
| メトリクスAPI通信エラー | 空のメトリクスオブジェクトを返す（catchError(() => of({} as MetricMap))） |

## 備考

- メトリクスはloadMetrics()メソッドで特定のメトリクス名を指定して取得
- 取得するメトリクス：Status.JVM.Memory.Heap.Used/Max、Status.Shuffle.Netty.UsedMemory/TotalMemory、Status.Flink.Memory.Managed.Used/Total、Status.JVM.Memory.Metaspace.Used/Max
- プログレスバーはnz-progressコンポーネントを使用
- メモリ値はhumanizeBytesPipeで人間可読形式に変換

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | TaskManagerDetail、Metrics、MemoryConfiguration、Resources、AllocatedSlotインターフェースを確認 |

**読解のコツ**: memoryConfigurationとmetricsは別々のデータソース。memoryConfigurationは設定値、metricsはリアルタイム値。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task-manager-metrics.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/metrics/task-manager-metrics.component.ts` | ngOnInit()でのデータ取得フロー、reload()でのメトリクス取得 |
| 2-2 | task-manager-metrics.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/metrics/task-manager-metrics.component.html` | Memory/Advanced/Resourcesカードの構造、プログレスバー表示ロジック |

**主要処理フロー**:
1. **行67-81**: ngOnInit()でStatusService.refresh$をサブスクライブ、loadManager()でTaskManager詳細取得
2. **行77-78**: データ取得成功時にreload(id)を呼び出し
3. **行89-109**: reload()でloadMetrics()を呼び出し、8種類のメトリクスを取得

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | loadManager()（51-54行目）、loadMetrics()（101-116行目） |

**主要処理フロー**:
- **行101-116**: loadMetrics()がGET /taskmanagers/{id}/metricsを呼び出し、クエリパラメータでメトリクス名を指定

### プログラム呼び出し階層図

```
TaskManagerMetricsComponent
    │
    ├─ ngOnInit()
    │      ├─ StatusService.refresh$
    │      └─ TaskManagerService.loadManager(taskManagerId)
    │             └─ HttpClient.get('/taskmanagers/{id}')
    │
    └─ reload(id)
           └─ TaskManagerService.loadMetrics(id, metricNames)
                  └─ HttpClient.get('/taskmanagers/{id}/metrics?get=...')
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ        loadManager()            Memory カード
(taskManagerId)  →        │               →   (設定値表示)
                          ▼
                    loadMetrics()            Advanced カード
                          │               →   (JVM情報)
                          ▼
                    /taskmanagers/{id}/      Resources カード
                    metrics API           →   (リソース配分)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task-manager-metrics.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/metrics/task-manager-metrics.component.ts` | ソース | メインコンポーネント |
| task-manager-metrics.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/metrics/task-manager-metrics.component.html` | テンプレート | メモリモデル表示HTML |
| task-manager-metrics.component.less | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/metrics/task-manager-metrics.component.less` | スタイル | スタイル定義 |
| task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | ソース | API通信サービス |
| task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | ソース | データ型定義 |
| humanize-bytes.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-bytes.pipe.ts` | ソース | バイト数変換 |
