# 画面設計書 34-TaskManagerログ一覧

## 概要

本ドキュメントは、Apache Flink Web DashboardのTaskManagerログ一覧画面の設計仕様を定義する。この画面はTaskManagerが出力したログファイルの一覧を表示し、各ログファイルの詳細画面への遷移を提供する。

### 本画面の処理概要

**業務上の目的・背景**：TaskManagerは運用中に複数のログファイル（アプリケーションログ、GCログ、ローテーションされた過去ログ等）を生成する。運用者やエンジニアは、問題発生時に適切なログファイルを素早く特定し、内容を確認する必要がある。本画面は、TaskManagerが保持するすべてのログファイルを一覧表示し、ファイル名、更新日時、サイズでソートすることで、目的のログファイルを効率的に見つけることを支援する。特に時系列での問題追跡や、ログローテーション後の過去ログ参照において重要な画面である。

**画面へのアクセス方法**：TaskManager詳細画面のナビゲーションタブから「Log List」を選択してアクセスする。URLは `/task-manager/:taskManagerId/log-list` である。

**主要な操作・処理内容**：
1. TaskManagerのログファイル一覧の取得と表示
2. 最終更新日時、ファイルサイズによるソート
3. ログファイル名のクリックによるログ詳細画面への遷移
4. バーチャルスクロールによる大量ログファイルの効率的表示

**画面遷移**：
- 遷移元：TaskManager詳細画面のナビゲーション
- 遷移先：TaskManagerログ詳細画面（`/task-manager/:taskManagerId/log-list/:logName`）

**権限による表示制御**：本画面には権限による表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | TaskManagerログファイル一覧の取得 |
| 24 | タスク実行 | 補助機能 | ログファイルの選択・詳細画面への遷移 |

## 画面種別

一覧画面

## URL/ルーティング

`/task-manager/:taskManagerId/log-list`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| taskManagerId | パスパラメータ（入力） | string | 必須 | TaskManagerの一意識別子 |

## 表示項目

| 項目名 | データ型 | 説明 | ソート可否 |
|--------|----------|------|------------|
| Log Name | string | ログファイル名（リンクとして表示） | 不可 |
| Last Modified Time | Date | 最終更新日時（yyyy-MM-dd HH:mm:ss.SSS形式） | 可 |
| Size (KB) | number | ファイルサイズ（KB単位、小数点2桁） | 可 |

## イベント仕様

### 1-ログファイル名クリック

- **イベント種別**：クリック
- **処理内容**：選択したログファイルの詳細画面へ遷移
- **遷移先**：`/task-manager/:taskManagerId/log-list/:logName`
- **パラメータ引き継ぎ**：クエリパラメータを保持（queryParamsHandling: 'preserve'）

### 2-列ヘッダークリック（ソート）

- **イベント種別**：クリック
- **処理内容**：クリックした列でテーブルをソート
- **ソート順**：昇順/降順のトグル
- **対象列**：Last Modified Time、Size

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | REST API経由でログファイル一覧を取得 |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Loading | テーブルローディング表示 | データ取得中（isLoading=true） |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| API通信エラー | 空の配列を返し、一覧を空で表示（catchError(() => of([]))） |

## 備考

- バーチャルスクロール対応（nzVirtualItemSize=36、nzVirtualMinBufferPx=480、nzVirtualMaxBufferPx=480）
- テーブル高さは `calc(100% - 36px)` で縦スクロール対応
- logRouterFactoryでルーティングパスを動的生成（モジュール設定に依存）
- ChangeDetectionStrategy.OnPushによる最適化が適用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | TaskManagerLogItemインターフェース（name、size、mtime）を確認 |

**読解のコツ**: mtimeはミリ秒単位のタイムスタンプ。humanizeDatePipeで表示形式に変換される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task-manager-log-list.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-list/task-manager-log-list.component.ts` | ngOnInit()でのログ一覧取得、ソート関数定義、logRouterFactory |
| 2-2 | task-manager-log-list.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-list/task-manager-log-list.component.html` | バーチャルスクロールテーブル、routerLink構成 |

**主要処理フロー**:
1. **行62-63**: logRouterFactoryをモジュール設定から取得
2. **行66-78**: ngOnInit()でloadLogList()を呼び出し
3. **行46-48**: ソート関数（sortLastModifiedTimeFn、sortSizeFn）の定義

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | loadLogList()メソッド（57-61行目） |

**主要処理フロー**:
- **行57-61**: loadLogList()がGET /taskmanagers/{id}/logsを呼び出し、logs配列を返却

### プログラム呼び出し階層図

```
TaskManagerLogListComponent
    │
    ├─ ngOnInit()
    │      └─ TaskManagerService.loadLogList(taskManagerId)
    │             └─ HttpClient.get('/taskmanagers/{id}/logs')
    │
    └─ ログファイル名クリック
           └─ Router.navigate([logRouterFactory(logName)])
                  └─ /task-manager/:id/log-list/:logName
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ        loadLogList()            nz-table
(taskManagerId)  →        │               →   (バーチャルスクロール)
                          ▼
                    /taskmanagers/{id}/
                    logs API
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task-manager-log-list.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-list/task-manager-log-list.component.ts` | ソース | メインコンポーネント |
| task-manager-log-list.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-list/task-manager-log-list.component.html` | テンプレート | ログ一覧テーブルHTML |
| task-manager-log-list.component.less | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-list/task-manager-log-list.component.less` | スタイル | スタイル定義 |
| task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | ソース | API通信サービス |
| task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | ソース | TaskManagerLogItem型定義 |
| task-manager.config.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/task-manager.config.ts` | 設定 | モジュール設定（logRouterFactory） |
| humanize-date.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-date.pipe.ts` | ソース | 日時フォーマット変換 |
