# 画面設計書 35-TaskManagerログ詳細

## 概要

本ドキュメントは、Apache Flink Web DashboardのTaskManagerログ詳細画面の設計仕様を定義する。この画面は選択されたログファイルの内容をコードエディタ形式で表示し、ダウンロード機能、リロード機能、フルスクリーン表示機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：TaskManagerのトラブルシューティングにおいて、ログファイルの内容確認は最も基本的かつ重要な作業である。運用者やエンジニアは、エラーメッセージ、スタックトレース、処理ログなどを詳細に分析して問題の原因を特定する。本画面は、Web UI上でログファイルを直接閲覧できるようにすることで、サーバーへの直接接続なしに迅速なログ分析を可能にする。Monaco Editorベースのコードエディタにより、シンタックスハイライトや検索機能を活用した効率的なログ分析が可能。

**画面へのアクセス方法**：TaskManagerログ一覧画面でログファイル名をクリックしてアクセスする。URLは `/task-manager/:taskManagerId/log-list/:logName` である。

**主要な操作・処理内容**：
1. 指定されたログファイルの内容取得と表示
2. リロードボタンによるログ内容の再取得
3. ダウンロードボタンによるログファイルのダウンロード
4. フルスクリーン表示の切り替え
5. パンくずリストによるログ一覧への戻り

**画面遷移**：
- 遷移元：TaskManagerログ一覧画面
- 遷移先：TaskManagerログ一覧画面（パンくずリストから）

**権限による表示制御**：本画面には権限による表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | 選択したログファイル内容の取得 |
| 24 | タスク実行 | 補助機能 | ログ内容の詳細表示 |

## 画面種別

詳細画面

## URL/ルーティング

`/task-manager/:taskManagerId/log-list/:logName`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| taskManagerId | パスパラメータ（入力） | string | 必須 | TaskManagerの一意識別子 |
| logName | パスパラメータ（入力） | string | 必須 | ログファイル名 |

## 表示項目

### パンくずリスト

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Log List リンク | link | ログ一覧への戻りリンク |
| logName | string | 現在表示中のログファイル名 |

### ツールバー（AddonInlineComponent）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Loading | boolean | ローディング状態 |
| Download | button | ログファイルダウンロードボタン |
| Reload | button | ログ再読み込みボタン |
| Full Screen | button | フルスクリーン切り替えボタン |

### エディタ領域

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| logs | string | ログファイルの内容（読み取り専用） |

## イベント仕様

### 1-Log Listリンククリック

- **イベント種別**：クリック
- **処理内容**：ログ一覧画面へ遷移
- **遷移先**：`/task-manager/:taskManagerId/log-list`

### 2-Reloadボタンクリック

- **イベント種別**：クリック
- **処理内容**：ログファイル内容を再取得して表示を更新
- **メソッド**：reloadLog()

### 3-Downloadボタンクリック

- **イベント種別**：クリック
- **処理内容**：ログファイルをダウンロード
- **ダウンロードURL**：downloadUrl（API URLと同一）
- **ファイル名**：logName

### 4-Full Screenボタンクリック

- **イベント種別**：クリック
- **処理内容**：フルスクリーンモードの切り替え
- **メソッド**：toggleFullScreen(fullScreen: boolean)

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・リロード | - | SELECT | REST API経由でログ内容を取得 |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Loading | エディタローディング表示 | データ取得中（isLoading=true） |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| API通信エラー | エラーがスローされ、ログ内容は更新されない |

## 備考

- Monaco Editor（nz-code-editor）を使用してログ内容を表示
- エディタオプションはモジュール設定（TASK_MANAGER_MODULE_CONFIG）から取得
- AutoResizeDirectiveにより、エディタは親コンテナに自動リサイズ
- フルスクリーンモードはホストバインディング（[class.full-screen]）で制御
- Cache-Control: no-cacheヘッダーでキャッシュを無効化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | TaskManagerLogDetailインターフェース（data、url）を確認 |

**読解のコツ**: loadLog()の戻り値はログ内容（data）とダウンロードURL（url）の両方を含むオブジェクト。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task-manager-log-detail.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-detail/task-manager-log-detail.component.ts` | ngOnInit()でのパラメータ取得、reloadLog()、toggleFullScreen() |
| 2-2 | task-manager-log-detail.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-detail/task-manager-log-detail.component.html` | パンくずリスト、AddonInlineComponent、nz-code-editorの構成 |

**主要処理フロー**:
1. **行73-76**: ngOnInit()でパスパラメータ（logName、taskManagerId）を取得
2. **行84-95**: reloadLog()でログ内容を取得し、logs、downloadUrlを更新
3. **行98-101**: toggleFullScreen()でフルスクリーンモード切り替え

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | loadLog()メソッド（63-75行目） |

**主要処理フロー**:
- **行63-75**: loadLog()がGET /taskmanagers/{id}/logs/{logName}を呼び出し、テキストレスポンスとURLを返却

### プログラム呼び出し階層図

```
TaskManagerLogDetailComponent
    │
    ├─ ngOnInit()
    │      ├─ activatedRoute.snapshot.params.logName
    │      ├─ activatedRoute.parent.snapshot.params.taskManagerId
    │      └─ reloadLog()
    │
    ├─ reloadLog()
    │      └─ TaskManagerService.loadLog(taskManagerId, logName)
    │             └─ HttpClient.get('/taskmanagers/{id}/logs/{logName}')
    │
    └─ toggleFullScreen(fullScreen)
           └─ isFullScreen = fullScreen
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ        loadLog()               nz-code-editor
(taskManagerId,  →        │               →   (Monaco Editor)
 logName)                 ▼
                    /taskmanagers/{id}/
                    logs/{logName} API
                    (Cache-Control: no-cache)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task-manager-log-detail.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-detail/task-manager-log-detail.component.ts` | ソース | メインコンポーネント |
| task-manager-log-detail.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-detail/task-manager-log-detail.component.html` | テンプレート | レイアウトHTML |
| task-manager-log-detail.component.less | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-detail/task-manager-log-detail.component.less` | スタイル | スタイル定義 |
| task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | ソース | API通信サービス |
| task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | ソース | TaskManagerLogDetail型定義 |
| addon-inline.component.ts | `flink-runtime-web/web-dashboard/src/app/components/addon-inline/addon-inline.component.ts` | ソース | ツールバーコンポーネント |
| auto-resize.directive.ts | `flink-runtime-web/web-dashboard/src/app/components/editor/auto-resize.directive.ts` | ソース | エディタ自動リサイズ |
