# 画面設計書 36-TaskManagerスレッドダンプ

## 概要

本ドキュメントは、Apache Flink Web DashboardのTaskManagerスレッドダンプ画面の設計仕様を定義する。この画面はTaskManagerのJVMスレッドダンプを取得・表示し、スレッドの状態分析、デッドロック検出、パフォーマンスボトルネック調査を支援する。

### 本画面の処理概要

**業務上の目的・背景**：分散処理システムにおいて、TaskManagerのスレッド状態を把握することは、パフォーマンス問題やハング状態の診断に不可欠である。スレッドダンプは、各スレッドの現在の実行状態、スタックトレース、ロック保持状況を提供し、デッドロック、スレッド飢餓、CPUバウンドな処理の特定に役立つ。本画面は、JVMのスレッドダンプをWeb UI上で直接取得・表示することで、サーバーへの直接アクセスなしに迅速なスレッド分析を可能にする。特に、特定の頂点（Vertex）に関連するスレッドを自動検索・ハイライトする機能により、ジョブ実行中の問題特定を効率化する。

**画面へのアクセス方法**：TaskManager詳細画面のナビゲーションタブから「Thread Dump」を選択してアクセスする。URLは `/task-manager/:taskManagerId/thread-dump` である。また、ジョブ詳細画面のサブタスクからクエリパラメータ付きでアクセスすると、該当する頂点のスレッドを自動検索する。

**主要な操作・処理内容**：
1. スレッドダンプの取得と表示
2. リロードボタンによるスレッドダンプの再取得
3. ダウンロードボタンによるスレッドダンプのダウンロード
4. クエリパラメータ（vertexName）に基づくスレッド自動検索・ハイライト
5. エディタ内での検索機能

**画面遷移**：
- 遷移元：TaskManager詳細画面のナビゲーション、ジョブ詳細画面のサブタスク
- 遷移先：なし

**権限による表示制御**：本画面には権限による表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | スレッドダンプの取得（/taskmanagers/{taskmanagerid}/thread-dump API） |
| 24 | タスク実行 | 補助機能 | スレッド情報のテキスト表示 |

## 画面種別

詳細画面

## URL/ルーティング

`/task-manager/:taskManagerId/thread-dump`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| taskManagerId | パスパラメータ（入力） | string | 必須 | TaskManagerの一意識別子 |
| vertexName | クエリパラメータ（入力） | string | 任意 | 検索対象の頂点名（URLエンコード済み） |

## 表示項目

### ツールバー（AddonCompactComponent）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Download | button | スレッドダンプダウンロードボタン |
| Reload | button | スレッドダンプ再取得ボタン |

### エディタ領域

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| dump | string | スレッドダンプの内容（読み取り専用） |

## イベント仕様

### 1-Reloadボタンクリック

- **イベント種別**：クリック
- **処理内容**：スレッドダンプを再取得して表示を更新
- **メソッド**：reload()

### 2-Downloadボタンクリック

- **イベント種別**：クリック
- **処理内容**：スレッドダンプをダウンロード
- **ダウンロードURL**：`${BASE_URL}/taskmanagers/${taskManagerId}/thread-dump`
- **ファイル名**：`taskmanager_${taskManagerId}_thread_dump`

### 3-エディタ初期化完了

- **イベント種別**：nzEditorInitialized
- **処理内容**：
  1. vertexNameクエリパラメータがある場合、エディタ内で該当スレッドを検索
  2. "Legacy Source Thread - " プレフィックスも考慮して検索
  3. マッチした場合、該当行を選択して検索ダイアログを表示
  4. 検索完了後、スレッドダンプを取得

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・リロード | - | SELECT | REST API経由でスレッドダンプを取得 |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Loading | エディタローディング表示 | データ取得中（loading=true） |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| API通信エラー | 空文字列を返し、エディタは空で表示（catchError(() => of(''))） |

## 備考

- Monaco Editor（nz-code-editor）を使用してスレッドダンプを表示
- エディタ初期化後にスレッドダンプを取得（エディタのモデル変更イベントを利用）
- vertexName検索では、通常のスレッド名と "Legacy Source Thread - " プレフィックス付きの両方を検索
- model.findMatches()でテキスト検索、editor.getAction()で検索アクションを実行
- ChangeDetectionStrategy.OnPushによる最適化が適用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | TaskManagerThreadDump、TaskManagerThreadInfoインターフェースを確認 |

**読解のコツ**: スレッドダンプはthreadInfos配列を含み、各要素のstringifiedThreadInfoを連結して表示テキストを生成。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task-manager-thread-dump.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/thread-dump/task-manager-thread-dump.component.ts` | ngOnInit()、nzEditorInitialized()、reload()のフロー |
| 2-2 | task-manager-thread-dump.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/thread-dump/task-manager-thread-dump.component.html` | nz-code-editor、AddonCompactComponentの構成 |

**主要処理フロー**:
1. **行67-73**: ngOnInit()でパラメータ取得、ダウンロードURL/ファイル名設定、vertexNameクエリパラメータ取得
2. **行81-99**: nzEditorInitialized()でエディタ初期化後のスレッド検索ロジック
3. **行101-114**: reload()でスレッドダンプを取得

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | loadThreadDump()メソッド（77-85行目） |

**主要処理フロー**:
- **行77-85**: loadThreadDump()がGET /taskmanagers/{id}/thread-dumpを呼び出し、threadInfosを連結した文字列を返却

### プログラム呼び出し階層図

```
TaskManagerThreadDumpComponent
    │
    ├─ ngOnInit()
    │      ├─ activatedRoute.parent.snapshot.params.taskManagerId
    │      ├─ downloadUrl/downloadName設定
    │      └─ activatedRoute.queryParams.subscribe()
    │             └─ vertexName取得
    │
    ├─ nzEditorInitialized(editor)
    │      ├─ editor.onDidChangeModelContent()
    │      │      └─ model.findMatches(vertexName)
    │      │             └─ editor.setSelection() / actions.find
    │      └─ reload()
    │
    └─ reload()
           └─ TaskManagerService.loadThreadDump(taskManagerId)
                  └─ HttpClient.get('/taskmanagers/{id}/thread-dump')
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ        loadThreadDump()         nz-code-editor
(taskManagerId)  →        │               →   (Monaco Editor)
      +                   ▼
vertexName        /taskmanagers/{id}/
(optional)        thread-dump API
                          │
                          ▼
                  threadInfos.map().join('')
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task-manager-thread-dump.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/thread-dump/task-manager-thread-dump.component.ts` | ソース | メインコンポーネント |
| task-manager-thread-dump.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/thread-dump/task-manager-thread-dump.component.html` | テンプレート | レイアウトHTML |
| task-manager-thread-dump.component.less | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/thread-dump/task-manager-thread-dump.component.less` | スタイル | スタイル定義 |
| task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | ソース | API通信サービス |
| task-manager.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts` | ソース | TaskManagerThreadDump型定義 |
| addon-compact.component.ts | `flink-runtime-web/web-dashboard/src/app/components/addon-compact/addon-compact.component.ts` | ソース | ツールバーコンポーネント |
| auto-resize.directive.ts | `flink-runtime-web/web-dashboard/src/app/components/editor/auto-resize.directive.ts` | ソース | エディタ自動リサイズ |
