# 画面設計書 38-TaskManagerログ

## 概要

本ドキュメントは、Apache Flink Web DashboardのTaskManagerログ画面の設計仕様を定義する。この画面はTaskManagerのメインログファイル（log）の内容をリアルタイムで表示し、ダウンロード機能とリロード機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：TaskManagerのログファイルは、ジョブ実行中の処理状況、エラー、警告などの重要な情報を含んでいる。運用者やエンジニアは、問題発生時にログを素早く確認して状況を把握し、適切な対応を行う必要がある。本画面は、TaskManagerのメインログファイルをWeb UI上で直接閲覧できるようにし、サーバーへの直接アクセスなしに迅速なログ確認を可能にする。ログ一覧画面が複数のログファイルを扱うのに対し、本画面はメインログファイルに特化した簡易アクセスを提供する。

**画面へのアクセス方法**：TaskManager詳細画面のナビゲーションタブから「Logs」を選択してアクセスする。URLは `/task-manager/:taskManagerId/logs` である。

**主要な操作・処理内容**：
1. TaskManagerのメインログファイル内容の取得と表示
2. リロードボタンによるログ内容の再取得
3. ダウンロードボタンによるログファイルのダウンロード

**画面遷移**：
- 遷移元：TaskManager詳細画面のナビゲーション
- 遷移先：なし

**権限による表示制御**：本画面には権限による表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | TaskManagerログの取得（/taskmanagers/{taskmanagerid}/log API） |
| 24 | タスク実行 | 補助機能 | ログ内容のテキスト表示 |

## 画面種別

詳細画面

## URL/ルーティング

`/task-manager/:taskManagerId/logs`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| taskManagerId | パスパラメータ（入力） | string | 必須 | TaskManagerの一意識別子 |

## 表示項目

### ツールバー（AddonCompactComponent）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Download | button | ログファイルダウンロードボタン |
| Reload | button | ログ再読み込みボタン |

### エディタ領域

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| logs | string | ログファイルの内容（読み取り専用） |

## イベント仕様

### 1-Reloadボタンクリック

- **イベント種別**：クリック
- **処理内容**：ログファイル内容を再取得して表示を更新
- **メソッド**：reload()

### 2-Downloadボタンクリック

- **イベント種別**：クリック
- **処理内容**：ログファイルをダウンロード
- **ダウンロードURL**：`${BASE_URL}/taskmanagers/${taskManagerId}/log`
- **ファイル名**：`taskmanager_${taskManagerId}_log`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・リロード | - | SELECT | REST API経由でログ内容を取得 |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Loading | エディタローディング表示 | データ取得中（loading=true） |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| API通信エラー | 空文字列を返し、エディタは空で表示（catchError(() => of(''))） |

## 備考

- Monaco Editor（nz-code-editor）を使用してログ内容を表示
- エディタオプションはモジュール設定（TASK_MANAGER_MODULE_CONFIG）から取得
- AutoResizeDirectiveにより、エディタは親コンテナに自動リサイズ
- Cache-Control: no-cacheヘッダーでキャッシュを無効化
- ChangeDetectionStrategy.OnPushによる最適化が適用
- ログ詳細画面（No.35）との違い：本画面はメインログファイル固定、詳細画面はログ一覧から選択

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | - | - | ログはテキスト（string）形式で取得されるため、特別なインターフェースは使用しない |

**読解のコツ**: loadLogs()はresponsType: 'text'でプレーンテキストを返す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task-manager-logs.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/logs/task-manager-logs.component.ts` | ngOnInit()でのパラメータ取得とURL設定、reload()メソッド |
| 2-2 | task-manager-logs.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/logs/task-manager-logs.component.html` | nz-code-editor、AddonCompactComponentの構成 |

**主要処理フロー**:
1. **行64-68**: ngOnInit()でパラメータ取得、ダウンロードURL/ファイル名設定
2. **行76-89**: reload()でログ内容を取得

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | loadLogs()メソッド（87-92行目） |

**主要処理フロー**:
- **行87-92**: loadLogs()がGET /taskmanagers/{id}/logを呼び出し、テキストレスポンスを返却

### プログラム呼び出し階層図

```
TaskManagerLogsComponent
    │
    ├─ ngOnInit()
    │      ├─ activatedRoute.parent.snapshot.params.taskManagerId
    │      ├─ downloadUrl/downloadName設定
    │      └─ reload()
    │
    └─ reload()
           └─ TaskManagerService.loadLogs(taskManagerId)
                  └─ HttpClient.get('/taskmanagers/{id}/log', {responseType: 'text'})
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ        loadLogs()              nz-code-editor
(taskManagerId)  →        │               →   (Monaco Editor)
                          ▼
                    /taskmanagers/{id}/
                    log API
                    (Cache-Control: no-cache)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task-manager-logs.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/logs/task-manager-logs.component.ts` | ソース | メインコンポーネント |
| task-manager-logs.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/logs/task-manager-logs.component.html` | テンプレート | レイアウトHTML |
| task-manager-logs.component.less | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/logs/task-manager-logs.component.less` | スタイル | スタイル定義 |
| task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | ソース | API通信サービス |
| addon-compact.component.ts | `flink-runtime-web/web-dashboard/src/app/components/addon-compact/addon-compact.component.ts` | ソース | ツールバーコンポーネント |
| auto-resize.directive.ts | `flink-runtime-web/web-dashboard/src/app/components/editor/auto-resize.directive.ts` | ソース | エディタ自動リサイズ |
