# 画面設計書 39-TaskManager標準出力

## 概要

本ドキュメントは、Apache Flink Web DashboardのTaskManager標準出力画面の設計仕様を定義する。この画面はTaskManagerの標準出力（stdout）の内容をリアルタイムで表示し、ダウンロード機能とリロード機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：TaskManagerはジョブ実行中にSystem.out.println()などで標準出力にメッセージを出力することがある。これらの出力は、デバッグ情報、処理状況、ユーザー定義のログメッセージなどを含む場合がある。運用者やエンジニアは、標準出力を確認することで、ログには出力されない追加情報を得ることができる。本画面は、TaskManagerの標準出力をWeb UI上で直接閲覧できるようにし、特にユーザーコードからの出力を確認するための手段を提供する。

**画面へのアクセス方法**：TaskManager詳細画面のナビゲーションタブから「Stdout」を選択してアクセスする。URLは `/task-manager/:taskManagerId/stdout` である。

**主要な操作・処理内容**：
1. TaskManagerの標準出力内容の取得と表示
2. リロードボタンによる標準出力内容の再取得
3. ダウンロードボタンによる標準出力ファイルのダウンロード

**画面遷移**：
- 遷移元：TaskManager詳細画面のナビゲーション
- 遷移先：なし

**権限による表示制御**：本画面には権限による表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | TaskManager標準出力の取得（/taskmanagers/{taskmanagerid}/stdout API） |
| 24 | タスク実行 | 補助機能 | 標準出力内容のテキスト表示 |

## 画面種別

詳細画面

## URL/ルーティング

`/task-manager/:taskManagerId/stdout`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| taskManagerId | パスパラメータ（入力） | string | 必須 | TaskManagerの一意識別子 |

## 表示項目

### ツールバー（AddonCompactComponent）

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Download | button | 標準出力ファイルダウンロードボタン |
| Reload | button | 標準出力再読み込みボタン |

### エディタ領域

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| stdout | string | 標準出力の内容（読み取り専用） |

## イベント仕様

### 1-Reloadボタンクリック

- **イベント種別**：クリック
- **処理内容**：標準出力内容を再取得して表示を更新
- **メソッド**：reload()

### 2-Downloadボタンクリック

- **イベント種別**：クリック
- **処理内容**：標準出力をダウンロード
- **ダウンロードURL**：`${BASE_URL}/taskmanagers/${taskManagerId}/stdout`
- **ファイル名**：`taskmanager_${taskManagerId}_stdout`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・リロード | - | SELECT | REST API経由で標準出力を取得 |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Loading | エディタローディング表示 | データ取得中（loading=true） |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| API通信エラー | 空文字列を返し、エディタは空で表示（catchError(() => of(''))） |

## 備考

- Monaco Editor（nz-code-editor）を使用して標準出力内容を表示
- エディタオプションはモジュール設定（TASK_MANAGER_MODULE_CONFIG）から取得
- AutoResizeDirectiveにより、エディタは親コンテナに自動リサイズ
- Cache-Control: no-cacheヘッダーでキャッシュを無効化
- ChangeDetectionStrategy.OnPushによる最適化が適用
- TaskManagerログ画面（No.38）と同様の構造だが、取得するエンドポイントが異なる（/log vs /stdout）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | - | - | 標準出力はテキスト（string）形式で取得されるため、特別なインターフェースは使用しない |

**読解のコツ**: loadStdout()はresponsType: 'text'でプレーンテキストを返す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | task-manager-stdout.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/stdout/task-manager-stdout.component.ts` | ngOnInit()でのパラメータ取得とURL設定、reload()メソッド |
| 2-2 | task-manager-stdout.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/stdout/task-manager-stdout.component.html` | nz-code-editor、AddonCompactComponentの構成 |

**主要処理フロー**:
1. **行62-66**: ngOnInit()でパラメータ取得、ダウンロードURL/ファイル名設定
2. **行74-88**: reload()で標準出力内容を取得

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | loadStdout()メソッド（94-99行目） |

**主要処理フロー**:
- **行94-99**: loadStdout()がGET /taskmanagers/{id}/stdoutを呼び出し、テキストレスポンスを返却

### プログラム呼び出し階層図

```
TaskManagerStdoutComponent
    │
    ├─ ngOnInit()
    │      ├─ activatedRoute.parent.snapshot.params.taskManagerId
    │      ├─ downloadUrl/downloadName設定
    │      └─ reload()
    │
    └─ reload()
           └─ TaskManagerService.loadStdout(taskManagerId)
                  └─ HttpClient.get('/taskmanagers/{id}/stdout', {responseType: 'text'})
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ        loadStdout()            nz-code-editor
(taskManagerId)  →        │               →   (Monaco Editor)
                          ▼
                    /taskmanagers/{id}/
                    stdout API
                    (Cache-Control: no-cache)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| task-manager-stdout.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/stdout/task-manager-stdout.component.ts` | ソース | メインコンポーネント |
| task-manager-stdout.component.html | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/stdout/task-manager-stdout.component.html` | テンプレート | レイアウトHTML |
| task-manager-stdout.component.less | `flink-runtime-web/web-dashboard/src/app/pages/task-manager/stdout/task-manager-stdout.component.less` | スタイル | スタイル定義 |
| task-manager.service.ts | `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts` | ソース | API通信サービス |
| addon-compact.component.ts | `flink-runtime-web/web-dashboard/src/app/components/addon-compact/addon-compact.component.ts` | ソース | ツールバーコンポーネント |
| auto-resize.directive.ts | `flink-runtime-web/web-dashboard/src/app/components/editor/auto-resize.directive.ts` | ソース | エディタ自動リサイズ |
