# 画面設計書 40-実行中アプリケーション一覧

## 概要

本ドキュメントは、Apache Flink Web Dashboardの実行中アプリケーション一覧画面の設計仕様を定義する。この画面は現在実行中のFlinkアプリケーションを一覧表示し、各アプリケーションの状態、ジョブ数、開始時刻などの情報を提供する。

### 本画面の処理概要

**業務上の目的・背景**：Apache Flinkでは、アプリケーションは複数のジョブを含む論理的な単位であり、アプリケーションモード（Application Mode）でのデプロイ時に使用される。運用者は、クラスター上で実行中のアプリケーションを把握し、その状態やジョブの実行状況を監視する必要がある。本画面は、実行中のアプリケーションを一覧形式で表示し、各アプリケーションの開始時刻、実行時間、含まれるジョブ数、ステータスを可視化する。これにより、クラスターの稼働状況を把握し、個別のアプリケーション詳細画面への迅速なアクセスを可能にする。

**画面へのアクセス方法**：グローバルナビゲーションから「Running Applications」を選択してアクセスする。URLは `/application/running` である。

**主要な操作・処理内容**：
1. 実行中アプリケーション一覧の取得と表示
2. StatusServiceのrefresh$による定期的な情報更新
3. 各列のソート機能によるアプリケーションの並び替え
4. アプリケーション行クリックによる詳細画面への遷移

**画面遷移**：
- 遷移元：オーバービュー画面、グローバルナビゲーション
- 遷移先：アプリケーション詳細画面（`/application/running/:applicationId`）

**権限による表示制御**：本画面には権限による表示制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | 実行中アプリケーション一覧の取得（/applications/overview API） |
| 23 | ジョブ管理 | 補助機能 | アプリケーションステータスのフィルタリングと表示 |

## 画面種別

一覧画面

## URL/ルーティング

`/application/running`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| - | - | - | - | 本画面に入力項目はなし |

## 表示項目

| 項目名 | データ型 | 説明 | ソート可否 |
|--------|----------|------|------------|
| Application Name | string | アプリケーション名 | 可 |
| Start Time | Date | アプリケーション開始時刻（yyyy-MM-dd HH:mm:ss.SSS形式） | 可（デフォルト降順） |
| Duration | number | 実行時間（humanizeDuration形式） | 可 |
| End Time | Date | 終了時刻（実行中は-表示） | 可 |
| Jobs | badge | 含まれるジョブの状態別カウント | 不可 |
| Status | badge | アプリケーションステータス | 可 |

## イベント仕様

### 1-アプリケーション行クリック

- **イベント種別**：クリック
- **処理内容**：選択したアプリケーションの詳細画面へ遷移
- **遷移先**：`/application/running/:applicationId`
- **メソッド**：navigateToApplication(application)

### 2-列ヘッダークリック（ソート）

- **イベント種別**：クリック
- **処理内容**：クリックした列でテーブルをソート
- **ソート順**：昇順/降順のトグル
- **対象列**：Application Name、Start Time、Duration、End Time、Status
- **デフォルト**：Start Time降順（最新のアプリケーションが上）

### 3-自動リフレッシュ

- **イベント種別**：StatusService.refresh$のサブスクリプション
- **処理内容**：アプリケーション一覧を定期的に再取得
- **更新タイミング**：StatusServiceのリフレッシュ間隔に従う

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・自動更新 | - | SELECT | REST API経由でアプリケーション一覧を取得 |

### テーブル別更新項目詳細

本画面はREST API経由でのデータ取得のみを行い、データベースの直接更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| - | Loading | テーブルローディング表示 | データ取得中（isLoading=true） |

## 例外処理

| 例外種別 | 処理内容 |
|---------|---------|
| API通信エラー | EMPTYを返し、ストリームが完了（catchError(() => EMPTY)） |

## 備考

- ApplicationListComponentが共通コンポーネントとして実装され、completed=falseで実行中アプリケーションを表示
- 完了済みアプリケーション一覧（No.41）と同じコンポーネントを使用し、completedフラグで表示内容を切り替え
- JobsBadgeコンポーネントでジョブ状態の内訳を表示
- ApplicationBadgeコンポーネントでステータスを色分け表示
- デフォルトソートは開始時刻の降順（最新のアプリケーションが上に表示）
- ChangeDetectionStrategy.OnPushによる最適化が適用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | interfaces/index.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/` | ApplicationItem、ApplicationOverview、JobStatusインターフェースを確認 |

**読解のコツ**: ApplicationItemにはid、name、status、start-time、end-time、duration、jobs、completedプロパティが含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.ts` | isCompletedフラグの管理、updateApplicationIdSelected()、navigateToApplication() |
| 2-2 | application-list.component.ts | `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.ts` | ngOnInit()でのデータ取得、フィルタリング、ソート処理 |
| 2-3 | application-list.component.html | `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.html` | テーブル構造、バッジコンポーネントの配置 |

**主要処理フロー**:
1. **application.component.ts 51-60**: ngOnInit()でURLからisCompletedを判定
2. **application-list.component.ts 88-109**: データ取得後、completedフラグでフィルタリングし、デフォルトソートを適用
3. **application-list.component.ts 78-80**: navigateToApplication()で詳細画面へ遷移

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | application.service.ts | `flink-runtime-web/web-dashboard/src/app/services/application.service.ts` | loadApplications()メソッド（44-59行目） |

**主要処理フロー**:
- **行44-59**: loadApplications()がGET /applications/overviewを呼び出し、ジョブ数の集計とcompletedフラグを設定

### プログラム呼び出し階層図

```
ApplicationComponent
    │
    ├─ ngOnInit()
    │      └─ updateApplicationIdSelected()
    │             └─ URLからisCompletedを判定
    │
    ├─ ApplicationListComponent (子コンポーネント)
    │      │
    │      ├─ ngOnInit()
    │      │      ├─ StatusService.refresh$
    │      │      └─ ApplicationService.loadApplications()
    │      │             └─ HttpClient.get('/applications/overview')
    │      │
    │      └─ navigateToApplication(application)
    │             └─ navigate.emit(application)
    │
    └─ navigateToApplication(application)
           └─ Router.navigate([application.id])
```

### データフロー図

```
[入力]               [処理]                    [出力]

定期リフレッシュ    ApplicationService       nz-table
トリガー        →   .loadApplications()  →   表示更新
                          │
                          ▼
                    /applications/overview API
                          │
                          ▼
                    completed=falseで
                    フィルタリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| application.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.ts` | ソース | 親コンポーネント |
| application.component.html | `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.html` | テンプレート | レイアウト |
| application-list.component.ts | `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.ts` | ソース | 一覧表示コンポーネント |
| application-list.component.html | `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.html` | テンプレート | テーブルHTML |
| application.service.ts | `flink-runtime-web/web-dashboard/src/app/services/application.service.ts` | ソース | API通信サービス |
| jobs-badge.component.ts | `flink-runtime-web/web-dashboard/src/app/components/jobs-badge/jobs-badge.component.ts` | ソース | ジョブステータスバッジ |
| application-badge.component.ts | `flink-runtime-web/web-dashboard/src/app/components/application-badge/application-badge.component.ts` | ソース | アプリケーションステータスバッジ |
| humanize-date.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-date.pipe.ts` | ソース | 日時フォーマット変換 |
| humanize-duration.pipe.ts | `flink-runtime-web/web-dashboard/src/app/components/humanize-duration.pipe.ts` | ソース | 実行時間フォーマット変換 |
