# 画面設計書 41-完了済みアプリケーション一覧

## 概要

本ドキュメントは、Apache Flink Web Dashboard における完了済みアプリケーション一覧画面の設計を定義する。

### 本画面の処理概要

この画面では、Flinkクラスターで実行が完了した（FINISHED/FAILED/CANCELED）アプリケーションの一覧を表示し、各アプリケーションの詳細画面へ遷移する機能を提供する。

**業務上の目的・背景**：ストリーミング処理やバッチ処理の運用において、完了済みアプリケーションの実行履歴を確認することは、障害調査、パフォーマンス分析、リソース使用量の把握などの運用業務に不可欠である。特にFAILEDステータスのアプリケーションを迅速に特定し、原因調査を開始するためのエントリーポイントとして機能する。

**画面へのアクセス方法**：サイドナビゲーションの「Completed Applications」メニューをクリックするか、URLで直接 `/application/completed` にアクセスする。また、オーバービュー画面からもリンクを通じてアクセス可能である。

**主要な操作・処理内容**：
1. 完了済みアプリケーション一覧のREST API経由での取得と表示
2. Application Name、Start Time、Duration、End Time、Status列でのソート操作
3. アプリケーション行クリックによる詳細画面への遷移
4. 終了時刻の降順（最新のものが上）でのデフォルトソート

**画面遷移**：
- 遷移元：オーバービュー画面、サイドナビゲーション
- 遷移先：アプリケーション詳細画面（`/application/completed/:id`）

**権限による表示制御**：本画面には特別な権限制御は実装されていない。全ユーザーが同一の内容を閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | 完了済みアプリケーション一覧の取得（/applications/overview API） |
| 23 | ジョブ管理 | 補助機能 | アプリケーションステータス（FINISHED/FAILED/CANCELED）のフィルタリング |

## 画面種別

一覧

## URL/ルーティング

- パス: `/application/completed`
- ルート定義: `APPLICATION_ROUTES` -> `completed` パス -> `ApplicationComponent`

## 入出力項目

### 入力項目

本画面には入力項目は存在しない（表示のみ）。

### 出力項目（API）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| applications | ApplicationItem[] | アプリケーション一覧 |

## 表示項目

### アプリケーション一覧テーブル

| 項目名 | 表示名 | データ型 | ソート | 説明 |
|--------|--------|----------|--------|------|
| name | Application Name | string | 可（文字列比較） | アプリケーション名（幅40%） |
| start-time | Start Time | number | 可（数値比較） | 開始時刻（yyyy-MM-dd HH:mm:ss.SSS形式で表示） |
| duration | Duration | number | 可（数値比較） | 実行時間（humanizeDurationパイプで変換） |
| end-time | End Time | number | 可（数値比較、デフォルト降順） | 終了時刻（yyyy-MM-dd HH:mm:ss.SSS形式で表示） |
| jobs | Jobs | JobStatus | 不可 | ジョブ状態バッジ（各ステータスの件数表示） |
| status | Status | string | 可（文字列比較） | アプリケーション状態バッジ（FINISHED/FAILED/CANCELED） |

## イベント仕様

### 1-アプリケーション行クリック

ユーザーがテーブル内のアプリケーション行をクリックすると、該当アプリケーションの詳細画面へ遷移する。

**処理フロー**:
1. `navigateToApplication()` メソッドが呼び出される
2. `Router.navigate()` により `/application/completed/:id` へ遷移
3. アプリケーション詳細画面が表示される

### 2-列ヘッダークリック（ソート）

テーブルの列ヘッダーをクリックすると、その列を基準にテーブルがソートされる。

**ソート機能**:
- Application Name: 文字列の辞書順（`localeCompare`）
- Start Time: 数値の昇順/降順
- Duration: 数値の昇順/降順
- End Time: 数値の昇順/降順（デフォルト：降順）
- Status: 文字列の辞書順（`localeCompare`）

### 3-定期リフレッシュ

StatusServiceの`refresh$`をサブスクライブし、定期的にアプリケーション一覧を再取得する。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はREAD ONLYであり、データベースの更新は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示・リフレッシュ | - | SELECT | REST API経由でアプリケーション情報を取得 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| - | - | （メッセージ表示なし） | - |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|----------|---------|------|
| API通信エラー | エラー表示なし | `catchError(() => EMPTY)` によりエラーを握りつぶし、空配列を返却 |
| データ0件 | 空のテーブル | テーブル本体のみ表示（エラーメッセージなし） |

## 備考

- 本画面と「実行中アプリケーション一覧」（No.40）は同一のコンポーネント（`ApplicationComponent`）を使用しており、URLパスの`completed`/`running`によって表示内容を切り替えている
- `isCompleted`フラグがtrueの場合、カードタイトルは「Completed Applications」となる
- アプリケーションのcompletedフラグは、ステータスが'FINISHED'、'FAILED'、'CANCELED'のいずれかの場合にtrueとなる
- 終了時刻（End Time）の降順がデフォルトソートとして設定されており、最近完了したアプリケーションが上部に表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、APIレスポンスとして受け取るデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application-overview.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/application-overview.ts` | ApplicationOverview、ApplicationItem、JobStatusインターフェースの定義を確認。特にApplicationItemの各プロパティ（id, name, status, start-time, end-time, duration, jobs, completed）を理解する |

**読解のコツ**: TypeScriptのインターフェース定義では、ケバブケース（'start-time'）のプロパティ名がAPIレスポンスのJSONキーに対応している。

#### Step 2: エントリーポイントを理解する

処理の起点となるルーティングとコンポーネントを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routes.ts | `flink-runtime-web/web-dashboard/src/app/pages/application/routes.ts` | `APPLICATION_ROUTES`定義を確認。`/completed`パスが`ApplicationComponent`にマッピングされていることを確認 |
| 2-2 | application.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.ts` | コンポーネントの初期化処理（ngOnInit）、updateApplicationIdSelected()メソッドでのURL解析、isCompletedフラグの設定を理解する |

**主要処理フロー**:
1. **行51-60**: ngOnInitでルーターイベントを監視
2. **行72-77**: updateApplicationIdSelected()でURLからcompletedフラグを判定
3. **行47-49**: cardTitleゲッターでisCompletedに応じたタイトルを返却

#### Step 3: テンプレートと子コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | application.component.html | `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.html` | `flink-application-list`コンポーネントの使用方法、`[completed]`と`[title]`プロパティバインディングを確認 |
| 3-2 | application-list.component.ts | `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.ts` | @Inputプロパティ（completed, title）、ソート関数の定義、ngOnInitでのデータ取得フローを理解する |

**主要処理フロー**:
- **行68-72**: ソート関数の定義（sortApplicationNameFn等）
- **行88-110**: ngOnInitでstatusService.refresh$を購読し、applicationService.loadApplications()を呼び出す
- **行97**: completedフラグでフィルタリング
- **行100-106**: completedの場合はend-time降順、runningの場合はstart-time降順でソート

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | application.service.ts | `flink-runtime-web/web-dashboard/src/app/services/application.service.ts` | loadApplications()メソッドのAPI呼び出し（/applications/overview）、レスポンスの加工処理を理解する |

**主要処理フロー**:
- **行44-59**: loadApplications()メソッド
- **行45**: `/applications/overview` APIエンドポイントの呼び出し
- **行47-54**: レスポンス加工（TOTAL計算、completedフラグ設定）

### プログラム呼び出し階層図

```
ApplicationComponent
    │
    ├─ ngOnInit()
    │      └─ updateApplicationIdSelected()  // URLからisCompletedを判定
    │
    └─ [テンプレート] ApplicationListComponent
           │
           ├─ ngOnInit()
           │      └─ StatusService.refresh$
           │              └─ ApplicationService.loadApplications()
           │                      └─ HttpClient.get('/applications/overview')
           │
           └─ navigateToApplication()
                  └─ Router.navigate()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

StatusService.refresh$  ─────▶ ApplicationService             ┌──────────────────┐
    (定期リフレッシュ)          .loadApplications()          │  ApplicationItem │
                               │                              │  ・id            │
                               ▼                              │  ・name          │
/applications/overview  ◀───── HttpClient.get()              │  ・status        │
    (REST API)                 │                              │  ・start-time    │
                               ▼                              │  ・end-time      │
                          map(data => ...)                   │  ・duration      │
                          ・TOTAL計算                         │  ・jobs          │
                          ・completedフラグ設定               │  ・completed     │
                               │                              └──────────────────┘
                               ▼                                      │
                          ApplicationListComponent                    │
                          ・filter(completed === true)                ▼
                          ・sort(end-time DESC)              ┌──────────────────┐
                               │                              │  nz-table        │
                               ▼                              │  (テーブル表示)   │
                          flink-application-list             └──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| application.component.ts | `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.ts` | ソース | メインコンポーネント（ルーティングコンテナ） |
| application.component.html | `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.html` | テンプレート | 画面テンプレート |
| application-list.component.ts | `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.ts` | ソース | アプリケーション一覧表示コンポーネント |
| application-list.component.html | `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.html` | テンプレート | 一覧テーブルのテンプレート |
| application.service.ts | `flink-runtime-web/web-dashboard/src/app/services/application.service.ts` | ソース | アプリケーションAPI呼び出しサービス |
| application-overview.ts | `flink-runtime-web/web-dashboard/src/app/interfaces/application-overview.ts` | ソース | データ型定義（インターフェース） |
| routes.ts | `flink-runtime-web/web-dashboard/src/app/pages/application/routes.ts` | ソース | ルーティング定義 |
