# 画面設計書 6-ジョブ概要（DAGグラフ）

## 概要

本ドキュメントは、Apache Flink Web Dashboardのジョブ概要（DAGグラフ）画面の設計仕様を記述したものである。本画面はジョブの実行計画をDAG（有向非循環グラフ）形式で視覚的に表示する。

### 本画面の処理概要

ジョブ概要画面は、Flinkジョブの実行計画（Execution Plan）をDAGグラフとして可視化する。各オペレーター（頂点）のバックプレッシャー状態、データスキュー、ウォーターマーク情報をリアルタイムで表示し、頂点をクリックすることで詳細情報を確認できる。

**業務上の目的・背景**：複雑なストリーム処理パイプラインの構造を視覚的に把握することは、パフォーマンス分析や障害原因の特定に不可欠である。DAGグラフにより、オペレーター間のデータフローを直感的に理解し、ボトルネックとなっている箇所を迅速に特定できる。

**画面へのアクセス方法**：ジョブ詳細画面の「Overview」タブをクリック、または`/job/:status/:jid/overview`パスに直接アクセスする。

**主要な操作・処理内容**：
1. DAGグラフの描画・表示
2. メトリクス情報（バックプレッシャー、データスキュー、ウォーターマーク）の取得・表示
3. ペンディングオペレーターの表示切り替え
4. 頂点クリックによる詳細ドロワー表示
5. リスケール操作（並列度変更）

**画面遷移**：
- 遷移元：ジョブ詳細画面
- 遷移先：頂点詳細ドロワー（`/job/:status/:jid/overview/:vertexId`）

**権限による表示制御**：本画面に関しては、特別な権限制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | ジョブの実行計画（DAGグラフ）情報の取得・表示 |
| 57 | メトリクスコア | API連携 | バックプレッシャー、データスキュー、ウォーターマークのメトリクス取得 |
| 25 | リソース管理 | 補助機能 | ジョブリソース要件の変更（リスケール操作） |

## 画面種別

詳細 / グラフ表示

## URL/ルーティング

- パス: `/job/:status/:jid/overview`
- 頂点選択時: `/job/:status/:jid/overview/:vertexId`

## 入出力項目

| 項目名 | 種別 | データ型 | 説明 |
|--------|------|----------|------|
| jid | URLパラメータ | string | ジョブID（親から継承） |
| vertexId | URLパラメータ | string | 選択された頂点ID |

## 表示項目

### DAGグラフ

| 項目名 | データ型 | 説明 | 取得元 |
|--------|----------|------|--------|
| ノード | NodesItemCorrect[] | オペレーター（頂点）の配列 | JobLocalService |
| リンク | NodesItemLink[] | ノード間の接続情報 | JobLocalService |
| バックプレッシャー率 | number | 各ノードのバックプレッシャー率（0-100%） | メトリクスAPI |
| ビジー率 | number | 各ノードのビジー率（0-100%） | メトリクスAPI |
| データスキュー率 | number | 各ノードのデータスキュー率 | メトリクスAPI |
| ローウォーターマーク | number | 各ノードの最小ウォーターマーク | メトリクスAPI |

### ノード情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| id | string | ノードID |
| parallelism | number | 並列度 |
| operator | string | オペレーター名 |
| description | string | オペレーターの説明 |
| status | string | 実行状態 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化時（ngOnInit）

**処理フロー**:
1. JobLocalServiceからジョブ詳細変更を監視
2. ジョブIDが変更された場合、グラフを再描画
3. ノード数が変更された場合、ペンディング情報を更新
4. メトリクス情報を取得してノードに付加

**データソース**: JobLocalService.jobDetailChanges()

### 2-メトリクス取得・更新

**トリガー**: ジョブ詳細受信時

**処理フロー**:
1. mergeWithBackPressureAndSkew()でバックプレッシャーとスキュー情報を取得
2. mergeWithWatermarks()でウォーターマーク情報を取得
3. DagreComponentのノードを更新

**API呼び出し**:
- メトリクスAPI（backPressuredTimeMsPerSecond, busyTimeMsPerSecond, numRecordsInPerSecond）
- ウォーターマークAPI

### 3-ノードクリック

**トリガー**: DAGグラフ上のノードをクリック

**処理フロー**:
1. onNodeClick()が呼び出される
2. 既に選択中のノードでない場合、Router.navigate()で詳細画面に遷移
3. 選択されたノードにフォーカス

**遷移先**: `/job/:status/:jid/overview/:vertexId`

### 4-リスケール操作

**トリガー**: リスケールボタンクリック

**処理フロー**:
1. onRescale()が呼び出される
2. JobService.changeDesiredParallelism()を呼び出し
3. 成功時に通知メッセージを表示

**API呼び出し**:
- PUT `/jobs/{jobid}/resource-requirements`

### 5-ペンディングオペレーター表示切り替え

**トリガー**: 表示切り替えトグル

**処理フロー**:
1. refreshGraph()が呼び出される
2. showPendingOperatorsフラグに応じてノードとリンクを結合
3. DagreComponentでグラフを再描画

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| 画面表示 | - | SELECT | ジョブ詳細・メトリクス情報の取得 |
| リスケール | Flink JobManager | UPDATE | ジョブリソース要件の更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| rescale-success | 成功 | "Rescaling operation. Job resources requirements have been updated. Job will now try to rescale." | リスケール成功時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| メトリクス取得エラー | メトリクスAPI失敗 | catchErrorで元のノード配列を返却（メトリクスなしで表示継続） |

## 備考

- DagreComponentはD3.jsベースのDAGグラフライブラリを使用
- ResizeComponentでグラフ領域のリサイズに対応
- バックプレッシャー、データスキューは色分けで視覚化
- ウォーターマークはツールチップで表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-detail.ts | `src/app/interfaces/job-detail.ts` | NodesItemCorrect型、NodesItemLink型の定義 |

**読解のコツ**: NodesItemCorrectのlowWatermark、backPressuredPercentage、busyPercentage、dataSkewPercentageはメトリクス取得後に追加される動的プロパティ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-overview.component.ts | `src/app/pages/job/overview/job-overview.component.ts` | メインコンポーネント |

**主要処理フロー**:
1. **77-99行目**: ngOnInit()でジョブ詳細変更を監視
2. **85-98行目**: グラフデータの更新とメトリクス取得
3. **121-125行目**: onNodeClick()でノード選択処理
4. **145-157行目**: refreshNodesWithMetrics()でメトリクス更新
5. **159-179行目**: mergeWithBackPressureAndSkew()でバックプレッシャー取得
6. **182-192行目**: mergeWithWatermarks()でウォーターマーク取得

#### Step 3: メトリクス取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | metrics.service.ts | `src/app/services/metrics.service.ts` | メトリクス取得API |

**主要処理フロー**:
- loadMetricsWithAllAggregates(): 複数メトリクスを一括取得
- loadWatermarks(): ウォーターマーク情報を取得

### プログラム呼び出し階層図

```
JobOverviewComponent
    │
    ├─ JobLocalService.jobDetailChanges()
    │      └─ ジョブ詳細の監視
    │
    ├─ DagreComponent
    │      ├─ flush() ──▶ グラフ描画
    │      ├─ updateNode() ──▶ ノード更新
    │      └─ focusNode() ──▶ ノードフォーカス
    │
    ├─ MetricsService
    │      ├─ loadMetricsWithAllAggregates() ──▶ バックプレッシャー、スキュー取得
    │      └─ loadWatermarks() ──▶ ウォーターマーク取得
    │
    ├─ JobService.changeDesiredParallelism()
    │      └─ PUT /jobs/{jobid}/resource-requirements
    │
    └─ Router.navigate()
           └─ 頂点詳細ドロワーへ遷移
```

### データフロー図

```
[入力]                    [処理]                           [出力]

JobLocalService ─────────▶ ジョブ詳細受信
                              │
                              ├─▶ nodes/links抽出 ─────────▶ DagreComponent
                              │
                              └─▶ MetricsService
                                    │
                                    ├─▶ バックプレッシャー
                                    ├─▶ ビジー率
                                    ├─▶ データスキュー
                                    └─▶ ウォーターマーク
                                              │
                                              ▼
                                    DagreComponent.updateNode()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-overview.component.ts | `src/app/pages/job/overview/job-overview.component.ts` | ソース | メインコンポーネント |
| job-overview.component.html | `src/app/pages/job/overview/job-overview.component.html` | テンプレート | レイアウト |
| dagre.component.ts | `src/app/components/dagre/dagre.component.ts` | ソース | DAGグラフ描画 |
| resize.component.ts | `src/app/components/resize/resize.component.ts` | ソース | リサイズ対応 |
| metrics.service.ts | `src/app/services/metrics.service.ts` | ソース | メトリクス取得 |
| job-local.service.ts | `src/app/pages/job/job-local.service.ts` | ソース | データ共有 |
| job-overview.config.ts | `src/app/pages/job/overview/job-overview.config.ts` | 設定 | タブ設定 |
