# 画面設計書 7-タイムライン

## 概要

本ドキュメントは、Apache Flink Web Dashboardのタイムライン画面の設計仕様を記述したものである。本画面はジョブ実行のタイムラインを視覚的に表示する。

### 本画面の処理概要

タイムライン画面は、ジョブの各頂点（オペレーター）およびサブタスクの実行タイムラインをガントチャート形式で表示する。開始時刻、終了時刻、各状態の時間範囲を色分けして表示し、ジョブ全体の実行の流れを把握できる。

**業務上の目的・背景**：ストリーム処理ジョブのパフォーマンス分析において、各オペレーターの実行タイミングとDuration（実行時間）を視覚的に把握することは重要である。タイムライン表示により、遅延の原因となっているオペレーターの特定や、並列処理の効率性を評価できる。

**画面へのアクセス方法**：ジョブ詳細画面の「TimeLine」タブをクリック、または`/job/:status/:jid/timeline`パスに直接アクセスする。

**主要な操作・処理内容**：
1. メインタイムライン（全頂点）の描画・表示
2. 頂点クリックによるサブタスクタイムラインの表示
3. 状態ごとの色分け表示
4. ツールチップによる詳細情報表示

**画面遷移**：
- 遷移元：ジョブ詳細画面
- 遷移先：なし（本画面内で完結）

**権限による表示制御**：本画面に関しては、特別な権限制御は実装されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | REST API | 主機能 | ジョブ実行タイムライン情報の取得・表示 |
| 23 | ジョブ管理 | 補助機能 | サブタスク時間情報の取得 |

## 画面種別

詳細 / チャート表示

## URL/ルーティング

- パス: `/job/:status/:jid/timeline`

## 入出力項目

| 項目名 | 種別 | データ型 | 説明 |
|--------|------|----------|------|
| jid | URLパラメータ | string | ジョブID（親から継承） |

## 表示項目

### メインタイムライン（頂点レベル）

| 項目名 | データ型 | 説明 | 取得元 |
|--------|----------|------|--------|
| 頂点名 | string | オペレーター名 | JobLocalService |
| 状態 | string | 頂点の実行状態 | JobLocalService |
| 開始時刻 | timestamp | 頂点の開始時刻 | JobLocalService |
| 終了時刻 | timestamp | 頂点の終了時刻 | JobLocalService |
| 時間範囲 | [number, number] | 開始から終了までの範囲 | 計算値 |

### サブタスクタイムライン

| 項目名 | データ型 | 説明 | 取得元 |
|--------|----------|------|--------|
| サブタスク名 | string | サブタスクID + ホスト名 | `/jobs/{jobid}/vertices/{vertexid}/subtasktimes` API |
| 状態 | string | サブタスクの状態 | 同上 |
| 時間範囲 | [number, number] | 各状態の時間範囲 | 同上 |

## イベント仕様

### 1-画面初期化

**トリガー**: コンポーネント初期化後（ngAfterViewInit）

**処理フロー**:
1. setUpMainChart()でメインチャートを初期化
2. setUpSubTaskChart()でサブタスクチャートを初期化
3. JobLocalService.jobDetailChanges()をサブスクライブ
4. ジョブ詳細からvertices情報を抽出
5. 開始時刻でソートしてタイムラインデータを構築
6. G2チャートにデータを設定してレンダリング

**データソース**: JobLocalService.jobDetailChanges()

### 2-メインチャートクリック

**トリガー**: メインタイムライン上のバーをクリック

**処理フロー**:
1. クリック位置からレコードを特定
2. updateSubTaskChart()を呼び出し
3. 選択された頂点のサブタスク詳細を取得
4. サブタスクタイムラインを表示

**API呼び出し**:
- GET `/jobs/{jobid}/vertices/{vertexid}/subtasktimes`

### 3-サブタスクタイムライン表示

**トリガー**: updateSubTaskChart()呼び出し

**処理フロー**:
1. JobService.loadSubTaskTimes()でサブタスク時間情報を取得
2. timestamps情報を解析して状態ごとの時間範囲を計算
3. サブタスクチャートのサイズを調整
4. データを設定してレンダリング
5. isShowSubTaskTimeLineをtrueに設定

## データベース更新仕様

本画面はデータ参照のみを行い、データベースへの更新処理は発生しない。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 該当なし | - | SELECT | 全ての操作は参照のみ |

## メッセージ仕様

本画面では明示的なメッセージ表示は行われない。

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| API通信エラー | サブタスク時間情報取得失敗 | サブタスクチャートが表示されない |

## 備考

- G2（AntV）チャートライブラリを使用
- 座標系を転置（transpose）して水平バーチャートとして表示
- 状態ごとの色はConfigServiceのCOLOR_MAPで管理
- 時間フォーマットは`HH:mm:ss.SSS`を使用
- サブタスクタイムラインは自動スクロール（scrollIntoViewIfNeeded）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-detail.ts | `src/app/interfaces/job-detail.ts` | VerticesItemRange型の定義。rangeプロパティに注目 |
| 1-2 | job-timeline.ts | `src/app/interfaces/job-timeline.ts` | サブタスク時間情報のインターフェース |

**読解のコツ**: VerticesItemRangeのrangeは[start-time, end-time]の配列で、G2チャートのintervalプロットに直接渡される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-timeline.component.ts | `src/app/pages/job/timeline/job-timeline.component.ts` | メインコンポーネント |

**主要処理フロー**:
1. **68-106行目**: ngAfterViewInit()でチャート初期化とデータ取得
2. **177-221行目**: setUpMainChart()でメインチャート設定
3. **224-238行目**: setUpSubTaskChart()でサブタスクチャート設定
4. **113-175行目**: updateSubTaskChart()でサブタスク詳細取得・表示

#### Step 3: G2チャートの設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | config.service.ts | `src/app/services/config.service.ts` | COLOR_MAPの定義（状態ごとの色設定） |

**主要処理フロー**:
- coordinate('rect').transpose().scale(1, -1): 水平バーチャートへの変換
- interval().position().color(): バーチャートの位置と色設定
- label(): ラベル表示設定

### プログラム呼び出し階層図

```
JobTimelineComponent
    │
    ├─ @ViewChild(mainTimeLine) ──▶ G2.Chart インスタンス
    │
    ├─ @ViewChild(subTaskTimeLine) ──▶ G2.Chart インスタンス
    │
    ├─ JobLocalService.jobDetailChanges()
    │      └─ vertices情報の取得
    │
    ├─ setUpMainChart()
    │      └─ G2チャート初期化・設定
    │
    ├─ setUpSubTaskChart()
    │      └─ G2チャート初期化・設定
    │
    └─ JobService.loadSubTaskTimes()
           └─ GET /jobs/{jobid}/vertices/{vertexid}/subtasktimes
```

### データフロー図

```
[入力]                    [処理]                           [出力]

JobLocalService ─────────▶ jobDetail受信
                              │
                              ▼
                        vertices抽出
                              │
                              ├─▶ range計算 ─────────────▶ メインタイムライン
                              │
                              └─▶ ソート
                                    │
                                    ▼
                              G2.Chart.data()
                              G2.Chart.render()

クリックイベント ────────▶ loadSubTaskTimes()
                              │
                              ▼
                        timestamps解析
                              │
                              ▼
                        時間範囲計算 ─────────────▶ サブタスクタイムライン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-timeline.component.ts | `src/app/pages/job/timeline/job-timeline.component.ts` | ソース | メインコンポーネント |
| job-timeline.component.html | `src/app/pages/job/timeline/job-timeline.component.html` | テンプレート | レイアウト |
| job-timeline.component.less | `src/app/pages/job/timeline/job-timeline.component.less` | スタイル | スタイル定義 |
| job.service.ts | `src/app/services/job.service.ts` | ソース | サブタスク時間取得 |
| config.service.ts | `src/app/services/config.service.ts` | ソース | 色設定 |
| job-local.service.ts | `src/app/pages/job/job-local.service.ts` | ソース | データ共有 |
| job-detail.ts | `src/app/interfaces/job-detail.ts` | 型定義 | VerticesItemRange |
