---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-オーバービュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **ルートパスリダイレクト設定**：ルーティング設定ファイルが見つからず、リダイレクト動作を直接確認できていない
  2. **権限制御なしの記述**：ソースコードに権限チェックがないことは確認したが、バックエンド側の権限制御有無は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/app/pages/overview/overview.component.ts`（49-87行目）
- E-02: `src/app/pages/overview/overview.component.html`（1-31行目）
- E-03: `src/app/services/overview.service.ts`（34-36行目）
- E-04: `src/app/services/application.service.ts`（44-58行目）
- E-05: `src/app/interfaces/overview.ts`（全体）
- E-06: `src/app/pages/overview/statistic/overview-statistic.component.ts`（36-57行目）
- E-07: `src/app/components/application-list/application-list.component.ts`（59-124行目）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`（行2）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行2-4）
- E-10: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは`/overview` | E-08, E-10 | ○ |
| C-02 | デフォルトランディングページとしてリダイレクトされる | E-08（備考欄） | ○ |
| C-03 | ルートパス`/`からリダイレクトされる | **根拠なし** | △ |
| C-04 | StatusService.refresh$でデータ取得をトリガー | E-01（50-54行目） | ○ |
| C-05 | ApplicationService.loadApplications()でアプリ一覧取得 | E-01（52行目）, E-04 | ○ |
| C-06 | OverviewService.loadOverview()でクラスター概要取得 | E-01（59行目）, E-03 | ○ |
| C-07 | REST API `/overview`を呼び出す | E-03（35行目） | ○ |
| C-08 | REST API `/applications/overview`を呼び出す | E-04（45行目） | ○ |
| C-09 | TaskManager数を表示 | E-05（20行目）, E-01（66行目） | ○ |
| C-10 | スロット数を表示 | E-05（22-24行目）, E-01（68-69行目） | ○ |
| C-11 | Flinkバージョンを表示 | E-05（30-31行目）, E-01（71-72行目） | ○ |
| C-12 | アプリケーション統計を計算・表示 | E-01（61-65行目） | ○ |
| C-13 | 実行中アプリケーション一覧を表示 | E-02（20-25行目）, E-07 | ○ |
| C-14 | 完了済みアプリケーション一覧を表示 | E-02（26-31行目）, E-07 | ○ |
| C-15 | アプリケーションクリックで詳細画面に遷移 | E-01（85-87行目）, E-02（24, 30行目） | ○ |
| C-16 | 遷移先は`/application/running/:id`または`/application/completed/:id` | E-02（24, 30行目） | ○ |
| C-17 | ChangeDetectionStrategy.OnPushを使用 | E-01（33行目） | ○ |
| C-18 | destroy$でサブスクリプションをクリーンアップ | E-01（40, 51, 58, 80-83行目） | ○ |
| C-19 | combineLatestで複数APIレスポンスを結合 | E-01（59行目） | ○ |
| C-20 | 権限制御なし | **根拠なし** | △ |
| C-21 | catchErrorでEMPTYを返却 | E-03（35行目）, E-04（57行目） | ○ |
| C-22 | completedフラグでフィルタリング | E-07（97行目） | ○ |
| C-23 | 機能No.32 REST APIが主機能 | E-09（行2） | ○ |
| C-24 | 機能No.23 ジョブ管理が補助機能 | E-09（行3） | ○ |
| C-25 | 機能No.57 メトリクスコアがAPI連携 | E-09（行4） | ○ |

## 4) 不足情報（Unknown / Missing）
- **ルートパスリダイレクト設定**：app.routes.tsまたは同等のルーティング設定ファイルが見つからなかった。画面一覧.csvの備考欄に「デフォルト画面（/**/リダイレクト先）」と記載があるため、設計意図としては存在するが、実装確認ができていない。
  - 候補：`src/app/app.module.ts` / `src/app/app-routing.module.ts` / `angular.json`
- **権限制御の有無**：フロントエンドコードには権限チェックロジックがないことを確認したが、バックエンドのREST API側での権限制御有無は本調査の範囲外。
  - 候補：バックエンドJavaコード / 認証・認可設定ファイル

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：データ構造・API呼び出しに関する記述 - ソースコードで完全に確認済み
- **リスク0（低）**：画面遷移に関する記述 - HTMLテンプレートで確認済み
- **リスク1（中）**：リダイレクト設定 - 設計意図は確認できるが実装の直接確認なし
- **リスク0（低）**：RxJS処理フロー - ソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ルートパス（`/`）からのリダイレクト動作を実機で確認
- [ ] REST APIの認証・認可要件をバックエンドチームに確認
- [ ] StatusServiceのリフレッシュ間隔が運用要件を満たしているか確認
- [ ] ブロック中TaskManager/スロットの表示条件（非ゼロ時のみ）が正しいか確認
