---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-ジョブ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/configuration/job-configuration.component.ts`（行1-77）
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/configuration/job-configuration.component.html`（行1-70）
- E-03: `flink-runtime-web/web-dashboard/src/app/interfaces/job-config.ts`（行1-32）
- E-04: `flink-runtime-web/web-dashboard/src/app/services/job.service.ts`（行84-86）
- E-05: `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts`（行53-55）
- E-06: `flink-runtime-web/web-dashboard/src/app/pages/job/modules/completed-job/routes.ts`（行122-131）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行25-26）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`（行12）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は実行設定とユーザー定義設定を表示する | E-02 (行19-69) | ○ |
| C-02 | JobLocalServiceからジョブ詳細変更を購読する | E-01 (行51-53) | ○ |
| C-03 | JobService.loadJobConfig()でAPI呼び出し | E-01 (行54), E-04 (行84-86) | ○ |
| C-04 | APIエンドポイントは /jobs/{jobid}/config | E-04 (行85) | ○ |
| C-05 | 再起動戦略を表示する | E-02 (行32), E-03 (行24) | ○ |
| C-06 | ジョブ並列度を表示（-1はauto） | E-02 (行36-41), E-01 (行39-41) | ○ |
| C-07 | オブジェクト再利用モードを表示 | E-02 (行46), E-03 (行26) | ○ |
| C-08 | ユーザー設定はキー名でソートされる | E-01 (行67) | ○ |
| C-09 | ルーティングパスは configuration | E-06 (行122-131) | ○ |
| C-10 | 関連機能No.32 REST API | E-07 (行25) | ○ |
| C-11 | 関連機能No.4 設定管理 | E-07 (行26) | ○ |
| C-12 | コンポーネントセレクタは flink-job-configuration | E-01 (行32) | ○ |
| C-13 | NzCardModuleを使用 | E-01 (行26), E-02 (行19, 51) | ○ |
| C-14 | NzTableModuleを使用 | E-01 (行27), E-02 (行20, 52) | ○ |
| C-15 | ChangeDetectionStrategy.OnPushを使用 | E-01 (行35) | ○ |
| C-16 | コンポーネントはOnInit, OnDestroyを実装 | E-01 (行38) | ○ |
| C-17 | destroy$でサブスクリプション管理 | E-01 (行42, 55, 72-74) | ○ |
| C-18 | cdr.markForCheck()で変更検知 | E-01 (行68) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] APIエンドポイント `/jobs/{jobid}/config` がバックエンドに実装されていることを確認
- [ ] JobConfigインターフェースの構造がAPIレスポンスと一致することを確認
- [ ] ユーザー設定のソート処理が期待通りに動作することを確認
