---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-頂点詳細ドロワー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/drawer/job-overview-drawer.component.ts`（行1-116）
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/drawer/job-overview-drawer.component.html`（行1-24）
- E-03: `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts`（行39, 61-67）
- E-04: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/routes.ts`（行24-113）
- E-05: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/job-overview.config.ts`（行42-52）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行29-30）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`（行14）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ドロワーはDAGグラフで頂点選択時にスライドインする | E-01 (行41-52) | ○ |
| C-02 | @drawerアニメーショントリガーでスライドイン/アウト | E-01 (行42-52) | ○ |
| C-03 | ActivatedRouteからvertexIdを取得 | E-01 (行81) | ○ |
| C-04 | JobLocalServiceにselectedVertexを設定 | E-01 (行91), E-03 (行65-67) | ○ |
| C-05 | タブナビゲーションはモジュール設定から取得 | E-01 (行76-77), E-05 (行42-52) | ○ |
| C-06 | デフォルトタブはdetail | E-01 (行86), E-05 (行44) | ○ |
| C-07 | closeDrawer()で全画面解除またはドロワーを閉じる | E-01 (行102-109) | ○ |
| C-08 | fullDrawer()で全画面モードに切り替え | E-01 (行111-114) | ○ |
| C-09 | ngOnDestroy()でselectedVertexをnullに設定 | E-01 (行99) | ○ |
| C-10 | ルーティングパスは :vertexId | E-04 (行30) | ○ |
| C-11 | 子ルートにdetail, subtasks, taskmanagers等がある | E-04 (行33-108) | ○ |
| C-12 | NavigationComponentでタブナビゲーション表示 | E-02 (行18), E-01 (行58) | ○ |
| C-13 | router-outletで子コンポーネントを表示 | E-02 (行20) | ○ |
| C-14 | 閉じるボタンはrightアイコン | E-02 (行22) | ○ |
| C-15 | 全画面ボタンはleftアイコン | E-02 (行23) | ○ |
| C-16 | コンポーネントセレクタは flink-job-overview-drawer | E-01 (行38) | ○ |
| C-17 | ChangeDetectionStrategy.OnPushを使用 | E-01 (行57) | ○ |
| C-18 | fullScreenプロパティで全幅表示を制御 | E-01 (行63, 55, 103-114) | ○ |
| C-19 | 関連機能No.32 REST API | E-06 (行29) | ○ |
| C-20 | 関連機能No.23 ジョブ管理 | E-06 (行30) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] @drawerアニメーションが正しく動作することを確認
- [ ] タブナビゲーションの各タブが正しく子コンポーネントに遷移することを確認
- [ ] 閉じる/全画面ボタンが期待通りに動作することを確認
