---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-頂点詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/detail/job-overview-drawer-detail.component.ts`（行1-99）
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/detail/job-overview-drawer-detail.component.html`（行1-103）
- E-03: `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts`（行61-63）
- E-04: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/job-overview.config.ts`（行53-58）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行31）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行15）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はselectedVertexChanges()から頂点情報を取得 | E-01 (行80-91), E-03 (行61-63) | ○ |
| C-02 | descriptionの<br/>を改行に変換 | E-01 (行85-88) | ○ |
| C-03 | 左右2カラムのグリッドレイアウト | E-02 (行24-93) | ○ |
| C-04 | Stateをバッジ表示（stateBadgeComponent） | E-02 (行29-33), E-01 (行61, 71-73) | ○ |
| C-05 | Parallelismを数値表示 | E-02 (行36-37) | ○ |
| C-06 | Max Parallelismにツールチップ付き | E-02 (行38-44, 98-101) | ○ |
| C-07 | Start Timeをyyyy-MM-dd HH:mm:ss.SSS形式で表示 | E-02 (行47) | ○ |
| C-08 | End Timeをyyyy-MM-dd HH:mm:ss.SSS形式で表示 | E-02 (行51) | ○ |
| C-09 | Durationをhumanizurationパイプで表示 | E-02 (行55) | ○ |
| C-10 | Taskをバッジ表示（taskCountComponent） | E-02 (行63-67), E-01 (行62, 74-76) | ○ |
| C-11 | Records Sentを数値（3桁区切り）で表示 | E-02 (行71) | ○ |
| C-12 | Bytes SentをhumanizeBytesパイプで表示 | E-02 (行83) | ○ |
| C-13 | メトリクスの*-completeフラグでロード状態を判定 | E-02 (行70, 76, 82, 88) | ○ |
| C-14 | ロード中はローディングアイコンを表示 | E-02 (行95-97) | ○ |
| C-15 | コンポーネントセレクタは flink-job-overview-drawer-detail | E-01 (行42) | ○ |
| C-16 | ChangeDetectionStrategy.OnPushを使用 | E-01 (行44) | ○ |
| C-17 | モジュール設定からカスタムコンポーネントを取得 | E-01 (行71-76), E-04 (行53-58) | ○ |
| C-18 | NzGridModuleを使用 | E-01 (行35), E-02 (行24) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] メトリクスの*-completeフラグが正しく設定されることを確認
- [ ] Max Parallelismのツールチップが正しく表示されることを確認
- [ ] 動的コンポーネント（stateBadge, taskCount）が正しく表示されることを確認
