---
generated_at: 2026-02-02 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-TaskManager一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/taskmanagers/job-overview-drawer-taskmanagers.component.ts`（行1-125）
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/taskmanagers/job-overview-drawer-taskmanagers.component.html`（行1-102）
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job.service.ts`（行151-155）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行34-35）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行17）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobService.loadTaskManagers()でAPI呼び出し | E-01 (行106), E-03 (行151-155) | ○ |
| C-02 | APIエンドポイント /jobs/{jid}/vertices/{vid}/taskmanagers | E-03 (行153) | ○ |
| C-03 | 仮想スクロールを使用 | E-02 (行26-29), E-01 (行76) | ○ |
| C-04 | Endpointカラムでソート可能 | E-02 (行33), E-01 (行68) | ○ |
| C-05 | Tasksカラムでタスク状態バッジを表示 | E-02 (行77-81), E-01 (行78-79, 93-95) | ○ |
| C-06 | Statusカラムで状態バッジを表示 | E-02 (行83-87), E-01 (行79, 96-98) | ○ |
| C-07 | Endpointはellipsis-cellクラスで省略表示 | E-02 (行51) | ○ |
| C-08 | virtualItemSize = 36 | E-01 (行76) | ○ |
| C-09 | catchErrorでof([])を返却 | E-01 (行108) | ○ |
| C-10 | isLoadingでローディング状態を管理 | E-01 (行75, 115), E-02 (行21) | ○ |
| C-11 | trackByEndpointでトラッキング | E-01 (行62), E-02 (行29) | ○ |
| C-12 | コンポーネントセレクタは flink-job-overview-drawer-taskmanagers | E-01 (行47) | ○ |
| C-13 | ChangeDetectionStrategy.OnPushを使用 | E-01 (行49) | ○ |
| C-14 | 関連機能No.32 REST API | E-04 (行34) | ○ |
| C-15 | 関連機能No.24 タスク実行 | E-04 (行35) | ○ |
| C-16 | モジュール設定からアクションコンポーネントを取得 | E-01 (行90-92) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] ソート機能が各カラムで正しく動作することを確認
- [ ] タスク状態バッジと状態バッジが正しく表示されることを確認
- [ ] アクションコンポーネントからTaskManager詳細への遷移が正しく動作することを確認
