---
generated_at: 2026-02-02 11:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-ウォーターマーク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/watermarks/job-overview-drawer-watermarks.component.ts`（行1-104）
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/watermarks/job-overview-drawer-watermarks.component.html`（行1-60）
- E-03: `flink-runtime-web/web-dashboard/src/app/services/metrics.service.ts`（行147-174）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行36-37）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行18）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MetricsService.loadWatermarks()でAPI呼び出し | E-01 (行70), E-03 (行147-174) | ○ |
| C-02 | APIエンドポイント /jobs/{jid}/vertices/{vid}/watermarks | E-03 (行149) | ○ |
| C-03 | WatermarkDataインターフェース（subTaskIndex, watermark） | E-01 (行36-39) | ○ |
| C-04 | オブジェクト→配列変換（for...in） | E-01 (行72-78) | ○ |
| C-05 | SubTask、Watermark、Datetimeの3カラム表示 | E-02 (行34-46) | ○ |
| C-06 | humanizeWatermarkパイプでウォーターマーク値を変換 | E-02 (行53), E-01 (行25-26, 46) | ○ |
| C-07 | humanizeWatermarkToDatetimeパイプで日時に変換 | E-02 (行54), E-01 (行25-27, 46) | ○ |
| C-08 | Datetimeカラムにツールチップでタイムゾーン説明 | E-02 (行37-45) | ○ |
| C-09 | sortWatermark()でソート処理 | E-01 (行100-102), E-02 (行35-36) | ○ |
| C-10 | 仮想スクロールを使用 | E-02 (行27-30), E-01 (行54) | ○ |
| C-11 | catchErrorでof([])を返却 | E-01 (行81-82) | ○ |
| C-12 | isLoadingでローディング状態を管理 | E-01 (行53, 89), E-02 (行22) | ○ |
| C-13 | コンポーネントセレクタは flink-job-overview-drawer-watermarks | E-01 (行42) | ○ |
| C-14 | 関連機能No.32 REST API | E-04 (行36) | ○ |
| C-15 | 関連機能No.10 Watermark | E-04 (行37) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] humanizeWatermarkパイプが特殊値（Long.MIN_VALUE等）を正しく処理することを確認
- [ ] humanizeWatermarkToDatetimeパイプがローカルタイムゾーンで正しく日時を表示することを確認
- [ ] ソート機能が正しく動作することを確認
