---
generated_at: 2026-02-02 11:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-アキュムレーター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/accumulators/job-overview-drawer-accumulators.component.ts`（行1-102）
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/accumulators/job-overview-drawer-accumulators.component.html`（行1-92）
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job.service.ts`（行94-108）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行38-39）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行19）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobService.loadAccumulators()でAPI呼び出し | E-01 (行62), E-03 (行94-108) | ○ |
| C-02 | forkJoinで2つのAPIを並行呼び出し | E-03 (行95-102) | ○ |
| C-03 | 頂点アキュムレーターAPI /vertices/{vid}/accumulators | E-03 (行97) | ○ |
| C-04 | サブタスクアキュムレーターAPI /vertices/{vid}/subtasks/accumulators | E-03 (行100) | ○ |
| C-05 | Vertex AccumulatorsタブとSubTask Accumulatorsタブの2タブ構成 | E-02 (行19-20, 53) | ○ |
| C-06 | transformToSubTaskAccumulator()でデータ変換 | E-01 (行76, 86-100) | ○ |
| C-07 | user-accumulators配列を展開 | E-01 (行90-96) | ○ |
| C-08 | Vertex AccumulatorsはName, Type, Valueの3カラム | E-02 (行35-38) | ○ |
| C-09 | SubTask Accumulatorsは4カラム（SubTask, Name, Type, Value） | E-02 (行67-72) | ○ |
| C-10 | SubTaskカラムは「(subtask) host, attempt: N」形式 | E-02 (行79-80) | ○ |
| C-11 | Value列は数値の場合number:'1.0-3'パイプで表示 | E-02 (行46) | ○ |
| C-12 | 仮想スクロールを使用 | E-02 (行27-31, 59-64) | ○ |
| C-13 | catchErrorで{main:[], subtasks:[]}を返却 | E-01 (行63-67) | ○ |
| C-14 | 関連機能No.32 REST API | E-04 (行38) | ○ |
| C-15 | 関連機能No.23 ジョブ管理 | E-04 (行39) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] transformToSubTaskAccumulator()の変換処理が正しく動作することを確認
- [ ] Vertex AccumulatorsとSubTask Accumulatorsの両タブが正しく表示されることを確認
- [ ] アキュムレーターが定義されていない場合の表示を確認
