---
generated_at: 2026-02-02 11:10:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-メトリクスチャート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/chart/job-overview-drawer-chart.component.ts`（行1-121）
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/chart/job-overview-drawer-chart.component.html`（行1-49）
- E-03: `flink-runtime-web/web-dashboard/src/app/services/metrics.service.ts`（行40-78）
- E-04: `flink-runtime-web/web-dashboard/src/app/pages/job/job-local.service.ts`（行33）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行40-41）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行20）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MetricsService.loadAllAvailableMetrics()で利用可能メトリクス取得 | E-01 (行97), E-03 (行40-58) | ○ |
| C-02 | MetricsService.loadMetrics()でメトリクス値取得 | E-01 (行77), E-03 (行60-78) | ○ |
| C-03 | APIエンドポイント /jobs/{jid}/vertices/{vid}/metrics | E-03 (行42, 63) | ○ |
| C-04 | @ViewChildrenでJobChartComponentのリストを取得 | E-01 (行53) | ○ |
| C-05 | distinctUntilChangedで頂点ID変更を検出 | E-01 (行67) | ○ |
| C-06 | metricsCacheMapで選択状態をキャッシュ | E-01 (行99, 107, 113), E-04 (行33) | ○ |
| C-07 | キャッシュキーは「jobId/vertexId」形式 | E-01 (行96) | ○ |
| C-08 | updateMetric()でメトリクスを追加 | E-01 (行105-109), E-02 (行28) | ○ |
| C-09 | closeMetric()でメトリクスを削除 | E-01 (行111-115), E-02 (行45) | ○ |
| C-10 | updateUnselectedMetricList()で未選択リストを更新 | E-01 (行117-119) | ○ |
| C-11 | chart.refresh(res)でチャートを更新 | E-01 (行82-84) | ○ |
| C-12 | 利用可能メトリクスが空の場合「No Available Metric」表示 | E-02 (行20) | ○ |
| C-13 | NzSelectModuleでドロップダウン選択 | E-01 (行35), E-02 (行23-38) | ○ |
| C-14 | flink-job-chartでチャート描画 | E-02 (行43-47), E-01 (行33) | ○ |
| C-15 | コンポーネントセレクタは flink-job-overview-drawer-chart | E-01 (行40) | ○ |
| C-16 | 関連機能No.32 REST API | E-05 (行40) | ○ |
| C-17 | 関連機能No.57 メトリクスコア | E-05 (行41) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] メトリクス選択状態のキャッシュが正しく動作することを確認
- [ ] チャートのリアルタイム更新が正しく動作することを確認
- [ ] チャートの追加/削除が正しく動作することを確認
