---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ジョブサブミット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/app/pages/submit/submit.component.ts`（全体）
- E-02: `src/app/pages/submit/submit.component.html`（全体）
- E-03: `src/app/services/jar.service.ts`（全体）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行3）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行5-6）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは`/submit` | E-04, E-06 | ○ |
| C-02 | JARファイルのアップロード機能がある | E-01（127-143行目）, E-03（46-53行目） | ○ |
| C-03 | POST `/jars/upload`でアップロード | E-03（49行目） | ○ |
| C-04 | アップロードプログレス表示がある | E-01（130-133行目）, E-02（157-163行目） | ○ |
| C-05 | JARファイル一覧を表示 | E-01（71行目）, E-02（26-126行目） | ○ |
| C-06 | GET `/jars`で一覧取得 | E-03（35行目） | ○ |
| C-07 | JAR削除機能がある | E-01（145-150行目）, E-03（55-57行目） | ○ |
| C-08 | DELETE `/jars/{jarId}`で削除 | E-03（56行目） | ○ |
| C-09 | 削除確認ダイアログが表示される | E-02（53-60行目） | ○ |
| C-10 | Entry Classの入力が可能 | E-01（95行目）, E-02（69行目） | ○ |
| C-11 | Parallelismの入力が可能 | E-01（96行目）, E-02（79行目） | ○ |
| C-12 | Program Argumentsの入力が可能 | E-01（97行目）, E-02（88-91行目） | ○ |
| C-13 | Savepoint Pathの入力が可能 | E-01（98行目）, E-02（99-104行目） | ○ |
| C-14 | Allow Non Restored Stateのチェックボックスがある | E-01（99行目）, E-02（110行目） | ○ |
| C-15 | Show Planボタンで実行計画プレビュー | E-01（169-182行目）, E-02（117行目） | ○ |
| C-16 | GET `/jars/{jarId}/plan`で実行計画取得 | E-03（100行目） | ○ |
| C-17 | Submitボタンでジョブ実行 | E-01（188-201行目）, E-02（118行目） | ○ |
| C-18 | POST `/jars/{jarId}/run`でジョブ実行 | E-03（84行目） | ○ |
| C-19 | ジョブ実行後に`/job/running/{jobId}`に遷移 | E-01（199行目） | ○ |
| C-20 | Yarn環境ではアップロード機能が制限される | E-01（93行目）, E-02（128-138行目） | ○ |
| C-21 | Yarn環境判定はURLに`/proxy/application_`が含まれるか | E-01（93行目） | ○ |
| C-22 | JAR行クリックで展開/折りたたみ | E-01（152-167行目）, E-02（43行目） | ○ |
| C-23 | 展開時に最初のエントリークラスがセットされる | E-01（162-166行目） | ○ |
| C-24 | DAGグラフはDagreComponentで描画 | E-01（80行目, 180行目）, E-02（173行目） | ○ |
| C-25 | ChangeDetectionStrategy.OnPushを使用 | E-01（46行目） | ○ |
| C-26 | 機能No.32 REST APIが主機能 | E-05（行5） | ○ |
| C-27 | 機能No.23 ジョブ管理が遷移先機能 | E-05（行6） | ○ |
| C-28 | ReactiveFormsModuleでフォーム管理 | E-01（56行目, 77行目, 94行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：全ての主張がソースコードで直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Yarn環境での代替URL取得ロジックが正しく動作するか確認
- [ ] 大きなJARファイルアップロード時のタイムアウト設定を確認
- [ ] savepointPathのバリデーションがバックエンドで行われているか確認
- [ ] 並列度（Parallelism）の入力値バリデーションを確認
