---
generated_at: 2026-02-02 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-バックプレッシャー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/backpressure/job-overview-drawer-backpressure.component.ts`（行1-167）
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/backpressure/job-overview-drawer-backpressure.component.html`（行1-142）
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job.service.ts`（行116-119）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行42-43）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行21）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobService.loadOperatorBackPressure()でAPI呼び出し | E-01 (行92), E-03 (行116-119) | ○ |
| C-02 | APIエンドポイント /jobs/{jid}/vertices/{vid}/backpressure | E-03 (行118) | ○ |
| C-03 | ヘッダーにMeasurement（経過時間）を表示 | E-02 (行36-39) | ○ |
| C-04 | status === 'deprecated'で「Sampling in progress...」表示 | E-02 (行40) | ○ |
| C-05 | 全体のバックプレッシャーレベルをバッジで表示 | E-02 (行47-50) | ○ |
| C-06 | RUNNING/INITIALIZING以外でサンプリング不可メッセージ | E-02 (行53-60) | ○ |
| C-07 | SubTask, Backpressure, Idle, Busy, Status, Thread Dumpの6カラム | E-02 (行64-70) | ○ |
| C-08 | Busyカラムはデフォルト降順ソート | E-02 (行67) | ○ |
| C-09 | prettyPrint()でバックプレッシャー率を%表示 | E-01 (行147-153), E-02 (行86-88) | ○ |
| C-10 | NaN値は「N/A」と表示 | E-01 (行149) | ○ |
| C-11 | 展開機能でother-concurrent-attemptsを表示 | E-02 (行77-79, 112-136), E-01 (行138-145) | ○ |
| C-12 | スレッドダンプへのリンクを提供 | E-02 (行96-109) | ○ |
| C-13 | リンクは別タブで開く（target="_blank"） | E-02 (行107) | ○ |
| C-14 | mapOfSubtaskでサブタスク情報を保持 | E-01 (行66, 108-125) | ○ |
| C-15 | 仮想スクロールを使用 | E-02 (行27-30) | ○ |
| C-16 | catchErrorで{}を返却 | E-01 (行93-95, 113-115) | ○ |
| C-17 | sortByBackpressureRatio, sortByIdleRatio, sortByBusyRatio | E-01 (行155-165), E-02 (行65-67) | ○ |
| C-18 | コンポーネントセレクタは flink-job-overview-drawer-backpressure | E-01 (行48) | ○ |
| C-19 | 関連機能No.32 REST API | E-04 (行42) | ○ |
| C-20 | 関連機能No.57 メトリクスコア | E-04 (行43) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] バックプレッシャーのサンプリングが正しく動作することを確認
- [ ] 各ソート機能が正しく動作することを確認
- [ ] スレッドダンプへのリンクが正しく遷移することを確認
- [ ] RUNNING/INITIALIZING以外の状態でのメッセージ表示を確認
