---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：21-フレームグラフ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティングパス**：実際のルーティング定義との突き合わせが必要

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/flamegraph/job-overview-drawer-flamegraph.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job/overview/flamegraph/job-overview-drawer-flamegraph.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/job-flamegraph.ts`
- E-05: `flink-runtime-web/web-dashboard/src/app/components/flame-graph/flame-graph.component.ts`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フレームグラフはCPU使用率を階層的に視覚化する | E-05 (d3-flame-graph使用) | ○ |
| C-02 | フレームグラフタイプは On-CPU / Off-CPU / Mixed の3種類 | E-01 (56行目 FlameGraphType), E-02 (29-54行目) | ○ |
| C-03 | サブタスク選択で "all" または個別サブタスクを選べる | E-01 (61-65行目 listOfSampleableSubtasks), E-02 (57-71行目) | ○ |
| C-04 | オペレーターがRUNNING/INITIALIZING以外だとサンプリング不可 | E-02 (19-26行目 状態チェック) | ○ |
| C-05 | endTimestamp = -1 でタスク終了メッセージ | E-02 (75行目 ngSwitchCase="-1") | ○ |
| C-06 | endTimestamp = -2 でフレームグラフ無効メッセージ | E-02 (76-79行目 ngSwitchCase="-2") | ○ |
| C-07 | endTimestamp = -3 でサンプル待ちメッセージ | E-02 (80行目 ngSwitchCase="-3") | ○ |
| C-08 | REST API パスは /jobs/{jobid}/vertices/{vertexid}/flamegraph | E-03 (122-126行目) | ○ |
| C-09 | サブタスク指定時は subtaskindex パラメータを追加 | E-03 (128-136行目) | ○ |
| C-10 | ngOnInit で requestRunningSubtasks と requestFlameGraph を呼び出す | E-01 (75-78行目) | ○ |
| C-11 | RUNNING/INITIALIZING のサブタスクのみ選択可能 | E-01 (133-135行目 filter) | ○ |
| C-12 | 関連機能はREST APIとメトリクスコア | E-06 (画面No.21の行) | ○ |
| C-13 | d3-flame-graph ライブラリを使用 | E-05 (23行目 import) | ○ |
| C-14 | Off-CPU タイプ時は offCpuColorMapper を使用 | E-05 (56-58行目) | ○ |
| C-15 | JobFlameGraph インターフェースに endTimestamp, data, graphType を持つ | E-04 (19-23行目) | ○ |
| C-16 | FlameGraphType enum は ON_CPU, OFF_CPU, FULL の3値 | E-04 (31-35行目) | ○ |
| C-17 | selectFrameGraphType でグラフタイプ変更時に再取得 | E-01 (156-159行目) | ○ |
| C-18 | selectSubtask でサブタスク変更時に再取得 | E-01 (149-154行目) | ○ |
| C-19 | destroy$ で既存サブスクリプションを破棄 | E-01 (150行目, 157行目) | ○ |
| C-20 | loadSubTasks でサブタスク一覧を取得 | E-03 (139-143行目) | ○ |
| C-21 | フレームグラフ描画は draw() メソッドで実行 | E-05 (38-63行目) | ○ |
| C-22 | ツールチップで関数名・パーセンテージ・サンプル数を表示 | E-05 (45-52行目) | ○ |
| C-23 | 頂点詳細ドロワーの Flamegraph タブからアクセス | E-07 (Vertex_Flamegraph の記述) | ○ |
| C-24 | On-CPU は RUNNABLE, NEW 状態のスレッド | E-02 (34行目 title属性) | ○ |
| C-25 | URLパスは /job/:status/:jid/overview/:vertexId/flamegraph | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25 の URL パス詳細について、routes.ts ファイルでのジョブ概要サブルーティング定義を直接確認できていない
  - 候補：`pages/job/routes.ts` / `pages/job/overview/routes.ts` / 親コンポーネントでの動的ルーティング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が明確
- 1: 中リスク - URLパス構造のみ推測に基づく部分あり

## 6) レビュアーチェックリスト（最小）
- [ ] URLパス `/job/:status/:jid/overview/:vertexId/flamegraph` が実際のルーティング定義と一致するか確認
- [ ] フレームグラフ機能の設定パラメータ `rest.flamegraph.enabled` がバックエンドで実装されているか確認
- [ ] Off-CPU の色設定が期待通りに動作するか画面上で確認
