---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-JobManager

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/routes.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/job-manager.config.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは /job-manager | E-03 (path: '' がルート) | ○ |
| C-02 | デフォルトで /job-manager/metrics にリダイレクト | E-03 (89-92行目 redirectTo: 'metrics') | ○ |
| C-03 | ナビゲーションタブは7種類（Metrics等） | E-01 (32-40行目 listOfNavigation) | ○ |
| C-04 | NavigationComponent を使用 | E-01 (22行目 import), E-02 (19行目) | ○ |
| C-05 | router-outlet で子コンポーネントを表示 | E-02 (20行目) | ○ |
| C-06 | OnPush変更検出戦略を使用 | E-01 (28行目 changeDetection) | ○ |
| C-07 | 子ルート /metrics は JobManagerMetricsComponent | E-03 (28-33行目) | ○ |
| C-08 | 子ルート /config は JobManagerConfigurationComponent | E-03 (35-42行目) | ○ |
| C-09 | 子ルート /logs は JobManagerLogsComponent | E-03 (43-48行目) | ○ |
| C-10 | 子ルート /stdout は JobManagerStdoutComponent | E-03 (49-54行目) | ○ |
| C-11 | 子ルート /log は JobManagerLogListComponent | E-03 (56-62行目) | ○ |
| C-12 | 子ルート /log/:logName は JobManagerLogDetailComponent | E-03 (63-70行目) | ○ |
| C-13 | 子ルート /thread-dump は JobManagerThreadDumpComponent | E-03 (71-78行目) | ○ |
| C-14 | 子ルート /profiler は JobManagerProfilerComponent | E-03 (79-86行目) | ○ |
| C-15 | 遅延ロード（loadComponent）を使用 | E-03 (全ての子ルートで loadComponent を使用) | ○ |
| C-16 | InjectionToken JOB_MANAGER_MODULE_CONFIG を定義 | E-04 (35-38行目) | ○ |
| C-17 | 関連機能は REST API とジョブ管理 | E-05 (画面No.22の行) | ○ |
| C-18 | グローバルナビゲーションからアクセス | E-06 (JM へのオーバービューからの遷移) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] NavigationComponent の動作が期待通りか画面上で確認
- [ ] 各タブへの遷移が正常に機能するか確認
- [ ] 不正なパスアクセス時のリダイレクト動作を確認
