---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-JobManagerメトリクス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/metrics/job-manager-metrics.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/metrics/job-manager-metrics.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/configuration.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは /job-manager/metrics | E-03 routes.ts (28行目 path: 'metrics') | ○ |
| C-02 | メトリクスは { [id: string]: number } 型 | E-01 (55行目) | ○ |
| C-03 | jmConfig は { [id: string]: string } 型 | E-01 (56行目) | ○ |
| C-04 | listOfGCMetric は Array<{name, count, time}> | E-01 (58行目) | ○ |
| C-05 | loadConfig で設定を取得 | E-01 (69-80行目), E-03 (43-45行目) | ○ |
| C-06 | /jobmanager/config API を使用 | E-03 (44行目) | ○ |
| C-07 | StatusService.refresh$ で自動リフレッシュ | E-01 (81行目 statusService.refresh$) | ○ |
| C-08 | loadMetricsName で GC メトリクス名を取得 | E-01 (82-88行目), E-03 (93-97行目) | ○ |
| C-09 | /jobmanager/metrics API を使用 | E-03 (95行目) | ○ |
| C-10 | loadMetrics でメトリクス値を取得 | E-01 (89-129行目), E-03 (99-112行目) | ○ |
| C-11 | Status.JVM.Memory.Heap.* メトリクスを取得 | E-01 (91-97行目) | ○ |
| C-12 | Status.JVM.Memory.Direct.* メトリクスを取得 | E-01 (101-103行目) | ○ |
| C-13 | Status.JVM.Memory.Mapped.* メトリクスを取得 | E-01 (104-106行目) | ○ |
| C-14 | GC メトリクスの重複除去ロジック | E-01 (111-127行目) | ○ |
| C-15 | Flink メモリモデル図を表示 | E-02 (45行目 process_mem_model.svg) | ○ |
| C-16 | プログレスバーでヒープ使用率を表示 | E-02 (53-66行目 nz-progress) | ○ |
| C-17 | JVM Heap 詳細テーブル | E-02 (152-158行目) | ○ |
| C-18 | Non-Heap 詳細テーブル | E-02 (159-164行目) | ○ |
| C-19 | Direct メモリテーブル | E-02 (186-191行目) | ○ |
| C-20 | Mapped メモリテーブル | E-02 (192-197行目) | ○ |
| C-21 | GC テーブル（ngFor でループ） | E-02 (220-227行目) | ○ |
| C-22 | 関連機能は REST API、メトリクスコア、設定管理 | E-05 (画面No.23の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] メトリクス値が正しく表示されるか画面上で確認
- [ ] プログレスバーの計算式（Used/Max * 100）が正確か確認
- [ ] GC情報が動的に取得・表示されるか確認
- [ ] 設定値とメトリクス値の対応が正しいか確認
