---
generated_at: 2026-02-02 11:00:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-JobManagerログ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-list/job-manager-log-list.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-list/job-manager-log-list.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは /job-manager/log | routes.ts (56-62行目) | ○ |
| C-02 | listOfLog は JobManagerLogItem[] 型 | E-01 (52行目) | ○ |
| C-03 | isLoading は boolean 型 | E-01 (53行目) | ○ |
| C-04 | JobManagerLogItem は name, size, mtime を持つ | E-04 (19-23行目) | ○ |
| C-05 | trackByName で name を返す | E-01 (45行目) | ○ |
| C-06 | sortLastModifiedTimeFn で mtime でソート | E-01 (48-49行目) | ○ |
| C-07 | sortSizeFn で size でソート | E-01 (50行目) | ○ |
| C-08 | JOB_MANAGER_MODULE_CONFIG をDI注入 | E-01 (61行目 @Inject) | ○ |
| C-09 | logRouterFactory を moduleConfig から取得 | E-01 (63-64行目) | ○ |
| C-10 | loadLogList でログ一覧取得 | E-01 (67-80行目), E-03 (65-69行目) | ○ |
| C-11 | /jobmanager/logs API を呼び出し | E-03 (66行目) | ○ |
| C-12 | レスポンスから logs 配列を抽出 | E-03 (68行目 map) | ○ |
| C-13 | catchError で空配列を返す | E-01 (71行目) | ○ |
| C-14 | 仮想スクロールを使用 | E-02 (27-30行目 nzVirtual*) | ○ |
| C-15 | テーブル列幅は 50%, 25%, 25% | E-02 (31行目 nzWidthConfig) | ○ |
| C-16 | 日時表示形式は yyyy-MM-dd HH:mm:ss.SSS | E-02 (49行目 humanizeDate) | ○ |
| C-17 | サイズは KB 単位で表示 | E-02 (50行目 / 1024) | ○ |
| C-18 | routerLink でログ詳細に遷移 | E-02 (45行目) | ○ |
| C-19 | 関連機能は REST API とジョブ管理 | E-05 (画面No.27の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ログファイル一覧が正しく表示されるか画面上で確認
- [ ] ソート機能が正常に動作するか確認
- [ ] ログファイル名クリックでログ詳細画面に遷移するか確認
- [ ] 大量のログファイルでも仮想スクロールが機能するか確認
