---
generated_at: 2026-02-02 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-JobManagerログ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-detail/job-manager-log-detail.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/log-detail/job-manager-log-detail.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは /job-manager/log/:logName | routes.ts (63-70行目) | ○ |
| C-02 | logs は string 型 | E-01 (56行目) | ○ |
| C-03 | logName は string 型 | E-01 (57行目) | ○ |
| C-04 | downloadUrl は string 型 | E-01 (58行目) | ○ |
| C-05 | isLoading は boolean 型 | E-01 (59行目) | ○ |
| C-06 | isFullScreen は boolean 型 | E-01 (60行目) | ○ |
| C-07 | ホストバインディングで full-screen クラス制御 | E-01 (41-43行目) | ○ |
| C-08 | activatedRoute.snapshot.params.logName で取得 | E-01 (75行目) | ○ |
| C-09 | ngOnInit で reload() を呼び出し | E-01 (76行目) | ○ |
| C-10 | loadLog(logName) でログ取得 | E-01 (87-88行目), E-03 (71-83行目) | ○ |
| C-11 | /jobmanager/logs/{logName} API を呼び出し | E-03 (72行目) | ○ |
| C-12 | レスポンスを { data, url } に変換 | E-03 (75-82行目) | ○ |
| C-13 | finalize で isLoading を false に設定 | E-01 (90-93行目) | ○ |
| C-14 | JobManagerLogDetail は data, url を持つ | E-04 (25-28行目) | ○ |
| C-15 | toggleFullScreen で isFullScreen を更新 | E-01 (102-104行目) | ○ |
| C-16 | パンくずリストを使用 | E-02 (20-30行目 nz-breadcrumb) | ○ |
| C-17 | routerLink="../" でログ一覧に戻る | E-02 (22行目) | ○ |
| C-18 | flink-addon-inline を使用 | E-02 (31行目) | ○ |
| C-19 | nz-code-editor を使用 | E-02 (40行目) | ○ |
| C-20 | 関連機能は REST API とジョブ管理 | E-05 (画面No.28の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ログファイル内容が正しく表示されるか画面上で確認
- [ ] パンくずリストでログ一覧に戻れるか確認
- [ ] 全画面モードが正常に動作するか確認
- [ ] ダウンロードリンクが正常に動作するか確認
- [ ] 存在しないログファイル名指定時のエラー処理を確認
