---
generated_at: 2026-02-02 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-JobManagerスレッドダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/thread-dump/job-manager-thread-dump.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/thread-dump/job-manager-thread-dump.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/job-manager.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは /job-manager/thread-dump | routes.ts (71-78行目) | ○ |
| C-02 | dump は string 型 | E-01 (45行目) | ○ |
| C-03 | downloadUrl は string 型 | E-01 (43行目) | ○ |
| C-04 | downloadName は "jobmanager_thread_dump" | E-01 (42行目) | ○ |
| C-05 | loading は boolean 型 | E-01 (46行目) | ○ |
| C-06 | JOB_MANAGER_MODULE_CONFIG をDI注入 | E-01 (54行目 @Inject) | ○ |
| C-07 | editorOptions は moduleConfig から取得 | E-01 (56行目) | ○ |
| C-08 | downloadUrl は BASE_URL + /jobmanager/thread-dump | E-01 (57行目) | ○ |
| C-09 | ngOnInit で reload() を呼び出し | E-01 (60-62行目) | ○ |
| C-10 | reload() で loading を true に設定 | E-01 (70-71行目) | ○ |
| C-11 | loadThreadDump でスレッドダンプ取得 | E-01 (72-82行目), E-03 (85-91行目) | ○ |
| C-12 | /jobmanager/thread-dump API を呼び出し | E-03 (86行目) | ○ |
| C-13 | threadInfos から stringifiedThreadInfo を結合 | E-03 (87-89行目) | ○ |
| C-14 | JobManagerThreadDump は threadInfos を持つ | E-04 (30-32行目) | ○ |
| C-15 | JobManagerThreadInfo は threadName, stringifiedThreadInfo を持つ | E-04 (34-37行目) | ○ |
| C-16 | nz-code-editor を使用 | E-02 (19行目) | ○ |
| C-17 | flink-addon-compact を使用 | E-02 (25行目) | ○ |
| C-18 | 関連機能は REST API とジョブ管理 | E-05 (画面No.29の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] スレッドダンプ内容が正しく表示されるか画面上で確認
- [ ] 再読み込みボタンでスレッドダンプが更新されるか確認
- [ ] ダウンロードリンクが正常に動作するか確認
- [ ] 全スレッドの情報が結合されて表示されているか確認
