---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-実行中ジョブ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/app/pages/job/job.component.ts`（全体）
- E-02: `src/app/pages/job/job.component.html`（全体）
- E-03: `src/app/components/job-list/job-list.component.ts`（全体）
- E-04: `src/app/services/job.service.ts`（66-81行目）
- E-05: `src/app/interfaces/job-overview.ts`（全体）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行4）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行7-8）
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは`/job/running` | E-06, E-08 | ○ |
| C-02 | GET `/jobs/overview`でジョブ一覧取得 | E-04（67行目） | ○ |
| C-03 | completed=falseでフィルタリング | E-03（103行目） | ○ |
| C-04 | isCompletedフラグで表示切り替え | E-01（37行目）, E-03（64行目） | ○ |
| C-05 | URLセグメントでrunning/completed判別 | E-01（72-77行目） | ○ |
| C-06 | ジョブ名でソート可能 | E-03（69行目） | ○ |
| C-07 | 開始時刻でソート可能 | E-03（70行目） | ○ |
| C-08 | 実行時間でソート可能 | E-03（71行目） | ○ |
| C-09 | 状態でソート可能 | E-03（73行目） | ○ |
| C-10 | INITIALIZING状態では詳細画面に遷移しない | E-03（80-84行目） | ○ |
| C-11 | INITIALIZING時はメッセージ表示 | E-03（81行目） | ○ |
| C-12 | ジョブクリックで詳細画面に遷移 | E-01（68-70行目）, E-03（79-85行目） | ○ |
| C-13 | タスク状態を表示 | E-05（36-49行目） | ○ |
| C-14 | StatusService.refresh$でデータ更新 | E-03（97-100行目） | ○ |
| C-15 | 機能No.32 REST APIが主機能 | E-07（行7） | ○ |
| C-16 | 機能No.23 ジョブ管理が補助機能 | E-07（行8） | ○ |
| C-17 | JobComponent + JobListComponentの構成 | E-01, E-02, E-03 | ○ |
| C-18 | ChangeDetectionStrategy.OnPushを使用 | E-01（32行目）, E-03（49行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：全ての主張がソースコードで直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] INITIALIZING状態のジョブに対するメッセージ表示がユーザーにとって分かりやすいか確認
- [ ] 大量のジョブがある場合のパフォーマンスを確認
- [ ] ソート機能の動作確認（特に日本語ジョブ名のソート順）
