---
generated_at: 2026-02-02 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-JobManagerプロファイラ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/profiler/job-manager-profiler.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/job-manager/profiler/job-manager-profiler.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/job-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/job-profiler.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは /job-manager/profiler | routes.ts (79-86行目) | ○ |
| C-02 | profilingList は ProfilingDetail[] 型 | E-01 (61行目) | ○ |
| C-03 | isLoading は boolean 型 | E-01 (62行目) | ○ |
| C-04 | isCreating は boolean 型 | E-01 (63行目) | ○ |
| C-05 | duration のデフォルト値は 30 | E-01 (64行目) | ○ |
| C-06 | selectMode のデフォルト値は 'ITIMER' | E-01 (65行目) | ○ |
| C-07 | isEnabled は boolean 型 | E-01 (66行目) | ○ |
| C-08 | ProfilingDetail は status, triggerTime, finishedTime, duration, message, outputFile, mode を持つ | E-04 (23-31行目) | ○ |
| C-09 | ProfilingList は profilingList 配列を持つ | E-04 (19-21行目) | ○ |
| C-10 | StatusService.refresh$ で自動リフレッシュ | E-01 (95-97行目) | ○ |
| C-11 | createProfilingInstance で実行中チェック | E-01 (76-79行目) | ○ |
| C-12 | 実行中の場合 "Please wait for last profiling finished." を表示 | E-01 (77-78行目) | ○ |
| C-13 | createProfilingInstance API を POST で呼び出し | E-03 (134-137行目) | ○ |
| C-14 | loadProfilingList API を GET で呼び出し | E-03 (130-132行目) | ○ |
| C-15 | loadProfilingResult API で結果取得 | E-03 (139-151行目) | ○ |
| C-16 | downloadProfilingResult で anchor 要素を生成 | E-01 (126-130行目) | ○ |
| C-17 | プロファイリングモードは CPU/LOCK/WALL/ALLOC/ITIMER | E-02 (43-82行目) | ○ |
| C-18 | CPU モードのツールチップ説明 | E-02 (46-49行目) | ○ |
| C-19 | Lock モードのツールチップ説明 | E-02 (52-55行目) | ○ |
| C-20 | Wall-Clock モードのツールチップ説明 | E-02 (58-61行目) | ○ |
| C-21 | Allocation モードのツールチップ説明 | E-02 (67-70行目) | ○ |
| C-22 | ITIMER モードのツールチップ説明 | E-02 (75-78行目) | ○ |
| C-23 | async-profiler の wiki へのリンク | E-02 (110-115行目) | ○ |
| C-24 | 機能無効時の警告メッセージ | E-02 (123-129行目 nz-alert) | ○ |
| C-25 | isEnabled が false の場合ボタン無効化 | E-02 (92行目 [disabled]) | ○ |
| C-26 | テーブル列は Index, Trigger Time, Finished Time, Duration, Mode, Status, Link, Message | E-02 (140-148行目) | ○ |
| C-27 | humanizeWatermarkToDatetime パイプで日時表示 | E-02 (153-154行目) | ○ |
| C-28 | 関連機能は REST API とメトリクスコア | E-05 (画面No.30の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] プロファイリング機能が有効な環境でプロファイリング作成ができるか確認
- [ ] プロファイリング機能が無効な環境で警告メッセージが表示されるか確認
- [ ] 実行中のプロファイリングがある場合に再作成がブロックされるか確認
- [ ] プロファイリング結果のダウンロードが正常に動作するか確認
- [ ] 各プロファイリングモードの説明ツールチップが表示されるか確認
