---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：31-TaskManager一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/list/task-manager-list.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/list/task-manager-list.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/task-manager` である | E-07 画面遷移図.md 159行目 | ○ |
| C-02 | TaskManagerServiceのloadManagers()でデータ取得 | E-01 77-87行目、E-03 44-49行目 | ○ |
| C-03 | /taskmanagers APIを呼び出す | E-03 45行目 | ○ |
| C-04 | 表示項目にPath/ID、Data Port、Last Heartbeat等がある | E-02 30-40行目、E-04 65-75行目 | ○ |
| C-05 | 各列のソート機能がある | E-01 48-56行目、E-02 31-39行目 | ○ |
| C-06 | クリックで詳細画面（/task-manager/:id/metrics）へ遷移 | E-01 63-67行目 | ○ |
| C-07 | queryParamsHandling: 'preserve'でパラメータ保持 | E-01 65行目 | ○ |
| C-08 | StatusService.refresh$でポーリング | E-01 78行目 | ○ |
| C-09 | catchError(() => of([]))でエラーハンドリング | E-01 80行目 | ○ |
| C-10 | ChangeDetectionStrategy.OnPush適用 | E-01 41行目 | ○ |
| C-11 | テーブルスクロール高さはcalc(100vh - 260px) | E-02 23行目 | ○ |
| C-12 | テーブル幅は1250px | E-02 23行目 | ○ |
| C-13 | BlockedBadgeコンポーネント使用 | E-01 25行目、E-02 51行目 | ○ |
| C-14 | HumanizeBytesPipeでメモリ表示 | E-01 26行目、E-02 60-67行目 | ○ |
| C-15 | TaskManagersItemインターフェースにhardwareプロパティあり | E-04 65-75行目 | ○ |
| C-16 | 関連機能No.32 REST API | E-06 65行目 | ○ |
| C-17 | 関連機能No.24 タスク実行 | E-06 66行目 | ○ |
| C-18 | カテゴリはTaskManager | E-05 32行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目がソースコードのHTMLテンプレートと一致しているか確認
- [ ] ソート関数の列がすべて網羅されているか確認
- [ ] 遷移先URLが正しいか確認
