---
generated_at: 2026-02-02 10:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-TaskManager詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/task-manager.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/task-manager.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/status/task-manager-status.component.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/status/task-manager-status.component.html`
- E-05: `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts`
- E-06: `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは /task-manager/:taskManagerId である | E-08 26行目 | ○ |
| C-02 | TaskManagerStatusComponentとRouterOutletを配置 | E-01 29行目、E-02 19-22行目 | ○ |
| C-03 | タブナビゲーションにMetrics/Logs/Stdout/Log List/Thread Dump/Profilerがある | E-03 49-56行目 | ○ |
| C-04 | loadManager()でTaskManager詳細を取得 | E-05 51-54行目 | ○ |
| C-05 | /taskmanagers/{taskmanagerid} APIを呼び出す | E-05 53行目 | ○ |
| C-06 | StatusService.refresh$でポーリング | E-03 70行目 | ○ |
| C-07 | 表示項目にPath、Free/All Slots、Assigned Tasks等がある | E-04 25-51行目 | ○ |
| C-08 | BlockedBadgeコンポーネント使用 | E-03 25行目、E-04 22行目 | ○ |
| C-09 | NzDescriptionsModuleで情報表示 | E-03 41行目、E-04 24行目 | ○ |
| C-10 | NavigationComponentでタブ表示 | E-03 27行目、E-04 53行目 | ○ |
| C-11 | スケルトンローディング対応 | E-03 45行目、E-04 56-58行目 | ○ |
| C-12 | catchError(() => of(undefined))でエラーハンドリング | E-03 75行目 | ○ |
| C-13 | ChangeDetectionStrategy.OnPush適用 | E-01 28行目、E-03 37行目 | ○ |
| C-14 | 関連機能No.32 REST API | E-07 67行目 | ○ |
| C-15 | 関連機能No.24 タスク実行 | E-07 68行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] ナビゲーションタブのパスが正しいか確認
- [ ] 表示項目がHTMLテンプレートと一致しているか確認
- [ ] コンテナとサブ画面の関係が正しく記述されているか確認
