---
generated_at: 2026-02-02 10:34:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-TaskManagerメトリクス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/metrics/task-manager-metrics.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/metrics/task-manager-metrics.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは /task-manager/:taskManagerId/metrics である | E-06 27行目 | ○ |
| C-02 | loadManager()とloadMetrics()でデータ取得 | E-01 67-81行目、89-109行目 | ○ |
| C-03 | /taskmanagers/{id}/metrics APIを呼び出す | E-03 101-116行目 | ○ |
| C-04 | 8種類のメトリクス名を指定して取得 | E-01 91-100行目 | ○ |
| C-05 | Memoryカードに Framework Heap、Task Heap等を表示 | E-02 19-165行目 | ○ |
| C-06 | プログレスバー（nz-progress）で使用率表示 | E-02 52-61行目 | ○ |
| C-07 | Advancedカードに JVM Memory、Outside JVM Memory等を表示 | E-02 167-295行目 | ○ |
| C-08 | Resourcesカードに Unassigned resources、Allocated slotsを表示 | E-02 321-421行目 | ○ |
| C-09 | Garbage Collectionテーブルを表示 | E-02 277-293行目 | ○ |
| C-10 | ツールチップでメトリクス説明を表示 | E-02 35-39行目、67-69行目 | ○ |
| C-11 | StatusService.refresh$でポーリング | E-01 69行目 | ○ |
| C-12 | catchError(() => of({} as MetricMap))でメトリクスエラーハンドリング | E-01 102行目 | ○ |
| C-13 | ChangeDetectionStrategy.OnPush適用 | E-01 39行目 | ○ |
| C-14 | humanizeBytesで値変換 | E-01 25行目、E-02 49行目 | ○ |
| C-15 | 関連機能No.32 REST API | E-05 69行目 | ○ |
| C-16 | 関連機能No.57 メトリクスコア | E-05 70行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 取得するメトリクス名が正しいか確認
- [ ] 表示項目とHTMLテンプレートの対応が正しいか確認
- [ ] プログレスバーの計算式が正しいか確認
